/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.util.adventure;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.netty.buffer.ByteBufHelper;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.netty.buffer.ByteBufInputStream;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.netty.buffer.ByteBufOutputStream;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.netty.buffer.UnpooledByteBufAllocationHelper;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBT;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.codec.NBTCodec;
import me.caseload.knockbacksync.shaded.net.kyori.adventure.nbt.BinaryTag;
import me.caseload.knockbacksync.shaded.net.kyori.adventure.nbt.BinaryTagType;
import me.caseload.knockbacksync.shaded.net.kyori.adventure.nbt.BinaryTagTypes;
import me.caseload.knockbacksync.shaded.net.kyori.adventure.nbt.EndBinaryTag;
import me.caseload.knockbacksync.shaded.net.kyori.adventure.nbt.TagStringIO;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class AdventureNbtUtil {
    private static final BinaryTagType<?>[] NBT_TAG_TYPES = AdventureNbtUtil.buildNbtTagTypes();

    private AdventureNbtUtil() {
    }

    private static BinaryTagType<?>[] buildNbtTagTypes() {
        BinaryTagTypes.BYTE.id();
        List types = null;
        try {
            for (Field field : BinaryTagType.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !List.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                Object value = field.get(null);
                if (!(value instanceof List) || !((List)value).contains(BinaryTagTypes.BYTE)) continue;
                types = (List)value;
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error scanning for Adventure NBT registry", e);
        }
        if (types == null) {
            throw new RuntimeException("Could not locate Adventure NBT registry field (mapping mismatch?)");
        }
        BinaryTagType[] nbtTagTypes = new BinaryTagType[types.size()];
        for (int i = 0; i < nbtTagTypes.length; ++i) {
            BinaryTagType type = (BinaryTagType)types.get(i);
            if (type.id() != i) {
                throw new IllegalStateException("Registered nbt tag types are wrong: " + type.id() + " != " + i);
            }
            nbtTagTypes[i] = type;
        }
        return nbtTagTypes;
    }

    public static BinaryTag readAdventureTag(Object buf) {
        byte tagTypeId = ByteBufHelper.readByte(buf);
        if (tagTypeId == BinaryTagTypes.END.id()) {
            return EndBinaryTag.endBinaryTag();
        }
        BinaryTagType<?> tagType = NBT_TAG_TYPES[tagTypeId];
        try {
            return tagType.read(new ByteBufInputStream(buf));
        }
        catch (IOException exception) {
            throw new RuntimeException("Error while reading adventure nbt tag from buf: " + buf, exception);
        }
    }

    public static void writeAdventureTag(Object buf, BinaryTag tag) {
        BinaryTagType<? extends BinaryTag> tagType = tag.type();
        ByteBufHelper.writeByte(buf, tagType.id());
        if (tagType.id() != BinaryTagTypes.END.id()) {
            try {
                tagType.write(tag, new ByteBufOutputStream(buf));
            }
            catch (IOException exception) {
                throw new RuntimeException("Error while writing adventure nbt tag to buf: " + tag, exception);
            }
        }
    }

    public static NBT fromAdventure(BinaryTag tag) {
        Object buf = UnpooledByteBufAllocationHelper.buffer();
        try {
            AdventureNbtUtil.writeAdventureTag(buf, tag);
            NBT nBT = NBTCodec.readNBTFromBuffer(buf, ServerVersion.getLatest());
            return nBT;
        }
        finally {
            ByteBufHelper.release(buf);
        }
    }

    public static BinaryTag toAdventure(NBT tag) {
        Object buf = UnpooledByteBufAllocationHelper.buffer();
        try {
            NBTCodec.writeNBTToBuffer(buf, ServerVersion.getLatest(), tag);
            BinaryTag binaryTag = AdventureNbtUtil.readAdventureTag(buf);
            return binaryTag;
        }
        finally {
            ByteBufHelper.release(buf);
        }
    }

    public static NBT fromString(String string) {
        BinaryTag advTag;
        try {
            advTag = TagStringIO.tagStringIO().asTag(string);
        }
        catch (IOException exception) {
            throw new RuntimeException("Error while decoding nbt from string: " + string, exception);
        }
        return AdventureNbtUtil.fromAdventure(advTag);
    }

    public static String toString(NBT tag) {
        BinaryTag advTag = AdventureNbtUtil.toAdventure(tag);
        try {
            return TagStringIO.tagStringIO().asString(advTag);
        }
        catch (IOException exception) {
            throw new RuntimeException("Error while encoding nbt to string: " + advTag, exception);
        }
    }
}

