/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.wrapper.common.server;

import java.util.List;
import java.util.Objects;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import me.caseload.knockbacksync.shaded.net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public abstract class WrapperCommonServerServerLinks<T extends WrapperCommonServerServerLinks<T>>
extends PacketWrapper<T> {
    private List<ServerLink> links;

    public WrapperCommonServerServerLinks(PacketSendEvent event) {
        super(event);
    }

    public WrapperCommonServerServerLinks(PacketTypeCommon packetType, List<ServerLink> links) {
        super(packetType);
        this.links = links;
    }

    @Override
    public void read() {
        this.links = this.readList(ServerLink::read);
    }

    @Override
    public void write() {
        this.writeList(this.links, ServerLink::write);
    }

    @Override
    public void copy(T wrapper) {
        this.links = ((WrapperCommonServerServerLinks)wrapper).getLinks();
    }

    public List<ServerLink> getLinks() {
        return this.links;
    }

    public void setLinks(List<ServerLink> links) {
        this.links = links;
    }

    public static final class ServerLink {
        @Nullable
        private final KnownType knownType;
        @Nullable
        private final Component customType;
        private final String url;

        public ServerLink(@Nullable KnownType knownType, @Nullable Component customType, String url) {
            if (knownType == null == (customType == null)) {
                throw new IllegalStateException("Illegal state of both known type and custom type combined: " + (Object)((Object)knownType) + " / " + customType);
            }
            this.knownType = knownType;
            this.customType = customType;
            this.url = url;
        }

        public static ServerLink read(PacketWrapper<?> wrapper) {
            Component customType;
            KnownType knownType;
            if (wrapper.readBoolean()) {
                knownType = (KnownType)wrapper.readEnum(KnownType.values());
                customType = null;
            } else {
                knownType = null;
                customType = wrapper.readComponent();
            }
            String url = wrapper.readString();
            return new ServerLink(knownType, customType, url);
        }

        public static void write(PacketWrapper<?> wrapper, ServerLink link) {
            if (link.getKnownType() != null) {
                wrapper.writeBoolean(true);
                wrapper.writeEnum(link.getKnownType());
            } else {
                assert (link.getCustomType() != null);
                wrapper.writeBoolean(false);
                wrapper.writeComponent(link.getCustomType());
            }
            wrapper.writeString(link.getUrl());
        }

        public ServerLink(KnownType knownType, String url) {
            this(knownType, null, url);
        }

        public ServerLink(Component customType, String url) {
            this(null, customType, url);
        }

        @Nullable
        public KnownType getKnownType() {
            return this.knownType;
        }

        @Nullable
        public Component getCustomType() {
            return this.customType;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ServerLink)) {
                return false;
            }
            ServerLink that = (ServerLink)obj;
            if (this.knownType != that.knownType) {
                return false;
            }
            if (!Objects.equals(this.customType, that.customType)) {
                return false;
            }
            return this.url.equals(that.url);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.knownType, this.customType, this.url});
        }

        public String toString() {
            return "ServerLink{knownType=" + (Object)((Object)this.knownType) + ", customType=" + this.customType + ", url='" + this.url + '\'' + '}';
        }
    }

    public static enum KnownType {
        BUG_REPORT,
        COMMUNITY_GUIDELINES,
        SUPPORT,
        STATUS,
        FEEDBACK,
        COMMUNITY,
        WEBSITE,
        FORUMS,
        NEWS,
        ANNOUNCEMENTS;

    }
}

