/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit;

import java.lang.reflect.Method;
import me.caseload.knockbacksync.shaded.io.leangen.geantyref.TypeToken;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.CommandManager;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.BukkitParserParameters;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.CloudBukkitCapabilities;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.annotation.specifier.AllowEmptySelection;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.annotation.specifier.DefaultNamespace;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.annotation.specifier.RequireExplicitNamespace;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.data.MultipleEntitySelector;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.data.MultiplePlayerSelector;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.internal.CraftBukkitReflection;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.parser.BlockPredicateParser;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.parser.EnchantmentParser;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.parser.ItemStackParser;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.parser.ItemStackPredicateParser;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.parser.MaterialParser;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.parser.NamespacedKeyParser;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.parser.OfflinePlayerParser;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.parser.PlayerParser;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.parser.WorldParser;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.parser.location.Location2DParser;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.parser.location.LocationParser;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.parser.selector.MultipleEntitySelectorParser;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.parser.selector.MultiplePlayerSelectorParser;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.parser.selector.SingleEntitySelectorParser;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.parser.selector.SinglePlayerSelectorParser;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.parser.ParserParameters;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL)
public final class BukkitParsers {
    private BukkitParsers() {
    }

    public static <C> void register(CommandManager<C> manager) {
        manager.parserRegistry().registerParser(WorldParser.worldParser()).registerParser(MaterialParser.materialParser()).registerParser(PlayerParser.playerParser()).registerParser(OfflinePlayerParser.offlinePlayerParser()).registerParser(EnchantmentParser.enchantmentParser()).registerParser(LocationParser.locationParser()).registerParser(Location2DParser.location2DParser()).registerParser(ItemStackParser.itemStackParser()).registerParser(SingleEntitySelectorParser.singleEntitySelectorParser()).registerParser(SinglePlayerSelectorParser.singlePlayerSelectorParser());
        manager.parserRegistry().registerAnnotationMapper(AllowEmptySelection.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, annotation.value()));
        manager.parserRegistry().registerParserSupplier(TypeToken.get(MultipleEntitySelector.class), parserParameters -> new MultipleEntitySelectorParser(parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, true)));
        manager.parserRegistry().registerParserSupplier(TypeToken.get(MultiplePlayerSelector.class), parserParameters -> new MultiplePlayerSelectorParser(parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, true)));
        if (CraftBukkitReflection.classExists("org.bukkit.NamespacedKey")) {
            BukkitParsers.registerParserSupplierFor(manager, NamespacedKeyParser.class);
            manager.parserRegistry().registerAnnotationMapper(RequireExplicitNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.REQUIRE_EXPLICIT_NAMESPACE, true));
            manager.parserRegistry().registerAnnotationMapper(DefaultNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.DEFAULT_NAMESPACE, annotation.value()));
        }
        if (manager.hasCapability(CloudBukkitCapabilities.BRIGADIER)) {
            BukkitParsers.registerParserSupplierFor(manager, ItemStackPredicateParser.class);
            BukkitParsers.registerParserSupplierFor(manager, BlockPredicateParser.class);
        }
    }

    private static void registerParserSupplierFor(CommandManager<?> manager, @NonNull Class<?> argumentClass) {
        try {
            Method registerParserSuppliers = argumentClass.getDeclaredMethod("registerParserSupplier", CommandManager.class);
            registerParserSuppliers.setAccessible(true);
            registerParserSuppliers.invoke(null, manager);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

