/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.org.kohsuke.github;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLHandshakeException;
import me.caseload.knockbacksync.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import me.caseload.knockbacksync.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import me.caseload.knockbacksync.shaded.com.fasterxml.jackson.databind.InjectableValues;
import me.caseload.knockbacksync.shaded.com.fasterxml.jackson.databind.MapperFeature;
import me.caseload.knockbacksync.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import me.caseload.knockbacksync.shaded.com.fasterxml.jackson.databind.ObjectReader;
import me.caseload.knockbacksync.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import me.caseload.knockbacksync.shaded.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import me.caseload.knockbacksync.shaded.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import me.caseload.knockbacksync.shaded.org.apache.commons.io.IOUtils;
import me.caseload.knockbacksync.shaded.org.apache.commons.lang3.StringUtils;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHFileNotFoundException;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHIOException;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHOTPRequiredException;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHRateLimit;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHub;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHubAbuseLimitHandler;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHubConnectorResponseErrorHandler;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHubRateLimitChecker;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHubRateLimitHandler;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHubRequest;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHubResponse;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHubSanityCachedValue;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.HttpConnector;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.HttpException;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.JsonRateLimit;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.RateLimitTarget;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.authorization.AuthorizationProvider;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.authorization.UserAuthorizationProvider;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.connector.GitHubConnector;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.connector.GitHubConnectorRequest;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.connector.GitHubConnectorResponse;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.function.FunctionThrows;

class GitHubClient {
    private static final int DEFAULT_CONNECTION_ERROR_RETRIES = 2;
    private static final int DEFAULT_MINIMUM_RETRY_MILLIS = 100;
    private static final int DEFAULT_MAXIMUM_RETRY_MILLIS = 100;
    private static final ThreadLocal<String> sendRequestTraceId = new ThreadLocal();
    private final String apiUrl;
    private final GitHubRateLimitHandler rateLimitHandler;
    private final GitHubAbuseLimitHandler abuseLimitHandler;
    private final GitHubRateLimitChecker rateLimitChecker;
    private final AuthorizationProvider authorizationProvider;
    private GitHubConnector connector;
    @Nonnull
    private final AtomicReference<GHRateLimit> rateLimit = new AtomicReference<GHRateLimit>(GHRateLimit.DEFAULT);
    @Nonnull
    private final GitHubSanityCachedValue<GHRateLimit> sanityCachedRateLimit = new GitHubSanityCachedValue();
    @Nonnull
    private GitHubSanityCachedValue<Boolean> sanityCachedIsCredentialValid = new GitHubSanityCachedValue();
    private static final Logger LOGGER = Logger.getLogger(GitHubClient.class.getName());
    private static final ObjectMapper MAPPER = new ObjectMapper();
    static final String GITHUB_URL = "https://api.github.com";
    private static final DateTimeFormatter DATE_TIME_PARSER_SLASHES = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss Z");

    GitHubClient(String apiUrl, GitHubConnector connector, GitHubRateLimitHandler rateLimitHandler, GitHubAbuseLimitHandler abuseLimitHandler, GitHubRateLimitChecker rateLimitChecker, AuthorizationProvider authorizationProvider) throws IOException {
        if (apiUrl.endsWith("/")) {
            apiUrl = apiUrl.substring(0, apiUrl.length() - 1);
        }
        if (null == connector) {
            connector = GitHubConnector.DEFAULT;
        }
        this.apiUrl = apiUrl;
        this.connector = connector;
        this.authorizationProvider = authorizationProvider;
        this.rateLimitHandler = rateLimitHandler;
        this.abuseLimitHandler = abuseLimitHandler;
        this.rateLimitChecker = rateLimitChecker;
    }

    String getLogin() {
        try {
            if (this.authorizationProvider instanceof UserAuthorizationProvider && this.authorizationProvider.getEncodedAuthorization() != null) {
                UserAuthorizationProvider userAuthorizationProvider = (UserAuthorizationProvider)this.authorizationProvider;
                return userAuthorizationProvider.getLogin();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private <T> T fetch(Class<T> type, String urlPath) throws IOException {
        GitHubRequest request = ((GitHubRequest.Builder)((GitHubRequest.Builder)GitHubRequest.newBuilder().withApiUrl(this.getApiUrl())).withUrlPath(urlPath, new String[0])).build();
        return this.sendRequest(request, connectorResponse -> GitHubResponse.parseBody(connectorResponse, type)).body();
    }

    public boolean isCredentialValid() {
        return this.sanityCachedIsCredentialValid.get(() -> {
            try {
                this.getRateLimit();
                return Boolean.TRUE;
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, e, () -> String.format("(%s) Exception validating credentials on %s with login '%s'", sendRequestTraceId.get(), this.getApiUrl(), this.getLogin()));
                return Boolean.FALSE;
            }
        });
    }

    public boolean isOffline() {
        return this.connector == GitHubConnector.OFFLINE;
    }

    @Deprecated
    public HttpConnector getConnector() {
        if (!(this.connector instanceof HttpConnector)) {
            throw new UnsupportedOperationException("This GitHubConnector does not support HttpConnector.connect().");
        }
        LOGGER.warning("HttpConnector and getConnector() are deprecated. Please file an issue describing your use case.");
        return (HttpConnector)((Object)this.connector);
    }

    @Deprecated
    public void setConnector(GitHubConnector connector) {
        LOGGER.warning("Connector should not be changed. Please file an issue describing your use case.");
        this.connector = connector;
    }

    public boolean isAnonymous() {
        try {
            return this.getLogin() == null && this.authorizationProvider.getEncodedAuthorization() == null;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Nonnull
    public GHRateLimit getRateLimit() throws IOException {
        return this.getRateLimit(RateLimitTarget.NONE);
    }

    @CheckForNull
    String getEncodedAuthorization() throws IOException {
        return this.authorizationProvider.getEncodedAuthorization();
    }

    @Nonnull
    GHRateLimit getRateLimit(@Nonnull RateLimitTarget rateLimitTarget) throws IOException {
        GHRateLimit output = this.sanityCachedRateLimit.get(currentValue -> currentValue == null || currentValue.getRecord(rateLimitTarget).isExpired(), () -> {
            GHRateLimit result;
            try {
                GitHubRequest request = ((GitHubRequest.Builder)((GitHubRequest.Builder)((GitHubRequest.Builder)GitHubRequest.newBuilder().rateLimit(RateLimitTarget.NONE)).withApiUrl(this.getApiUrl())).withUrlPath("/rate_limit", new String[0])).build();
                result = ((JsonRateLimit)this.sendRequest((GitHubRequest)request, (BodyHandler)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getRateLimit$4(me.caseload.knockbacksync.shaded.org.kohsuke.github.connector.GitHubConnectorResponse ), (Lme/caseload/knockbacksync/shaded/org/kohsuke/github/connector/GitHubConnectorResponse;)Lme/caseload/knockbacksync/shaded/org/kohsuke/github/JsonRateLimit;)()).body()).resources;
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.FINE, "(%s) /rate_limit returned 404 Not Found.", sendRequestTraceId.get());
                result = GHRateLimit.fromRecord(GHRateLimit.UnknownLimitRecord.current(), rateLimitTarget);
            }
            return result;
        });
        return this.updateRateLimit(output);
    }

    @Nonnull
    @Deprecated
    GHRateLimit lastRateLimit() {
        return this.rateLimit.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    GHRateLimit rateLimit(@Nonnull RateLimitTarget rateLimitTarget) throws IOException {
        GHRateLimit result = this.rateLimit.get();
        if (result.getRecord(rateLimitTarget).isExpired()) {
            GitHubClient gitHubClient = this;
            synchronized (gitHubClient) {
                if (this.rateLimit.get().getRecord(rateLimitTarget).isExpired()) {
                    this.getRateLimit(rateLimitTarget);
                }
            }
            result = this.rateLimit.get();
        }
        return result;
    }

    private GHRateLimit updateRateLimit(@Nonnull GHRateLimit observed) {
        GHRateLimit result = this.rateLimit.accumulateAndGet(observed, (current, x) -> current.getMergedRateLimit((GHRateLimit)x));
        LOGGER.log(Level.FINEST, "Rate limit now: {0}", this.rateLimit.get());
        return result;
    }

    public void checkApiUrlValidity() throws IOException {
        try {
            this.fetch(GHApiInfo.class, "/").check(this.getApiUrl());
        }
        catch (IOException e) {
            if (this.isPrivateModeEnabled()) {
                throw (IOException)new IOException("GitHub Enterprise server (" + this.getApiUrl() + ") with private mode enabled").initCause(e);
            }
            throw e;
        }
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    @Nonnull
    public <T> GitHubResponse<T> sendRequest(@Nonnull GitHubRequest.Builder<?> builder, @CheckForNull BodyHandler<T> handler) throws IOException {
        return this.sendRequest(builder.build(), handler);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public <T> GitHubResponse<T> sendRequest(GitHubRequest request, @CheckForNull BodyHandler<T> handler) throws IOException {
        int retryCount;
        int retries = retryCount = Math.max(2, Integer.getInteger(GitHubClient.class.getName() + ".retryCount", 2));
        sendRequestTraceId.set(Integer.toHexString(request.hashCode()));
        GitHubConnectorRequest connectorRequest = GitHubClient.prepareConnectorRequest(request, this.authorizationProvider);
        do {
            GitHubConnectorResponse connectorResponse = null;
            try {
                this.logRequest(connectorRequest);
                this.rateLimitChecker.checkRateLimit(this, request.rateLimitTarget());
                connectorResponse = this.connector.send(connectorRequest);
                this.logResponse(connectorResponse);
                this.noteRateLimit(request.rateLimitTarget(), connectorResponse);
                this.detectKnownErrors(connectorResponse, request, handler != null);
                this.logResponseBody(connectorResponse);
                GitHubResponse<T> gitHubResponse = GitHubClient.createResponse(connectorResponse, handler);
                IOUtils.closeQuietly((Closeable)connectorResponse);
                return gitHubResponse;
            }
            catch (RetryRequestException e) {
                if (retries <= 0 || e.connectorRequest == null) continue;
                connectorRequest = e.connectorRequest;
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (SocketException | SocketTimeoutException | SSLHandshakeException e2) {
                    if (retries <= 0) throw GitHubClient.interpretApiError(e2, connectorRequest, connectorResponse);
                    GitHubClient.logRetryConnectionError(e2, connectorRequest.url(), retries);
                    continue;
                    catch (IOException e3) {
                        throw GitHubClient.interpretApiError(e3, connectorRequest, connectorResponse);
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(connectorResponse);
            }
        } while (--retries >= 0);
        throw new GHIOException("Ran out of retries for URL: " + request.url().toString());
    }

    private void detectKnownErrors(GitHubConnectorResponse connectorResponse, GitHubRequest request, boolean detectStatusCodeError) throws IOException {
        GitHubClient.detectOTPRequired(connectorResponse);
        this.detectInvalidCached404Response(connectorResponse, request);
        this.detectExpiredToken(connectorResponse, request);
        this.detectRedirect(connectorResponse, request);
        if (this.rateLimitHandler.isError(connectorResponse)) {
            this.rateLimitHandler.onError(connectorResponse);
            throw new RetryRequestException();
        }
        if (this.abuseLimitHandler.isError(connectorResponse)) {
            this.abuseLimitHandler.onError(connectorResponse);
            throw new RetryRequestException();
        }
        if (detectStatusCodeError && GitHubConnectorResponseErrorHandler.STATUS_HTTP_BAD_REQUEST_OR_GREATER.isError(connectorResponse)) {
            GitHubConnectorResponseErrorHandler.STATUS_HTTP_BAD_REQUEST_OR_GREATER.onError(connectorResponse);
        }
    }

    private void detectExpiredToken(GitHubConnectorResponse connectorResponse, GitHubRequest request) throws IOException {
        if (connectorResponse.statusCode() != 401) {
            return;
        }
        String originalAuthorization = connectorResponse.request().header("Authorization");
        if (Objects.isNull(originalAuthorization) || originalAuthorization.isEmpty()) {
            return;
        }
        GitHubConnectorRequest updatedRequest = GitHubClient.prepareConnectorRequest(request, this.authorizationProvider);
        String updatedAuthorization = updatedRequest.header("Authorization");
        if (!originalAuthorization.equals(updatedAuthorization)) {
            throw new RetryRequestException(updatedRequest);
        }
    }

    private void detectRedirect(GitHubConnectorResponse connectorResponse, GitHubRequest request) throws IOException {
        if (GitHubClient.isRedirecting(connectorResponse.statusCode())) {
            GitHubConnectorRequest updatedRequest = this.prepareRedirectRequest(connectorResponse, request);
            throw new RetryRequestException(updatedRequest);
        }
    }

    private GitHubConnectorRequest prepareRedirectRequest(GitHubConnectorResponse connectorResponse, GitHubRequest request) throws IOException {
        boolean sameHost;
        URI requestUri = URI.create(request.url().toString());
        URI redirectedUri = GitHubClient.getRedirectedUri(requestUri, connectorResponse);
        boolean bl = sameHost = redirectedUri.getHost().equalsIgnoreCase(request.url().getHost()) && redirectedUri.getPort() == request.url().getPort();
        if (!requestUri.getScheme().equalsIgnoreCase(redirectedUri.getScheme()) && !"https".equalsIgnoreCase(redirectedUri.getScheme())) {
            throw new HttpException("Attemped to redirect to a different scheme and the target scheme as not https.", connectorResponse.statusCode(), "Redirect", connectorResponse.request().url().toString());
        }
        String redirectedMethod = GitHubClient.getRedirectedMethod(connectorResponse.statusCode(), request.method());
        Object requestBuilder = ((GitHubRequest.Builder)request.toBuilder().setRawUrlPath(redirectedUri.toString())).method(redirectedMethod);
        AuthorizationProvider provider = this.authorizationProvider;
        if (!sameHost) {
            ((GitHubRequest.Builder)requestBuilder).removeHeader("Authorization");
            provider = AuthorizationProvider.ANONYMOUS;
        }
        return GitHubClient.prepareConnectorRequest(((GitHubRequest.Builder)requestBuilder).build(), provider);
    }

    private static URI getRedirectedUri(URI requestUri, GitHubConnectorResponse connectorResponse) throws IOException {
        URI redirectedURI = Optional.of(connectorResponse.header("Location")).map(URI::create).orElseThrow(() -> new IOException("Invalid redirection"));
        redirectedURI = requestUri.resolve(redirectedURI);
        return redirectedURI;
    }

    private static boolean isRedirecting(int statusCode) {
        return statusCode == 301 || statusCode == 302 || statusCode == 303 || statusCode == 307 || statusCode == 308;
    }

    private static String getRedirectedMethod(int statusCode, String originalMethod) {
        switch (statusCode) {
            case 301: 
            case 302: {
                return originalMethod.equals("POST") ? "GET" : originalMethod;
            }
            case 303: {
                return "GET";
            }
            case 307: 
            case 308: {
                return originalMethod;
            }
        }
        return originalMethod;
    }

    private static GitHubConnectorRequest prepareConnectorRequest(GitHubRequest request, AuthorizationProvider authorizationProvider) throws IOException {
        String authorization;
        GitHubRequest.Builder<?> builder = request.toBuilder();
        if (!request.allHeaders().containsKey("Authorization") && (authorization = authorizationProvider.getEncodedAuthorization()) != null) {
            builder.setHeader("Authorization", authorization);
        }
        if (request.header("Accept") == null) {
            builder.setHeader("Accept", "application/vnd.github+json");
        }
        builder.setHeader("Accept-Encoding", "gzip");
        builder.setHeader("X-GitHub-Api-Version", "2022-11-28");
        if (request.hasBody()) {
            if (request.body() != null) {
                builder.contentType(StringUtils.defaultString(request.contentType(), "application/x-www-form-urlencoded"));
            } else {
                builder.contentType("application/json");
                HashMap<String, Object> json = new HashMap<String, Object>();
                for (GitHubRequest.Entry e : request.args()) {
                    json.put(e.key, e.value);
                }
                builder.with(new ByteArrayInputStream(GitHubClient.getMappingObjectWriter().writeValueAsBytes(json)));
            }
        }
        return builder.build();
    }

    private void logRequest(@Nonnull GitHubConnectorRequest request) {
        LOGGER.log(Level.FINE, () -> String.format("(%s) GitHub API request: %s %s", sendRequestTraceId.get(), request.method(), request.url().toString()));
    }

    private void logResponse(@Nonnull GitHubConnectorResponse response) {
        LOGGER.log(Level.FINER, () -> String.format("(%s) GitHub API response: %s", sendRequestTraceId.get(), response.request().url().toString(), response.statusCode()));
    }

    private void logResponseBody(@Nonnull GitHubConnectorResponse response) {
        LOGGER.log(Level.FINEST, () -> {
            String body;
            try {
                body = GitHubResponse.getBodyAsString(response);
            }
            catch (Throwable e) {
                body = "Error reading response body";
            }
            return String.format("(%s) GitHub API response body: %s", sendRequestTraceId.get(), body);
        });
    }

    @Nonnull
    private static <T> GitHubResponse<T> createResponse(@Nonnull GitHubConnectorResponse connectorResponse, @CheckForNull BodyHandler<T> handler) throws IOException {
        Object body = null;
        if (handler != null && !GitHubClient.shouldIgnoreBody(connectorResponse)) {
            body = handler.apply(connectorResponse);
        }
        return new GitHubResponse<Object>(connectorResponse, body);
    }

    private static boolean shouldIgnoreBody(@Nonnull GitHubConnectorResponse connectorResponse) {
        if (connectorResponse.statusCode() == 304) {
            return true;
        }
        if (connectorResponse.statusCode() == 202) {
            LOGGER.log(Level.FINE, () -> String.format("(%s) Received HTTP_ACCEPTED(202) from %s. Please try again in 5 seconds.", sendRequestTraceId.get(), connectorResponse.request().url().toString()));
            return true;
        }
        return false;
    }

    private static IOException interpretApiError(IOException e, @Nonnull GitHubConnectorRequest connectorRequest, @CheckForNull GitHubConnectorResponse connectorResponse) throws IOException {
        if (e instanceof GHIOException) {
            return e;
        }
        int statusCode = -1;
        String message = null;
        HashMap<String, List<String>> headers = new HashMap();
        String errorMessage = null;
        if (connectorResponse != null) {
            statusCode = connectorResponse.statusCode();
            message = connectorResponse.header("Status");
            headers = connectorResponse.allHeaders();
            if (connectorResponse.statusCode() >= 400) {
                errorMessage = GitHubResponse.getBodyAsStringOrNull(connectorResponse);
            }
        }
        if (errorMessage != null) {
            e = e instanceof FileNotFoundException ? new GHFileNotFoundException(e.getMessage() + " " + errorMessage, e).withResponseHeaderFields(headers) : (statusCode >= 0 ? new HttpException(errorMessage, statusCode, message, connectorRequest.url().toString(), e) : new GHIOException(errorMessage).withResponseHeaderFields(headers));
        } else if (!(e instanceof FileNotFoundException)) {
            e = new HttpException(statusCode, message, connectorRequest.url().toString(), (Throwable)e);
        }
        return e;
    }

    private static void logRetryConnectionError(IOException e, URL url, int retries) throws IOException {
        int minRetryInterval = Math.max(100, Integer.getInteger(GitHubClient.class.getName() + ".minRetryInterval", 100));
        int maxRetryInterval = Math.max(100, Integer.getInteger(GitHubClient.class.getName() + ".maxRetryInterval", 100));
        long sleepTime = maxRetryInterval <= minRetryInterval ? (long)minRetryInterval : ThreadLocalRandom.current().nextLong(minRetryInterval, maxRetryInterval);
        LOGGER.log(Level.INFO, () -> String.format("(%s) %s while connecting to %s: '%s'. Sleeping %d milliseconds before retrying (%d retries remaining)", sendRequestTraceId.get(), e.getClass().toString(), url.toString(), e.getMessage(), sleepTime, retries));
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException ie) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
    }

    private void detectInvalidCached404Response(GitHubConnectorResponse connectorResponse, GitHubRequest request) throws IOException {
        if (connectorResponse.statusCode() == 404 && Objects.equals(connectorResponse.request().method(), "GET") && connectorResponse.header("ETag") != null && !Objects.equals(connectorResponse.request().header("Cache-Control"), "no-cache")) {
            LOGGER.log(Level.FINE, () -> String.format("(%s) Encountered GitHub invalid cached 404 from %s. Retrying with \"Cache-Control\"=\"no-cache\"...", sendRequestTraceId.get(), connectorResponse.request().url()));
            throw new RetryRequestException(GitHubClient.prepareConnectorRequest(((GitHubRequest.Builder)request.toBuilder().setHeader("Cache-Control", "no-cache")).build(), this.authorizationProvider));
        }
    }

    private void noteRateLimit(@Nonnull RateLimitTarget rateLimitTarget, @Nonnull GitHubConnectorResponse connectorResponse) {
        try {
            int limit = connectorResponse.parseInt("X-RateLimit-Limit");
            int remaining = connectorResponse.parseInt("X-RateLimit-Remaining");
            int reset = connectorResponse.parseInt("X-RateLimit-Reset");
            GHRateLimit.Record observed = new GHRateLimit.Record(limit, remaining, reset, connectorResponse);
            this.updateRateLimit(GHRateLimit.fromRecord(observed, rateLimitTarget));
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINER, () -> String.format("(%s) Missing or malformed X-RateLimit header: %s", sendRequestTraceId.get(), e.getMessage()));
        }
    }

    private static void detectOTPRequired(@Nonnull GitHubConnectorResponse connectorResponse) throws GHIOException {
        if (connectorResponse.statusCode() == 401 && connectorResponse.header("X-GitHub-OTP") != null) {
            throw new GHOTPRequiredException().withResponseHeaderFields(connectorResponse.allHeaders());
        }
    }

    void requireCredential() {
        if (this.isAnonymous()) {
            throw new IllegalStateException("This operation requires a credential but none is given to the GitHub constructor");
        }
    }

    private boolean isPrivateModeEnabled() {
        try {
            GitHubResponse response = this.sendRequest((GitHubRequest.Builder<?>)GitHubRequest.newBuilder().withApiUrl(this.getApiUrl()), null);
            return response.statusCode() == 401 && response.header("X-GitHub-Media-Type") != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    static URL parseURL(String s) {
        try {
            return s == null ? null : new URL(s);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid URL: " + s);
        }
    }

    static Date parseDate(String timestamp) {
        if (timestamp == null) {
            return null;
        }
        return Date.from(GitHubClient.parseInstant(timestamp));
    }

    static Instant parseInstant(String timestamp) {
        if (timestamp == null) {
            return null;
        }
        if (timestamp.charAt(4) == '/') {
            return Instant.from(DATE_TIME_PARSER_SLASHES.parse(timestamp));
        }
        return Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(timestamp));
    }

    static String printDate(Date dt) {
        return DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(dt.getTime()).truncatedTo(ChronoUnit.SECONDS));
    }

    @Nonnull
    static ObjectWriter getMappingObjectWriter() {
        return MAPPER.writer();
    }

    @Nonnull
    static ObjectReader getMappingObjectReader(@Nonnull GitHub root) {
        ObjectReader reader = GitHubClient.getMappingObjectReader((GitHubConnectorResponse)null);
        ((InjectableValues.Std)reader.getInjectableValues()).addValue(GitHub.class, (Object)root);
        return reader;
    }

    @Nonnull
    static ObjectReader getMappingObjectReader(@CheckForNull GitHubConnectorResponse connectorResponse) {
        HashMap<String, Object> injected = new HashMap<String, Object>();
        injected.put(GitHubConnectorResponse.class.getName(), null);
        injected.put(GitHub.class.getName(), null);
        if (connectorResponse != null) {
            injected.put(GitHubConnectorResponse.class.getName(), connectorResponse);
            GitHubConnectorRequest request = connectorResponse.request();
            if (request instanceof GitHubRequest) {
                injected.putAll(((GitHubRequest)connectorResponse.request()).injectedMappingValues());
            }
        }
        return MAPPER.reader(new InjectableValues.Std(injected));
    }

    static <K, V> Map<K, V> unmodifiableMapOrNull(Map<? extends K, ? extends V> map) {
        return map == null ? null : Collections.unmodifiableMap(map);
    }

    static <T> List<T> unmodifiableListOrNull(List<? extends T> list) {
        return list == null ? null : Collections.unmodifiableList(list);
    }

    private static /* synthetic */ JsonRateLimit lambda$getRateLimit$4(GitHubConnectorResponse connectorResponse) throws IOException {
        return (JsonRateLimit)((Object)GitHubResponse.parseBody(connectorResponse, JsonRateLimit.class));
    }

    static {
        MAPPER.setVisibility(new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY));
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS, true);
        MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
    }

    @FunctionalInterface
    static interface BodyHandler<T>
    extends FunctionThrows<GitHubConnectorResponse, T, IOException> {
    }

    private static class GHApiInfo {
        private String rate_limit_url;

        private GHApiInfo() {
        }

        void check(String apiUrl) throws IOException {
            if (this.rate_limit_url == null) {
                throw new IOException(apiUrl + " doesn't look like GitHub API URL");
            }
            new URL(this.rate_limit_url);
        }
    }

    static class RetryRequestException
    extends IOException {
        final GitHubConnectorRequest connectorRequest;

        RetryRequestException() {
            this((GitHubConnectorRequest)null);
        }

        RetryRequestException(GitHubConnectorRequest connectorRequest) {
            this.connectorRequest = connectorRequest;
        }
    }
}

