/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.org.kohsuke.github;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.HttpException;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.ServiceDownException;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.connector.GitHubConnectorResponse;
import org.jetbrains.annotations.NotNull;

abstract class GitHubConnectorResponseErrorHandler {
    public static final int TOO_MANY_REQUESTS = 429;
    static GitHubConnectorResponseErrorHandler STATUS_HTTP_BAD_REQUEST_OR_GREATER = new GitHubConnectorResponseErrorHandler(){
        private static final String CONTENT_TYPE = "Content-type";
        private static final String TEXT_HTML = "text/html";
        private static final String UNICORN_TITLE = "<title>Unicorn!";

        @Override
        public boolean isError(@NotNull GitHubConnectorResponse connectorResponse) throws IOException {
            return connectorResponse.statusCode() >= 400;
        }

        @Override
        public void onError(@NotNull GitHubConnectorResponse connectorResponse) throws IOException {
            if (connectorResponse.statusCode() == 404) {
                throw new FileNotFoundException(connectorResponse.request().url().toString());
            }
            if (this.isServiceDown(connectorResponse)) {
                throw new ServiceDownException(connectorResponse);
            }
            throw new HttpException(connectorResponse);
        }

        private boolean isServiceDown(GitHubConnectorResponse connectorResponse) throws IOException {
            if (connectorResponse.statusCode() < 500) {
                return false;
            }
            String contentTypeHeader = connectorResponse.header(CONTENT_TYPE);
            if (contentTypeHeader != null && contentTypeHeader.contains(TEXT_HTML)) {
                try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(connectorResponse.bodyStream(), StandardCharsets.UTF_8));){
                    String line;
                    for (int hardLineCap = 25; hardLineCap > 0 && (line = bufReader.readLine()) != null; --hardLineCap) {
                        if (!line.trim().startsWith(UNICORN_TITLE)) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            return false;
        }
    };

    GitHubConnectorResponseErrorHandler() {
    }

    abstract boolean isError(@Nonnull GitHubConnectorResponse var1) throws IOException;

    public abstract void onError(@Nonnull GitHubConnectorResponse var1) throws IOException;
}

