/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.event;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import me.caseload.knockbacksync.event.Event;
import me.caseload.knockbacksync.event.EventBus;
import me.caseload.knockbacksync.event.KBSyncEventHandler;

public class OptimizedEventBus
implements EventBus {
    private final Map<Class<? extends Event>, List<OptimizedListener>> listenerMap = new ConcurrentHashMap<Class<? extends Event>, List<OptimizedListener>>();
    private final MethodHandles.Lookup lookup = MethodHandles.lookup();

    @Override
    public void registerListeners(Object listener) {
        this.registerMethods(listener, listener.getClass());
    }

    @Override
    public void registerStaticListeners(Class<?> clazz) {
        this.registerMethods(null, clazz);
    }

    private void registerMethods(Object instance, Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            Class<?> eventType;
            KBSyncEventHandler annotation = method.getAnnotation(KBSyncEventHandler.class);
            if (annotation == null || method.getParameterCount() != 1 || !Event.class.isAssignableFrom(eventType = method.getParameterTypes()[0])) continue;
            try {
                if (instance == null && !Modifier.isStatic(method.getModifiers())) continue;
                MethodHandle handle = this.lookup.unreflect(method);
                OptimizedListener optimizedListener = new OptimizedListener(instance, handle, annotation.priority(), method.getDeclaringClass());
                this.listenerMap.computeIfAbsent(eventType, k -> new CopyOnWriteArrayList()).add(optimizedListener);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.listenerMap.values().forEach(list -> list.sort((a, b) -> Integer.compare(b.priority, a.priority)));
    }

    @Override
    public void unregisterListeners(Object listener) {
        this.listenerMap.values().forEach(list -> list.removeIf(l -> l.instance == listener));
    }

    @Override
    public void unregisterStaticListeners(Class<?> clazz) {
        this.listenerMap.values().forEach(list -> list.removeIf(l -> l.instance == null && l.declaringClass == clazz));
    }

    @Override
    public void post(Event event) {
        List<OptimizedListener> listeners = this.listenerMap.get(event.getClass());
        if (listeners != null) {
            for (OptimizedListener listener : listeners) {
                try {
                    if (listener.instance != null) {
                        listener.handle.invoke(listener.instance, event);
                    } else {
                        listener.handle.invoke(event);
                    }
                    if (!event.isCancelled()) continue;
                    break;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    private static class OptimizedListener {
        final Object instance;
        final MethodHandle handle;
        final int priority;
        final Class<?> declaringClass;

        OptimizedListener(Object instance, MethodHandle handle, int priority, Class<?> declaringClass) {
            this.instance = instance;
            this.handle = handle;
            this.priority = priority;
            this.declaringClass = declaringClass;
        }
    }
}

