/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.manager;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import me.caseload.knockbacksync.Base;
import me.caseload.knockbacksync.ConfigWrapper;
import me.caseload.knockbacksync.Platform;
import me.caseload.knockbacksync.config.YamlConfiguration;
import me.caseload.knockbacksync.runnable.PingRunnable;
import me.caseload.knockbacksync.scheduler.AbstractTaskHandle;

public class ConfigManager {
    public static final long CONFIG_VERSION = 7L;
    private boolean toggled;
    private boolean runnableEnabled;
    private boolean updateAvailable;
    private boolean notifyUpdate;
    private boolean autoUpdate;
    private long runnableInterval;
    private long combatTimer;
    private long spikeThreshold;
    private String enableMessage;
    private String disableMessage;
    private String playerEnableMessage;
    private String playerDisableMessage;
    private String playerIneligibleMessage;
    private String playerDisconnectedWhileExecutingCommand;
    private AbstractTaskHandle pingTask;
    private Map<String, Object> config;
    private File configFile;
    private ConfigWrapper configWrapper;
    private YamlConfiguration yamlConfig;

    public ConfigManager() {
        Base instance = Base.INSTANCE;
        this.configFile = new File(instance.getDataFolder(), "config.yml");
        this.yamlConfig = new YamlConfiguration(this.configFile);
    }

    public ConfigWrapper getConfigWrapper() {
        if (this.configWrapper == null) {
            this.reloadConfig();
        }
        return this.configWrapper;
    }

    public void reloadConfig() {
        try {
            if (!this.configFile.exists()) {
                Base.INSTANCE.saveDefaultConfig();
            }
            this.yamlConfig.load();
            this.config = this.yamlConfig.getData();
            this.configWrapper = new ConfigWrapper(this.config);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.config = new HashMap<String, Object>();
            this.configWrapper = new ConfigWrapper(this.config);
        }
    }

    public void saveConfig() {
        try {
            this.yamlConfig.setData(this.config);
            this.yamlConfig.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadConfig(boolean reloadConfig) {
        if (reloadConfig || this.config == null) {
            this.reloadConfig();
        }
        ConfigWrapper configWrapper = this.getConfigWrapper();
        this.updateConfig();
        this.toggled = configWrapper.getBoolean("enabled", true);
        boolean newRunnableEnabled = configWrapper.getBoolean("runnable.enabled", true);
        if (this.runnableEnabled && newRunnableEnabled && this.pingTask != null) {
            this.pingTask.cancel();
        }
        this.runnableEnabled = newRunnableEnabled;
        this.runnableInterval = configWrapper.getLong("runnable.interval", 5L);
        if (this.runnableEnabled) {
            long initialDelay = 0L;
            long pingTaskRunnableInterval = this.runnableInterval;
            if (Base.INSTANCE.getPlatform() == Platform.FOLIA) {
                initialDelay = 1L;
                pingTaskRunnableInterval = Math.max(pingTaskRunnableInterval, 1L);
            }
            this.pingTask = Base.INSTANCE.getScheduler().runTaskTimerAsynchronously(new PingRunnable(), initialDelay, pingTaskRunnableInterval);
        }
        this.notifyUpdate = configWrapper.getBoolean("notify_updates", true);
        this.autoUpdate = configWrapper.getBoolean("auto_update", true);
        this.combatTimer = configWrapper.getLong("runnable.timer", 30L);
        this.spikeThreshold = configWrapper.getLong("spike_threshold", 20L);
        this.enableMessage = configWrapper.getString("messages.toggle.global.enable", "&aSuccessfully enabled KnockbackSync.");
        this.disableMessage = configWrapper.getString("messages.toggle.global.disable", "&cSuccessfully disabled KnockbackSync.");
        this.playerEnableMessage = configWrapper.getString("messages.toggle.player.enable", "&aSuccessfully enabled KnockbackSync for %player%.");
        this.playerDisableMessage = configWrapper.getString("messages.toggle.player.disable", "&aSuccessfully &cdisabled &aKnockbackSync for %player%.");
        this.playerIneligibleMessage = configWrapper.getString("messages.toggle.player.ineligible", "&c%player% is ineligible for KnockbackSync. If you believe this is in error, please contact your server administrators.");
        this.playerDisconnectedWhileExecutingCommand = configWrapper.getString("messages.toggle.player.disconnected-while-executing-command", "&c%player% disconnected while executing command.");
    }

    public void updateConfig() {
        ConfigWrapper oldConfig = this.getConfigWrapper();
        long oldConfigVersion = oldConfig.getLong("config_version", 0L);
        if (oldConfigVersion < 7L) {
            File backupFile = new File(this.configFile.getParentFile(), "config-version-" + oldConfigVersion + ".yml");
            try {
                Files.move(this.configFile.toPath(), backupFile.toPath(), new CopyOption[0]);
                Base.INSTANCE.getLogger().info("Backed up old config to " + backupFile.getName());
            }
            catch (IOException e) {
                Base.INSTANCE.getLogger().warning("Failed to backup old config: " + e.getMessage());
            }
            HashMap<String, Object> oldValues = new HashMap<String, Object>(this.config);
            Base.INSTANCE.saveDefaultConfig();
            this.reloadConfig();
            ConfigWrapper newConfig = this.getConfigWrapper();
            this.transferAllSettings(oldConfig, newConfig);
            newConfig.set("config_version", 7L);
            this.saveConfig();
            Base.INSTANCE.getLogger().info("Config updated to version 7");
        }
    }

    private void transferAllSettings(ConfigWrapper oldConfig, ConfigWrapper newConfig) {
        this.transferSettingsRecursive(oldConfig, newConfig, ".");
    }

    private void transferSettingsRecursive(ConfigWrapper oldConfig, ConfigWrapper newConfig, String currentPath) {
        for (String key : oldConfig.getKeys(currentPath)) {
            String fullPath = currentPath.isEmpty() || currentPath.equals(".") ? key : currentPath + "." + key;
            if (!newConfig.contains(fullPath)) continue;
            Object value = oldConfig.get(fullPath);
            if (value instanceof Map) {
                this.transferSettingsRecursive(oldConfig, newConfig, fullPath);
                continue;
            }
            newConfig.set(fullPath, value);
        }
    }

    @Generated
    public boolean isToggled() {
        return this.toggled;
    }

    @Generated
    public boolean isRunnableEnabled() {
        return this.runnableEnabled;
    }

    @Generated
    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    @Generated
    public boolean isNotifyUpdate() {
        return this.notifyUpdate;
    }

    @Generated
    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    @Generated
    public long getRunnableInterval() {
        return this.runnableInterval;
    }

    @Generated
    public long getCombatTimer() {
        return this.combatTimer;
    }

    @Generated
    public long getSpikeThreshold() {
        return this.spikeThreshold;
    }

    @Generated
    public String getEnableMessage() {
        return this.enableMessage;
    }

    @Generated
    public String getDisableMessage() {
        return this.disableMessage;
    }

    @Generated
    public String getPlayerEnableMessage() {
        return this.playerEnableMessage;
    }

    @Generated
    public String getPlayerDisableMessage() {
        return this.playerDisableMessage;
    }

    @Generated
    public String getPlayerIneligibleMessage() {
        return this.playerIneligibleMessage;
    }

    @Generated
    public String getPlayerDisconnectedWhileExecutingCommand() {
        return this.playerDisconnectedWhileExecutingCommand;
    }

    @Generated
    public AbstractTaskHandle getPingTask() {
        return this.pingTask;
    }

    @Generated
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Generated
    public File getConfigFile() {
        return this.configFile;
    }

    @Generated
    public YamlConfiguration getYamlConfig() {
        return this.yamlConfig;
    }

    @Generated
    public void setToggled(boolean toggled) {
        this.toggled = toggled;
    }

    @Generated
    public void setRunnableEnabled(boolean runnableEnabled) {
        this.runnableEnabled = runnableEnabled;
    }

    @Generated
    public void setUpdateAvailable(boolean updateAvailable) {
        this.updateAvailable = updateAvailable;
    }

    @Generated
    public void setNotifyUpdate(boolean notifyUpdate) {
        this.notifyUpdate = notifyUpdate;
    }

    @Generated
    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    @Generated
    public void setRunnableInterval(long runnableInterval) {
        this.runnableInterval = runnableInterval;
    }

    @Generated
    public void setCombatTimer(long combatTimer) {
        this.combatTimer = combatTimer;
    }

    @Generated
    public void setSpikeThreshold(long spikeThreshold) {
        this.spikeThreshold = spikeThreshold;
    }

    @Generated
    public void setEnableMessage(String enableMessage) {
        this.enableMessage = enableMessage;
    }

    @Generated
    public void setDisableMessage(String disableMessage) {
        this.disableMessage = disableMessage;
    }

    @Generated
    public void setPlayerEnableMessage(String playerEnableMessage) {
        this.playerEnableMessage = playerEnableMessage;
    }

    @Generated
    public void setPlayerDisableMessage(String playerDisableMessage) {
        this.playerDisableMessage = playerDisableMessage;
    }

    @Generated
    public void setPlayerIneligibleMessage(String playerIneligibleMessage) {
        this.playerIneligibleMessage = playerIneligibleMessage;
    }

    @Generated
    public void setPlayerDisconnectedWhileExecutingCommand(String playerDisconnectedWhileExecutingCommand) {
        this.playerDisconnectedWhileExecutingCommand = playerDisconnectedWhileExecutingCommand;
    }

    @Generated
    public void setPingTask(AbstractTaskHandle pingTask) {
        this.pingTask = pingTask;
    }

    @Generated
    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    @Generated
    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    @Generated
    public void setConfigWrapper(ConfigWrapper configWrapper) {
        this.configWrapper = configWrapper;
    }

    @Generated
    public void setYamlConfig(YamlConfiguration yamlConfig) {
        this.yamlConfig = yamlConfig;
    }
}

