/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.particle.data;

import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.color.Color;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTFloat;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.particle.data.ParticleData;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ParticleSpellData
extends ParticleData {
    private Color color;
    private float power;

    public ParticleSpellData(Color color, float power) {
        this.color = color;
        this.power = power;
    }

    public static ParticleSpellData read(PacketWrapper<?> wrapper) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_9)) {
            Color color = Color.read(wrapper);
            float power = wrapper.readFloat();
            return new ParticleSpellData(color, power);
        }
        return new ParticleSpellData(Color.WHITE, 1.0f);
    }

    public static void write(PacketWrapper<?> wrapper, ParticleSpellData data) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_9)) {
            Color.write(wrapper, data.color);
            wrapper.writeFloat(data.power);
        }
    }

    @ApiStatus.Internal
    public static ParticleSpellData decode(NBTCompound compound, ClientVersion version) {
        Color color = compound.getOr("color", Color::decode, Color.WHITE, null);
        float power = compound.getNumberTagValueOrDefault("power", Float.valueOf(1.0f)).floatValue();
        return new ParticleSpellData(color, power);
    }

    @ApiStatus.Internal
    public static void encode(ParticleSpellData data, ClientVersion version, NBTCompound compound) {
        if (version.isNewerThanOrEquals(ClientVersion.V_1_21_9)) {
            if (!Color.WHITE.equals(data.color)) {
                compound.setTag("color", Color.encode(data.color, version));
            }
            if (data.power != 1.0f) {
                compound.setTag("power", new NBTFloat(data.power));
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public float getPower() {
        return this.power;
    }

    public void setPower(float power) {
        this.power = power;
    }
}

