/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.wrapper.configuration.client;

import java.util.UUID;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;

public class WrapperConfigClientResourcePackStatus
extends PacketWrapper<WrapperConfigClientResourcePackStatus> {
    private UUID packId;
    private Result result;

    public WrapperConfigClientResourcePackStatus(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperConfigClientResourcePackStatus(Result result) {
        this(UUID.randomUUID(), result);
    }

    public WrapperConfigClientResourcePackStatus(UUID packId, Result result) {
        super(PacketType.Configuration.Client.RESOURCE_PACK_STATUS);
        this.packId = packId;
        this.result = result;
    }

    @Override
    public void read() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
            this.packId = this.readUUID();
        }
        this.result = Result.VALUES[this.readVarInt()];
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
            this.writeUUID(this.packId);
        }
        this.writeVarInt(this.result.ordinal());
    }

    @Override
    public void copy(WrapperConfigClientResourcePackStatus wrapper) {
        this.packId = wrapper.packId;
        this.result = wrapper.result;
    }

    public UUID getPackId() {
        return this.packId;
    }

    public void setPackId(UUID packId) {
        this.packId = packId;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public static enum Result {
        SUCCESSFULLY_LOADED,
        DECLINED,
        FAILED_DOWNLOAD,
        ACCEPTED,
        DOWNLOADED,
        INVALID_URL,
        FAILED_RELOAD,
        DISCARDED;

        public static final Result[] VALUES;

        static {
            VALUES = Result.values();
        }
    }
}

