/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.org.kohsuke.github;

import java.util.logging.Level;
import java.util.logging.Logger;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHRateLimit;

public abstract class RateLimitChecker {
    private static final Logger LOGGER = Logger.getLogger(RateLimitChecker.class.getName());
    public static final RateLimitChecker NONE = new RateLimitChecker(){};

    protected boolean checkRateLimit(GHRateLimit.Record rateLimitRecord, long count) throws InterruptedException {
        return false;
    }

    protected final boolean sleepUntilReset(GHRateLimit.Record record) throws InterruptedException {
        long sleepMilliseconds = record.getResetDate().getTime() - System.currentTimeMillis();
        if (sleepMilliseconds > 0L) {
            String message = String.format("GitHub API - Current quota has %d remaining of %d. Waiting for quota to reset at %tT.", record.getRemaining(), record.getLimit(), record.getResetDate());
            LOGGER.log(Level.INFO, message);
            Thread.sleep(sleepMilliseconds);
            return true;
        }
        return false;
    }

    public static class LiteralValue
    extends RateLimitChecker {
        private final int sleepAtOrBelow;

        public LiteralValue(int sleepAtOrBelow) {
            if (sleepAtOrBelow < 0) {
                sleepAtOrBelow = 0;
            }
            this.sleepAtOrBelow = sleepAtOrBelow;
        }

        @Override
        protected boolean checkRateLimit(GHRateLimit.Record record, long count) throws InterruptedException {
            if (record.getRemaining() <= this.sleepAtOrBelow) {
                return this.sleepUntilReset(record);
            }
            return false;
        }
    }
}

