/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.caseload.knockbacksync.shaded.org.apache.commons.io.IOUtils;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHubClient;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHubPageContentsIterable;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHubRequest;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHubResponse;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.PagedIterable;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.function.InputStreamFunction;

class Requester
extends GitHubRequest.Builder<Requester> {
    final transient GitHubClient client;

    Requester(GitHubClient client) {
        this.client = client;
        this.withApiUrl(client.getApiUrl());
    }

    public void send() throws IOException {
        this.client.sendRequest(this, connectorResponse -> GitHubResponse.getBodyAsString(connectorResponse));
    }

    public <T> T fetch(@Nonnull Class<T> type) throws IOException {
        return this.client.sendRequest(this, connectorResponse -> GitHubResponse.parseBody(connectorResponse, type)).body();
    }

    public <T> T fetchInto(@Nonnull T existingInstance) throws IOException {
        return this.client.sendRequest(this, connectorResponse -> GitHubResponse.parseBody(connectorResponse, existingInstance)).body();
    }

    public int fetchHttpStatusCode() throws IOException {
        return this.client.sendRequest(this.build(), null).statusCode();
    }

    public <T> T fetchStream(@Nonnull InputStreamFunction<T> handler) throws IOException {
        return this.client.sendRequest(this, connectorResponse -> handler.apply(connectorResponse.bodyStream())).body();
    }

    @NonNull
    public static InputStream copyInputStream(InputStream inputStream) throws IOException {
        return new ByteArrayInputStream(IOUtils.toByteArray(inputStream));
    }

    public <R> PagedIterable<R> toIterable(Class<R[]> type, Consumer<R> itemInitializer) {
        return new GitHubPageContentsIterable<R>(this.client, this.build(), type, itemInitializer);
    }
}

