/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.stats.custom;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import me.caseload.knockbacksync.Base;
import me.caseload.knockbacksync.shaded.com.google.gson.JsonObject;
import me.caseload.knockbacksync.shaded.com.google.gson.JsonParser;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHAsset;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHRelease;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHub;
import me.caseload.knockbacksync.stats.SimplePie;

public class BuildTypePie
extends SimplePie {
    private static final String RELEASES_FILE = "releases.txt";
    private static final String DEV_BUILDS_FILE = "dev-builds.txt";
    private static final File dataFolder = Base.INSTANCE.getDataFolder();
    private static String cachedBuildType = null;

    public BuildTypePie() {
        super("build_type", BuildTypePie::determineBuildType);
    }

    public static String determineBuildType() {
        if (cachedBuildType == null) {
            cachedBuildType = BuildTypePie.calculateBuildType();
        }
        return cachedBuildType;
    }

    private static String calculateBuildType() {
        try {
            String currentHash = Base.INSTANCE.getPluginJarHashProvider().getPluginJarHash();
            BuildTypePie.downloadBuildFiles();
            if (BuildTypePie.isHashInFile(currentHash, new File(dataFolder, RELEASES_FILE))) {
                return "release";
            }
            if (BuildTypePie.isHashInFile(currentHash, new File(dataFolder, DEV_BUILDS_FILE))) {
                return "dev";
            }
            return "fork";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "unknown";
        }
    }

    private static void downloadBuildFiles() throws IOException {
        GitHub gitHub = GitHub.connectAnonymously();
        GHRelease latestRelease = gitHub.getRepository("Axionize/knockback-sync").getLatestRelease();
        List<GHAsset> assets = latestRelease.listAssets().toList();
        for (GHAsset asset : assets) {
            if (!asset.getName().equals(RELEASES_FILE) && !asset.getName().equals(DEV_BUILDS_FILE)) continue;
            Base.INSTANCE.getLogger().info("Downloading: " + asset.getName());
            String jsonContent = BuildTypePie.readStringFromURL(asset.getUrl().toString());
            JsonObject jsonObject = JsonParser.parseString(jsonContent).getAsJsonObject();
            String downloadUrl = jsonObject.get("browser_download_url").getAsString();
            try (InputStream inputStream = new URL(downloadUrl).openStream();
                 FileOutputStream outputStream = new FileOutputStream(new File(dataFolder, asset.getName()));){
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
            }
            Base.INSTANCE.getLogger().info("Downloaded: " + asset.getName());
        }
    }

    private static boolean isHashInFile(String hash, File file) throws IOException {
        if (!file.exists()) {
            return false;
        }
        List<String> lines = Files.readAllLines(Paths.get(file.getPath(), new String[0]));
        return lines.contains(hash);
    }

    private static String readStringFromURL(String urlString) throws IOException {
        try (InputStream inputStream = new URL(urlString).openStream();){
            int bytesRead;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, bytesRead);
            }
            String string = result.toString("UTF-8");
            return string;
        }
    }
}

