/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import io.github.retrooper.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Map;
import java.util.logging.Logger;
import me.caseload.knockbacksync.Base;
import me.caseload.knockbacksync.Platform;
import me.caseload.knockbacksync.event.KBSyncEventHandler;
import me.caseload.knockbacksync.event.events.ConfigReloadEvent;
import me.caseload.knockbacksync.listener.bukkit.BukkitPlayerDamageListener;
import me.caseload.knockbacksync.listener.bukkit.BukkitPlayerKnockbackListener;
import me.caseload.knockbacksync.manager.ConfigManager;
import me.caseload.knockbacksync.permission.PermissionChecker;
import me.caseload.knockbacksync.permission.PluginPermissionChecker;
import me.caseload.knockbacksync.scheduler.BukkitSchedulerAdapter;
import me.caseload.knockbacksync.scheduler.FoliaSchedulerAdapter;
import me.caseload.knockbacksync.sender.BukkitPlayerSelectorParser;
import me.caseload.knockbacksync.sender.BukkitSenderFactory;
import me.caseload.knockbacksync.sender.Sender;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.bukkit.CloudBukkitCapabilities;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.execution.ExecutionCoordinator;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.paper.LegacyPaperCommandManager;
import me.caseload.knockbacksync.stats.custom.BukkitStatsManager;
import me.caseload.knockbacksync.stats.custom.PluginJarHashProvider;
import me.caseload.knockbacksync.world.BukkitServer;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitBase
extends Base {
    private final JavaPlugin plugin;
    private final BukkitSenderFactory bukkitSenderFactory = new BukkitSenderFactory(this);
    private final PluginPermissionChecker permissionChecker = new PluginPermissionChecker();
    private int playerUpdateInterval;
    private final MethodHandle tickRateMethodHandle;

    public BukkitBase(JavaPlugin plugin) {
        this.plugin = plugin;
        this.configManager = new ConfigManager();
        this.playerSelectorParser = new BukkitPlayerSelectorParser<Sender>();
        this.statsManager = new BukkitStatsManager((Plugin)plugin);
        this.platformServer = new BukkitServer();
        this.pluginJarHashProvider = new PluginJarHashProvider(this.getClass().getProtectionDomain().getCodeSource().getLocation());
        this.playerUpdateInterval = this.getConfigManager().getConfigWrapper().getInt("entity_tick_intervals.player", 2);
        MethodHandle handle = null;
        try {
            Server craftServer = Bukkit.getServer();
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle getServerTickManager = lookup.findVirtual(craftServer.getClass(), "getServerTickManager", MethodType.methodType(Object.class));
            Object serverTickManager = getServerTickManager.invoke(craftServer);
            handle = lookup.findVirtual(serverTickManager.getClass(), "getTickRate", MethodType.methodType(Float.TYPE));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.tickRateMethodHandle = handle;
    }

    @Override
    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    @Override
    public File getDataFolder() {
        return this.plugin.getDataFolder();
    }

    @Override
    public InputStream getResource(String filename) {
        return this.plugin.getResource(filename);
    }

    @Override
    public void load() {
        PacketEvents.setAPI((PacketEventsAPI)SpigotPacketEventsBuilder.build((Plugin)this.plugin));
        PacketEvents.getAPI().load();
    }

    @Override
    public void enable() {
        super.enable();
        this.eventBus.registerListeners(this);
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_20_5) && this.getPlatform() == Platform.BUKKIT) {
            this.scheduler.runTaskTimerAsynchronously(this::setUpdateIntervals, 1L, 1L);
        }
    }

    @Override
    public void initializeScheduler() {
        switch (this.getPlatform()) {
            case BUKKIT: {
                this.scheduler = new BukkitSchedulerAdapter((Plugin)this.plugin);
                break;
            }
            case FOLIA: {
                this.scheduler = new FoliaSchedulerAdapter((Plugin)this.plugin);
            }
        }
    }

    @Override
    protected void registerPlatformListeners() {
        this.registerPluginListeners(new BukkitPlayerDamageListener(), new BukkitPlayerKnockbackListener());
    }

    @Override
    protected void registerCommands() {
        this.commandManager = new LegacyPaperCommandManager<Sender>((Plugin)this.plugin, ExecutionCoordinator.simpleCoordinator(), this.bukkitSenderFactory);
        if (this.commandManager instanceof LegacyPaperCommandManager) {
            LegacyPaperCommandManager legacyPaperCommandManager = (LegacyPaperCommandManager)this.commandManager;
            if (legacyPaperCommandManager.hasCapability(CloudBukkitCapabilities.NATIVE_BRIGADIER)) {
                legacyPaperCommandManager.registerBrigadier();
            } else if (this.commandManager.hasCapability(CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
                legacyPaperCommandManager.registerAsynchronousCompletions();
            }
        }
        super.registerCommands();
    }

    @Override
    protected String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @Override
    public void saveDefaultConfig() {
        this.plugin.saveDefaultConfig();
    }

    @Override
    public PermissionChecker getPermissionChecker() {
        return this.permissionChecker;
    }

    @Override
    public float getTickRate() {
        if (this.tickRateMethodHandle != null) {
            try {
                return this.tickRateMethodHandle.invoke();
            }
            catch (Throwable t) {
                return 20.0f;
            }
        }
        return 20.0f;
    }

    @Override
    public URL getJarURL() {
        try {
            String path = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
            File pluginJarFile = new File(path);
            return Paths.get(this.getDataFolder().getParentFile().getAbsolutePath(), pluginJarFile.getName()).toUri().toURL();
        }
        catch (Exception e) {
            LOGGER.severe("Couldn't find plugin file: " + e.getMessage());
            return null;
        }
    }

    private void registerPluginListeners(Listener ... listeners) {
        PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        for (Listener listener : listeners) {
            pluginManager.registerEvents(listener, (Plugin)this.plugin);
        }
    }

    public BukkitSenderFactory getSenderFactory() {
        return this.bukkitSenderFactory;
    }

    public void setUpdateIntervals() {
        try {
            for (World world : Bukkit.getWorlds()) {
                Method getWorldHandleMethod = world.getClass().getMethod("getHandle", new Class[0]);
                Object serverLevel = getWorldHandleMethod.invoke((Object)world, new Object[0]);
                Method getChunkSource = serverLevel.getClass().getMethod("getChunkSource", new Class[0]);
                Object chunkSource = getChunkSource.invoke(serverLevel, new Object[0]);
                Field chunkMapField = chunkSource.getClass().getDeclaredField("chunkMap");
                chunkMapField.setAccessible(true);
                Object chunkMap = chunkMapField.get(chunkSource);
                Field entityMapField = chunkMap.getClass().getDeclaredField("entityMap");
                entityMapField.setAccessible(true);
                Map entityMap = (Map)entityMapField.get(chunkMap);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    Object trackedEntity = entityMap.get(player.getEntityId());
                    if (trackedEntity == null) continue;
                    Field serverEntityField = trackedEntity.getClass().getDeclaredField("serverEntity");
                    serverEntityField.setAccessible(true);
                    Object serverEntity = serverEntityField.get(trackedEntity);
                    Field updateIntervalField = serverEntity.getClass().getDeclaredField("updateInterval");
                    updateIntervalField.setAccessible(true);
                    updateIntervalField.set(serverEntity, this.playerUpdateInterval);
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to use reflection to modify updateIntervals" + e);
        }
    }

    @KBSyncEventHandler
    public void onConfigReload(ConfigReloadEvent event) {
        this.playerUpdateInterval = event.getConfigManager().getConfigWrapper().getInt("entity_tick_intervals.player", 2);
    }

    @Override
    public void restartServer() {
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"restart");
    }

    @Override
    public boolean hasRestartScript() {
        File spigotFile = new File("spigot.yml");
        if (!spigotFile.exists()) {
            return false;
        }
        YamlConfiguration spigotConfig = YamlConfiguration.loadConfiguration((File)spigotFile);
        String scriptValue = spigotConfig.getString("settings.restart-script");
        if (scriptValue == null || scriptValue.isEmpty()) {
            return false;
        }
        return Paths.get(scriptValue, new String[0]).toAbsolutePath().normalize().toFile().exists();
    }
}

