/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.manager;

import com.github.retrooper.packetevents.protocol.player.User;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.caseload.knockbacksync.Base;
import me.caseload.knockbacksync.player.PlatformPlayer;
import me.caseload.knockbacksync.player.PlayerData;
import me.caseload.knockbacksync.util.FloodgateUtil;
import me.caseload.knockbacksync.util.GeyserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerDataManager {
    private static final Map<User, PlayerData> playerDataMap = new ConcurrentHashMap<User, PlayerData>();

    @Nullable
    public static PlayerData getPlayerData(@NotNull User user) {
        return playerDataMap.get(user);
    }

    public static void addPlayerData(@NotNull User user, @NotNull PlatformPlayer platformPlayer) {
        if (!PlayerDataManager.shouldExempt(platformPlayer.getUUID())) {
            PlayerData playerData = new PlayerData(user, platformPlayer);
            playerDataMap.put(user, playerData);
            Base.INSTANCE.getEventBus().registerListeners(playerData);
        }
    }

    public static void removePlayerData(@NotNull User user) {
        PlayerData playerData = playerDataMap.remove(user);
        if (playerData != null) {
            Base.INSTANCE.getEventBus().unregisterListeners(playerData);
        }
    }

    public static boolean containsPlayerData(@NotNull User user) {
        return playerDataMap.containsKey(user);
    }

    public static boolean shouldExempt(@NotNull UUID uuid) {
        return GeyserUtil.isGeyserPlayer(uuid) || FloodgateUtil.isFloodgatePlayer(uuid) || uuid.toString().startsWith("00000000-0000-0000-0009");
    }
}

