/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.world;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.world.BlockFace;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.util.Vector3i;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.lang.reflect.Method;
import me.caseload.knockbacksync.world.PlatformWorld;
import me.caseload.knockbacksync.world.raytrace.FluidHandling;
import me.caseload.knockbacksync.world.raytrace.RayTraceResult;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.util.Vector;

public class SpigotWorld
implements PlatformWorld {
    protected final World world;
    private static Class<?> craftWorldClass;
    private static Class<?> vec3DClass;
    private static Class<?> movingObjectPositionClass;
    private static Class<?> enumDirectionClass;
    private static Method craftWorldGetHandleMethod;
    private static Method rayTraceMethod;
    private static Method vec3DAddMethod;

    public SpigotWorld(World world) {
        this.world = world;
    }

    private static BlockFace getBlockFaceFrom(org.bukkit.block.BlockFace direction) {
        switch (direction) {
            case NORTH: {
                return BlockFace.NORTH;
            }
            case SOUTH: {
                return BlockFace.SOUTH;
            }
            case EAST: {
                return BlockFace.EAST;
            }
            case WEST: {
                return BlockFace.WEST;
            }
            case UP: {
                return BlockFace.UP;
            }
            case DOWN: {
                return BlockFace.DOWN;
            }
        }
        return null;
    }

    @Override
    public WrappedBlockState getBlockStateAt(int x, int y, int z) {
        Block block = this.world.getBlockAt(x, y, z);
        return SpigotConversionUtil.fromBukkitBlockData((BlockData)block.getBlockData());
    }

    @Override
    public WrappedBlockState getBlockStateAt(Vector3d loc) {
        return this.getBlockStateAt((int)Math.floor(loc.x), (int)Math.floor(loc.y), (int)Math.floor(loc.z));
    }

    @Override
    public RayTraceResult rayTraceBlocks(Vector3d start, Vector3d direction, double maxDistance, FluidHandling fluidHandling, boolean ignorePassableBlocks) {
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThan(ServerVersion.V_1_12_2)) {
            Vector startVec = new Vector(start.getX(), start.getY(), start.getZ());
            Vector directionVec = new Vector(direction.getX(), direction.getY(), direction.getZ());
            FluidCollisionMode fluidMode = fluidHandling == FluidHandling.NONE ? FluidCollisionMode.NEVER : (fluidHandling == FluidHandling.SOURCE_ONLY ? FluidCollisionMode.SOURCE_ONLY : FluidCollisionMode.ALWAYS);
            org.bukkit.util.RayTraceResult result = this.world.rayTraceBlocks(startVec.toLocation(this.world), directionVec, maxDistance, fluidMode, ignorePassableBlocks);
            if (result == null) {
                return null;
            }
            return new RayTraceResult(new Vector3d(result.getHitPosition().getX(), result.getHitPosition().getY(), result.getHitPosition().getZ()), SpigotWorld.getBlockFaceFrom(result.getHitBlockFace()), new Vector3i(result.getHitBlock().getX(), result.getHitBlock().getY(), result.getHitBlock().getZ()), result.getHitBlock() != null ? SpigotConversionUtil.fromBukkitBlockData((BlockData)result.getHitBlock().getBlockData()) : null);
        }
        try {
            Object startPos = vec3DClass.getConstructor(Double.TYPE, Double.TYPE, Double.TYPE).newInstance(start.getX(), start.getY(), start.getZ());
            Object endPos = vec3DAddMethod.invoke(startPos, direction.getX(), direction.getY(), direction.getZ());
            Object hitResult = rayTraceMethod.invoke(craftWorldGetHandleMethod.invoke((Object)this.world, new Object[0]), startPos, endPos, false, true, false);
            if (hitResult == null) {
                return null;
            }
            Vector3d hitPosition = new Vector3d(((Double)hitResult.getClass().getField("pos").get(hitResult)).doubleValue(), ((Double)hitResult.getClass().getField("pos").get(hitResult).getClass().getField("y").get(hitResult.getClass().getField("pos").get(hitResult))).doubleValue(), ((Double)hitResult.getClass().getField("pos").get(hitResult).getClass().getField("z").get(hitResult.getClass().getField("pos").get(hitResult))).doubleValue());
            Object hitDirection = hitResult.getClass().getField("direction").get(hitResult);
            Object hitBlock = hitResult.getClass().getField("e").get(hitResult);
            return new RayTraceResult(hitPosition, SpigotWorld.getHitBlockFace(hitDirection), new Vector3i(((Integer)hitBlock.getClass().getField("x").get(hitBlock)).intValue(), ((Integer)hitBlock.getClass().getField("y").get(hitBlock)).intValue(), ((Integer)hitBlock.getClass().getField("z").get(hitBlock)).intValue()), hitBlock != null ? WrappedBlockState.getByString((String)hitBlock.getClass().getField("type").get(hitBlock).toString()) : null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static BlockFace getHitBlockFace(Object enumDirection) {
        try {
            if (enumDirection.equals(enumDirectionClass.getField("NORTH").get(null))) {
                return BlockFace.NORTH;
            }
            if (enumDirection.equals(enumDirectionClass.getField("SOUTH").get(null))) {
                return BlockFace.SOUTH;
            }
            if (enumDirection.equals(enumDirectionClass.getField("EAST").get(null))) {
                return BlockFace.EAST;
            }
            if (enumDirection.equals(enumDirectionClass.getField("WEST").get(null))) {
                return BlockFace.WEST;
            }
            if (enumDirection.equals(enumDirectionClass.getField("UP").get(null))) {
                return BlockFace.UP;
            }
            if (enumDirection.equals(enumDirectionClass.getField("DOWN").get(null))) {
                return BlockFace.DOWN;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new IllegalStateException("Unexpected value: " + enumDirection);
    }

    static {
        if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_13)) {
            try {
                Object server = Bukkit.getServer().getClass().getDeclaredMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
                String nmsPackage = server.getClass().getPackage().getName();
                String bukkitPackage = Bukkit.getServer().getClass().getPackage().getName();
                craftWorldClass = Class.forName(bukkitPackage + ".CraftWorld");
                vec3DClass = Class.forName(nmsPackage + ".Vec3D");
                movingObjectPositionClass = Class.forName(nmsPackage + ".MovingObjectPosition");
                enumDirectionClass = Class.forName(nmsPackage + ".EnumDirection");
                craftWorldGetHandleMethod = craftWorldClass.getMethod("getHandle", new Class[0]);
                rayTraceMethod = Class.forName(nmsPackage + ".World").getMethod("rayTrace", vec3DClass, vec3DClass, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                vec3DAddMethod = vec3DClass.getMethod("add", Double.TYPE, Double.TYPE, Double.TYPE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

