/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Optional;
import java.util.logging.Logger;
import lombok.Generated;
import me.caseload.knockbacksync.Base;
import me.caseload.knockbacksync.FabricLoaderMod;
import me.caseload.knockbacksync.entity.EntityTickManager;
import me.caseload.knockbacksync.listener.fabric.FabricPlayerDamageListener;
import me.caseload.knockbacksync.listener.fabric.FabricPlayerKnockbackListener;
import me.caseload.knockbacksync.listener.fabric.FabricTickRateChangeListener;
import me.caseload.knockbacksync.manager.ConfigManager;
import me.caseload.knockbacksync.permission.FabricPermissionChecker;
import me.caseload.knockbacksync.permission.PermissionChecker;
import me.caseload.knockbacksync.scheduler.FabricSchedulerAdapter;
import me.caseload.knockbacksync.sender.FabricPlayerSelectorParser;
import me.caseload.knockbacksync.sender.FabricSenderFactory;
import me.caseload.knockbacksync.sender.Sender;
import me.caseload.knockbacksync.stats.custom.FabricStatsManager;
import me.caseload.knockbacksync.stats.custom.PluginJarHashProvider;
import me.caseload.knockbacksync.world.FabricServer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.fabric.FabricServerCommandManager;

public class FabricBase
extends Base {
    private final Logger logger = Logger.getLogger(FabricLoaderMod.class.getName());
    private final FabricPermissionChecker permissionChecker = new FabricPermissionChecker();
    private final FabricSenderFactory fabricSenderFactory = new FabricSenderFactory(this);
    private float tickRate = 20.0f;

    public FabricBase() {
        this.configManager = new ConfigManager();
        this.playerSelectorParser = new FabricPlayerSelectorParser<Sender>();
        this.commandManager = new FabricServerCommandManager(ExecutionCoordinator.simpleCoordinator(), (SenderMapper)this.fabricSenderFactory);
        this.statsManager = new FabricStatsManager();
        this.platformServer = new FabricServer();
        this.pluginJarHashProvider = new PluginJarHashProvider(this.getJarURL());
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public File getDataFolder() {
        return FabricLoader.getInstance().getConfigDir().toFile();
    }

    @Override
    public InputStream getResource(String filename) {
        return this.getClass().getResourceAsStream("/config.yml");
    }

    @Override
    public void load() {
    }

    @Override
    public void enable() {
        super.enable();
    }

    @Override
    public void initializeScheduler() {
        this.scheduler = new FabricSchedulerAdapter();
    }

    @Override
    protected void registerPlatformListeners() {
        new FabricPlayerDamageListener().register();
        new FabricPlayerKnockbackListener().register();
        new FabricTickRateChangeListener().register();
        this.eventBus.registerStaticListeners(EntityTickManager.class);
    }

    @Override
    protected String getVersion() {
        return FabricLoader.getInstance().getModContainer("knockbacksync").map(modContainer -> modContainer.getMetadata().getVersion().getFriendlyString()).orElse("unknown");
    }

    @Override
    public void saveDefaultConfig() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "config.yml");
        if (!configFile.exists()) {
            try (InputStream inputStream = this.getClass().getResourceAsStream("/config.yml");){
                if (inputStream != null) {
                    Files.copy(inputStream, configFile.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public PermissionChecker getPermissionChecker() {
        return this.permissionChecker;
    }

    @Override
    public float getTickRate() {
        return this.tickRate;
    }

    public void setTickRate(float tickRate) {
        this.tickRate = tickRate;
    }

    @Override
    public URL getJarURL() {
        URL jarUrl = null;
        Optional modContainer = FabricLoader.getInstance().getModContainer("knockbacksync");
        if (modContainer.isPresent()) {
            String jarPath = ((ModContainer)modContainer.get()).getRootPath().getFileSystem().toString();
            jarPath = jarPath.replaceAll("^jar:", "").replaceAll("!/$", "");
            try {
                jarUrl = new File(jarPath).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return jarUrl;
    }

    @Override
    public void restartServer() {
    }

    @Override
    public boolean hasRestartScript() {
        return false;
    }

    @Generated
    public FabricSenderFactory getFabricSenderFactory() {
        return this.fabricSenderFactory;
    }
}

