/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.command.subcommand;

import java.util.function.Predicate;
import me.caseload.knockbacksync.Base;
import me.caseload.knockbacksync.command.generic.BuilderCommand;
import me.caseload.knockbacksync.event.KBSyncEventHandler;
import me.caseload.knockbacksync.event.events.ConfigReloadEvent;
import me.caseload.knockbacksync.manager.ConfigManager;
import me.caseload.knockbacksync.sender.Sender;
import me.caseload.knockbacksync.util.ChatUtil;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.permission.PredicatePermission;

public class ReloadCommand
implements BuilderCommand {
    private static final ConfigManager configManager = Base.INSTANCE.getConfigManager();
    private String rawReloadMessage = configManager.getConfigWrapper().getString("messages.reload.success", "&aSuccessfully reloaded KnockbackSync.");

    @Override
    public void register(CommandManager<Sender> manager) {
        manager.command(manager.commandBuilder("knockbacksync", new String[]{"kbsync", "kbs"}).literal("reload", new String[0]).permission(sender -> {
            String permission = "knockbacksync.reload";
            Predicate<Sender> senderPredicate = s -> s.hasPermission("knockbacksync.reload", false);
            return PredicatePermission.of(senderPredicate).testPermission(sender);
        }).handler(context -> {
            configManager.loadConfig(true);
            new ConfigReloadEvent(configManager).post();
            String reloadMessage = ChatUtil.translateAlternateColorCodes('&', this.rawReloadMessage);
            ((Sender)context.sender()).sendMessage(reloadMessage);
        }));
        Base.INSTANCE.getEventBus().registerListeners(this);
    }

    @KBSyncEventHandler
    public void onConfigReload(ConfigReloadEvent event) {
        this.rawReloadMessage = event.getConfigManager().getConfigWrapper().getString("messages.reload.success", "&aSuccessfully reloaded KnockbackSync.");
    }
}

