/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.command.subcommand;

import com.github.retrooper.packetevents.protocol.player.User;
import java.util.function.Predicate;
import me.caseload.knockbacksync.Base;
import me.caseload.knockbacksync.ConfigWrapper;
import me.caseload.knockbacksync.command.generic.BuilderCommand;
import me.caseload.knockbacksync.command.generic.PlayerSelector;
import me.caseload.knockbacksync.event.events.ToggleOnOffEvent;
import me.caseload.knockbacksync.manager.CombatManager;
import me.caseload.knockbacksync.manager.ConfigManager;
import me.caseload.knockbacksync.manager.PlayerDataManager;
import me.caseload.knockbacksync.permission.PermissionChecker;
import me.caseload.knockbacksync.player.PlatformPlayer;
import me.caseload.knockbacksync.sender.Sender;
import me.caseload.knockbacksync.util.ChatUtil;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.permission.PredicatePermission;

public class ToggleCommand
implements BuilderCommand {
    private static final ConfigManager configManager = Base.INSTANCE.getConfigManager();
    private static final PermissionChecker permissionChecker = Base.INSTANCE.getPermissionChecker();
    private static final String TOGGLE_GLOBAL_PERMISSION = "knockbacksync.toggle.global";
    private static final String TOGGLE_SELF_PERMISSION = "knockbacksync.toggle.self";
    private static final String TOGGLE_OTHER_PERMISSION = "knockbacksync.toggle.other";
    private String noGlobalPermissionMessage;
    private String noSelfPermissionMessage;
    private String noOtherPermissionMessage;
    private String serverDisabledMessage;

    public ToggleCommand() {
        this.loadConfig();
    }

    private void loadConfig() {
        ConfigWrapper configWrapper = configManager.getConfigWrapper();
        this.noGlobalPermissionMessage = configWrapper.getString("messages.toggle.permission.no_global", "&cYou don't have permission to toggle the global setting.");
        this.noSelfPermissionMessage = configWrapper.getString("messages.toggle.permission.no_self", "&cYou do not have permission to toggle your knockback.");
        this.noOtherPermissionMessage = configWrapper.getString("messages.toggle.permission.no_other", "&cYou do not have permission to toggle the knockback of other player's.");
        this.serverDisabledMessage = configWrapper.getString("messages.toggle.server_disabled", "&cKnockbacksync is currently disabled on this server. Contact your server administrator for more information.");
    }

    @Override
    public void register(CommandManager<Sender> manager) {
        manager.command(manager.commandBuilder("knockbacksync", new String[]{"kbsync", "kbs"}).literal("toggle", new String[0]).optional("target", Base.INSTANCE.getPlayerSelectorParser().descriptor()).permission(sender -> {
            Predicate<Sender> senderPredicate = s -> s.hasPermission(TOGGLE_GLOBAL_PERMISSION, false) || sender.hasPermission(TOGGLE_SELF_PERMISSION, false) || sender.hasPermission(TOGGLE_OTHER_PERMISSION, false);
            return PredicatePermission.of(senderPredicate).testPermission(sender);
        }).handler(context -> {
            Sender sender = (Sender)context.sender();
            PlayerSelector targetSelector = (PlayerSelector)context.getOrDefault("target", null);
            if (targetSelector == null) {
                if (permissionChecker.hasPermission(sender, TOGGLE_GLOBAL_PERMISSION, false)) {
                    ToggleCommand.toggleGlobalKnockback(sender);
                } else {
                    sender.sendMessage(ChatUtil.translateAlternateColorCodes('&', this.noGlobalPermissionMessage));
                }
            } else {
                boolean senderIsTarget;
                PlatformPlayer target = targetSelector.getSinglePlayer();
                boolean bl = senderIsTarget = sender.getUniqueId() == target.getUUID();
                if (!senderIsTarget && !permissionChecker.hasPermission(sender, TOGGLE_OTHER_PERMISSION, false)) {
                    sender.sendMessage(ChatUtil.translateAlternateColorCodes('&', this.noOtherPermissionMessage));
                    return;
                }
                if (senderIsTarget && !permissionChecker.hasPermission(sender, TOGGLE_SELF_PERMISSION, true)) {
                    sender.sendMessage(ChatUtil.translateAlternateColorCodes('&', this.noSelfPermissionMessage));
                    return;
                }
                if (!configManager.isToggled()) {
                    sender.sendMessage(ChatUtil.translateAlternateColorCodes('&', this.serverDisabledMessage));
                } else {
                    ToggleCommand.togglePlayerKnockback(target, sender);
                }
            }
        }));
    }

    private static void toggleGlobalKnockback(Sender sender) {
        boolean toggledState = !configManager.isToggled();
        ToggleOnOffEvent toggleOnOffEvent = new ToggleOnOffEvent(toggledState);
        toggleOnOffEvent.post();
        if (toggleOnOffEvent.isCancelled()) {
            return;
        }
        toggledState = toggleOnOffEvent.getStatus();
        configManager.setToggled(toggledState);
        configManager.getConfigWrapper().set("enabled", toggledState);
        configManager.saveConfig();
        String message = ChatUtil.translateAlternateColorCodes('&', toggledState ? configManager.getEnableMessage() : configManager.getDisableMessage());
        sender.sendMessage(ChatUtil.translateAlternateColorCodes('&', message));
    }

    private static void togglePlayerKnockback(PlatformPlayer target, Sender sender) {
        String message;
        User user = target.getUser();
        if (user == null) {
            message = ChatUtil.translateAlternateColorCodes('&', configManager.getPlayerDisconnectedWhileExecutingCommand()).replace("%player%", target.getName());
            sender.sendMessage(message);
        }
        if (PlayerDataManager.shouldExempt(target.getUUID())) {
            message = ChatUtil.translateAlternateColorCodes('&', configManager.getPlayerIneligibleMessage()).replace("%player%", target.getName());
            sender.sendMessage(message);
            return;
        }
        boolean hasPlayerData = PlayerDataManager.containsPlayerData(user);
        if (hasPlayerData) {
            if (CombatManager.getPlayers().contains(user)) {
                CombatManager.removePlayer(user);
            }
            PlayerDataManager.removePlayerData(user);
        } else {
            PlayerDataManager.addPlayerData(user, target);
        }
        String message2 = ChatUtil.translateAlternateColorCodes('&', hasPlayerData ? configManager.getPlayerDisableMessage() : configManager.getPlayerEnableMessage()).replace("%player%", target.getName());
        sender.sendMessage(message2);
    }
}

