/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.caseload.knockbacksync.Base;
import me.caseload.knockbacksync.ConfigWrapper;
import me.caseload.knockbacksync.event.KBSyncEventHandler;
import me.caseload.knockbacksync.event.events.ConfigReloadEvent;
import net.minecraft.class_1299;

public class EntityTickManager {
    private static final Map<class_1299<?>, Integer> customTickIntervals = new HashMap();

    @KBSyncEventHandler
    public static void updateTickIntervals(ConfigReloadEvent event) {
        ConfigWrapper configWrapper = event.getConfigManager().getConfigWrapper();
        EntityTickManager.updateTickIntervals(configWrapper);
    }

    private static void updateTickIntervals(ConfigWrapper configWrapper) {
        customTickIntervals.clear();
        for (String entityKey : configWrapper.getKeys("entity_tick_intervals")) {
            try {
                Optional entityType = class_1299.method_5898((String)entityKey.toLowerCase());
                if (!entityType.isPresent()) continue;
                int interval = configWrapper.getInt("entity_tick_intervals." + entityKey, ((class_1299)entityType.get()).method_18388());
                customTickIntervals.put((class_1299)entityType.get(), interval);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Invalid entity type in config: " + entityKey);
            }
        }
    }

    public static int getCustomUpdateInterval(class_1299<?> entityType) {
        return customTickIntervals.getOrDefault(entityType, entityType.method_18388());
    }

    static {
        EntityTickManager.updateTickIntervals(Base.INSTANCE.getConfigManager().getConfigWrapper());
    }
}

