/*
 * Decompiled with CFR 0.152.
 */
package com.zengyj.exposer.handler;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.api.util.StackListResult;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.checkerframework.checker.nullness.qual.NonNull;

public class FluidHandler
implements IFluidHandler,
IStorageCacheListener<FluidStack> {
    private INetwork network;
    private StackListEntry<FluidStack>[] storageCacheData;

    public FluidHandler(INetwork network) {
        this.network = network;
        this.invalidate();
    }

    public int getTanks() {
        return this.storageCacheData.length + 1;
    }

    public @NonNull FluidStack getFluidInTank(int i) {
        return i < this.storageCacheData.length ? (FluidStack)this.storageCacheData[i].getStack() : FluidStack.EMPTY;
    }

    public int getTankCapacity(int i) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int i, @NonNull FluidStack fluidStack) {
        return true;
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        if (fluidStack == FluidStack.EMPTY) {
            return 0;
        }
        FluidStack remainder = this.network.insertFluid(fluidStack, fluidStack.getAmount(), fluidAction == IFluidHandler.FluidAction.EXECUTE ? Action.PERFORM : Action.SIMULATE);
        if (remainder == FluidStack.EMPTY) {
            return fluidStack.getAmount();
        }
        return fluidStack.getAmount() - remainder.getAmount();
    }

    public @NonNull FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        switch (fluidAction) {
            case EXECUTE: {
                return this.network.extractFluid(fluidStack, fluidStack.getAmount(), Action.PERFORM);
            }
            case SIMULATE: {
                return this.network.extractFluid(fluidStack, fluidStack.getAmount(), Action.SIMULATE);
            }
        }
        return FluidStack.EMPTY;
    }

    public @NonNull FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
        for (StackListEntry<FluidStack> fluidEntry : this.storageCacheData) {
            if (((FluidStack)fluidEntry.getStack()).getAmount() < i) continue;
            return this.network.extractFluid((FluidStack)fluidEntry.getStack(), i, fluidAction == IFluidHandler.FluidAction.EXECUTE ? Action.PERFORM : Action.SIMULATE);
        }
        return FluidStack.EMPTY;
    }

    public void onAttached() {
    }

    public void onInvalidated() {
        this.invalidate();
    }

    public void onChanged(StackListResult<FluidStack> stackListResult) {
        this.invalidate();
    }

    public void onChangedBulk(List<StackListResult<FluidStack>> list) {
        this.invalidate();
    }

    private void invalidate() {
        this.storageCacheData = this.network.getFluidStorageCache().getList().getStacks().toArray(new StackListEntry[0]);
    }
}

