/*
 * Decompiled with CFR 0.152.
 */
package com.zengyj.exposer.handler;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.api.util.StackListResult;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ItemHandler
implements IItemHandler,
IStorageCacheListener<ItemStack> {
    private INetwork network;
    private StackListEntry<ItemStack>[] storageCacheData;

    public ItemHandler(INetwork network) {
        this.network = network;
        this.invalidate();
    }

    public int getSlots() {
        return this.storageCacheData.length + 1;
    }

    public @NonNull ItemStack getStackInSlot(int slot) {
        return slot < this.storageCacheData.length ? (ItemStack)this.storageCacheData[slot].getStack() : ItemStack.f_41583_;
    }

    public @NonNull ItemStack insertItem(int slot, @NonNull ItemStack stack, boolean simulate) {
        return this.network.insertItem(stack, stack.m_41613_(), simulate ? Action.SIMULATE : Action.PERFORM);
    }

    public @NonNull ItemStack extractItem(int slot, int amount, boolean simulate) {
        return slot < this.storageCacheData.length ? this.network.extractItem((ItemStack)this.storageCacheData[slot].getStack(), amount, 3, simulate ? Action.SIMULATE : Action.PERFORM) : ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int i, @NonNull ItemStack itemStack) {
        return true;
    }

    public void onAttached() {
    }

    public void onInvalidated() {
        this.invalidate();
    }

    public void onChanged(StackListResult<ItemStack> stackListResult) {
        this.invalidate();
    }

    public void onChangedBulk(List<StackListResult<ItemStack>> list) {
        this.invalidate();
    }

    private void invalidate() {
        this.storageCacheData = this.network.getItemStorageCache().getList().getStacks().toArray(new StackListEntry[0]);
    }
}

