/*
 * Decompiled with CFR 0.152.
 */
package com.zengyj.exposer.node;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.zengyj.exposer.handler.FluidHandler;
import com.zengyj.exposer.handler.ItemHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class NetworkNodeExposer
extends NetworkNode {
    private ItemHandler itemHandler;
    private FluidHandler fluidHandler;
    public static final String ID = "exposer";

    public NetworkNodeExposer(Level level, BlockPos pos) {
        super(level, pos);
    }

    public int getEnergyUsage() {
        return 1;
    }

    public ResourceLocation getId() {
        return new ResourceLocation(ID);
    }

    public void onConnected(INetwork network) {
        super.onConnected(network);
        this.itemHandler = new ItemHandler(network);
        this.fluidHandler = new FluidHandler(network);
        network.getItemStorageCache().addListener((IStorageCacheListener)this.itemHandler);
        network.getFluidStorageCache().addListener((IStorageCacheListener)this.fluidHandler);
    }

    public void onDisconnected(INetwork network) {
        super.onDisconnected(network);
        network.getItemStorageCache().removeListener((IStorageCacheListener)this.itemHandler);
        network.getFluidStorageCache().removeListener((IStorageCacheListener)this.fluidHandler);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }
}

