/*
 * Decompiled with CFR 0.152.
 */
package com.zengyj.exposer.tile;

import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationSpec;
import com.zengyj.exposer.Registry;
import com.zengyj.exposer.node.NetworkNodeExposer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TileExposer
extends NetworkNodeBlockEntity<NetworkNodeExposer> {
    private NonNullSupplier<IItemHandler> itemSupplier;
    private NonNullSupplier<IFluidHandler> fluidSupplier;
    public static BlockEntitySynchronizationSpec SPEC = BlockEntitySynchronizationSpec.builder().build();

    public TileExposer(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registry.EXPOSER_TYPE.get(), pos, state, SPEC);
    }

    public <T> @NonNull LazyOptional<T> getCapability(@NonNull Capability<T> cap, @Nullable Direction direction) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (this.itemSupplier != null) {
                return LazyOptional.of(this.itemSupplier);
            }
            if (((NetworkNodeExposer)this.getNode()).getItemHandler() == null) {
                return LazyOptional.empty();
            }
            this.itemSupplier = new NonNullSupplier<IItemHandler>(){

                public @NonNull IItemHandler get() {
                    return ((NetworkNodeExposer)TileExposer.this.getNode()).getItemHandler();
                }
            };
            return LazyOptional.of(this.itemSupplier);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (this.fluidSupplier != null) {
                return LazyOptional.of(this.fluidSupplier);
            }
            if (((NetworkNodeExposer)this.getNode()).getFluidHandler() == null) {
                return LazyOptional.empty();
            }
            this.fluidSupplier = new NonNullSupplier<IFluidHandler>(){

                public @NonNull IFluidHandler get() {
                    return ((NetworkNodeExposer)TileExposer.this.getNode()).getFluidHandler();
                }
            };
            return LazyOptional.of(this.fluidSupplier);
        }
        return super.getCapability(cap, direction);
    }

    public NetworkNodeExposer createNode(Level level, BlockPos blockPos) {
        return new NetworkNodeExposer(level, blockPos);
    }
}

