/*
 * Decompiled with CFR 0.152.
 */
package com.zengyj.exposer.capabilities;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.tile.TileController;
import com.raoulvdberge.refinedstorage.tile.TileExternalStorage;
import com.zengyj.exposer.handler.FluidHandler;
import com.zengyj.exposer.handler.ItemHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class ControllerCapability
implements ICapabilityProvider {
    private TileController controller;
    private ItemHandler itemHandler;
    private FluidHandler fluidHandler;

    public ControllerCapability(TileController controller) {
        this.controller = controller;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (facing != null) {
            TileEntity te;
            BlockPos pos = this.controller.func_174877_v().func_177972_a(facing);
            if (this.controller.func_145831_w().func_175667_e(pos) && (te = this.controller.func_145831_w().func_175625_s(pos)) instanceof TileExternalStorage) {
                return false;
            }
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.itemHandler != null) {
                return true;
            }
            this.itemHandler = new ItemHandler((INetwork)this.controller);
            this.controller.getItemStorageCache().addListener((IStorageCacheListener)this.itemHandler);
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.fluidHandler != null) {
                return true;
            }
            this.fluidHandler = new FluidHandler((INetwork)this.controller);
            this.controller.getFluidStorageCache().addListener((IStorageCacheListener)this.fluidHandler);
            return true;
        }
        return false;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (!this.hasCapability(capability, facing)) {
            return null;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandler);
        }
        return null;
    }
}

