/*
 * Decompiled with CFR 0.152.
 */
package com.zengyj.exposer.handler;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.util.Action;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.apache.commons.lang3.tuple.Pair;

public class FluidHandler
implements IFluidHandler,
IStorageCacheListener<FluidStack> {
    private INetwork network;
    private FluidStack[] storageCacheData;

    public FluidHandler(INetwork network) {
        this.network = network;
        this.invalidate();
    }

    public IFluidTankProperties[] getTankProperties() {
        ArrayList<FluidTankProperties> properties = new ArrayList<FluidTankProperties>();
        for (FluidStack fluidStack : this.storageCacheData) {
            properties.add(new FluidTankProperties(fluidStack, Integer.MAX_VALUE));
        }
        return properties.toArray(new IFluidTankProperties[properties.size()]);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        FluidStack remainder = this.network.insertFluid(resource, resource.amount, doFill ? Action.PERFORM : Action.SIMULATE);
        if (remainder == null) {
            return resource.amount;
        }
        return resource.amount - remainder.amount;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.network.extractFluid(resource, resource.amount, doDrain ? Action.PERFORM : Action.SIMULATE);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        for (FluidStack fluidStack : this.storageCacheData) {
            if (maxDrain > fluidStack.amount) continue;
            return this.network.extractFluid(fluidStack, maxDrain, doDrain ? Action.PERFORM : Action.SIMULATE);
        }
        return null;
    }

    public void onAttached() {
    }

    public void onInvalidated() {
        this.invalidate();
    }

    public void onChanged(@Nonnull FluidStack fluidStack, int i) {
        this.invalidate();
    }

    public void onChangedBulk(@Nonnull List<Pair<FluidStack, Integer>> list) {
        this.invalidate();
    }

    private void invalidate() {
        this.storageCacheData = this.network.getFluidStorageCache().getList().getStacks().toArray(new FluidStack[0]);
    }
}

