/*
 * Decompiled with CFR 0.152.
 */
package com.zengyj.exposer.handler;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class ItemHandler
implements IItemHandler,
IStorageCacheListener<ItemStack> {
    private INetwork network;
    private ItemStack[] storageCacheData;

    public ItemHandler(INetwork network) {
        this.network = network;
        this.invalidate();
    }

    public int getSlots() {
        return this.storageCacheData.length + 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return slot < this.storageCacheData.length ? this.storageCacheData[slot] : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return StackUtils.nullToEmpty((ItemStack)this.network.insertItem(stack, stack.func_190916_E(), simulate ? Action.SIMULATE : Action.PERFORM));
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return slot < this.storageCacheData.length ? StackUtils.nullToEmpty((ItemStack)this.network.extractItem(this.storageCacheData[slot], amount, 3, simulate ? Action.SIMULATE : Action.PERFORM)) : ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void onAttached() {
    }

    public void onInvalidated() {
        this.invalidate();
    }

    public void onChanged(@Nonnull ItemStack itemStack, int i) {
        this.invalidate();
    }

    public void onChangedBulk(@Nonnull List<Pair<ItemStack, Integer>> list) {
        this.invalidate();
    }

    private void invalidate() {
        this.storageCacheData = this.network.getItemStorageCache().getList().getStacks().toArray(new ItemStack[0]);
    }
}

