/*
 * Decompiled with CFR 0.152.
 */
package com.zengyj.exposer.node;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.zengyj.exposer.handler.FluidHandler;
import com.zengyj.exposer.handler.ItemHandler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class NetworkNodeExposer
extends NetworkNode {
    private ItemHandler itemHandler;
    private FluidHandler fluidHandler;
    public static final String ID = "exposer";

    public NetworkNodeExposer(World world, BlockPos pos) {
        super(world, pos);
    }

    public int getEnergyUsage() {
        return 1;
    }

    public void onConnected(INetwork network) {
        super.onConnected(network);
        this.itemHandler = new ItemHandler(network);
        this.fluidHandler = new FluidHandler(network);
        network.getItemStorageCache().addListener((IStorageCacheListener)this.itemHandler);
        network.getFluidStorageCache().addListener((IStorageCacheListener)this.fluidHandler);
    }

    public void onDisconnected(INetwork network) {
        super.onDisconnected(network);
        network.getItemStorageCache().removeListener((IStorageCacheListener)this.itemHandler);
        network.getFluidStorageCache().removeListener((IStorageCacheListener)this.fluidHandler);
    }

    public String getId() {
        return ID;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }
}

