/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.FogParameters;
import org.joml.Matrix4f;
import org.vivecraft.client.utils.TextUtils;

public class MirrorNotification {
    private static final Minecraft MC = Minecraft.getInstance();
    private static long MIRROR_NOTIFY_START;
    private static long MIRROR_NOTIFY_LEN;
    private static boolean MIRROR_NOTIFY_CLEAR;
    private static String MIRROR_NOTIFY_TEXT;

    public static void notify(String text, boolean clear, int lengthMs) {
        MIRROR_NOTIFY_START = System.currentTimeMillis();
        MIRROR_NOTIFY_TEXT = text;
        MIRROR_NOTIFY_CLEAR = clear;
        MIRROR_NOTIFY_LEN = lengthMs;
    }

    public static void render() {
        if (System.currentTimeMillis() < MIRROR_NOTIFY_START + MIRROR_NOTIFY_LEN) {
            int screenX = MirrorNotification.MC.mainRenderTarget.width;
            int screenY = MirrorNotification.MC.mainRenderTarget.height;
            Matrix4f projection = new Matrix4f().setOrtho(0.0f, (float)screenX, (float)screenY, 0.0f, 1000.0f, 21000.0f);
            RenderSystem.setProjectionMatrix((Matrix4f)projection, (ProjectionType)ProjectionType.ORTHOGRAPHIC);
            RenderSystem.getModelViewStack().pushMatrix();
            RenderSystem.getModelViewStack().identity();
            RenderSystem.getModelViewStack().translate(0.0f, 0.0f, -11000.0f);
            RenderSystem.setShaderFog((FogParameters)FogParameters.NO_FOG);
            GuiGraphics guiGraphics = new GuiGraphics(MC, MC.renderBuffers().bufferSource());
            guiGraphics.pose().scale(3.0f, 3.0f, 3.0f);
            if (MIRROR_NOTIFY_CLEAR) {
                RenderSystem.getDevice().createCommandEncoder().clearColorTexture(MirrorNotification.MC.mainRenderTarget.getColorTexture(), -16777216);
            }
            int TEXT_WORDWRAP_LEN = screenX / 22;
            ArrayList<String> wrapped = new ArrayList<String>();
            if (MIRROR_NOTIFY_TEXT != null) {
                TextUtils.wordWrap(MIRROR_NOTIFY_TEXT, TEXT_WORDWRAP_LEN, wrapped);
            }
            int column = 1;
            int COLUMN_GAP = 12;
            for (String line : wrapped) {
                guiGraphics.drawString(MirrorNotification.MC.font, line, 1, column, -1);
                column += 12;
            }
            guiGraphics.flush();
            RenderSystem.getModelViewStack().popMatrix();
        }
    }
}

