/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import net.minecraft.class_1309;
import net.minecraft.class_3532;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_572;
import net.minecraft.class_630;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.client.extensions.ModelPartExtension;
import org.vivecraft.client.render.VRPlayerModel_WithArms;
import org.vivecraft.client.render.models.FeetModel;
import org.vivecraft.client.utils.ModelUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.common.utils.MathUtils;

public class VRPlayerModel_WithArmsLegs<T extends class_1309>
extends VRPlayerModel_WithArms<T>
implements FeetModel {
    public static final int LOWER_EXTENSION = 2;
    public static final int UPPER_EXTENSION = 2;
    public class_630 leftFoot;
    public class_630 rightFoot;
    public class_630 leftFootPants;
    public class_630 rightFootPants;
    private final Vector3f footDir = new Vector3f();
    private final Vector3f footOffset = new Vector3f();
    private final Vector3f kneeOffset = new Vector3f();
    private final Vector3f footPos = new Vector3f();
    private final Vector3f kneePosTemp = new Vector3f();
    private final Quaternionf footQuat = new Quaternionf();

    public VRPlayerModel_WithArmsLegs(class_630 root, boolean isSlim) {
        super(root, isSlim);
        this.leftFoot = root.method_32086("left_foot");
        this.rightFoot = root.method_32086("right_foot");
        this.leftFootPants = root.method_32086("left_foot_pants");
        this.rightFootPants = root.method_32086("right_foot_pants");
        ModelUtils.textureHackUpper(this.field_3397, this.leftFoot);
        ModelUtils.textureHackUpper(this.field_3392, this.rightFoot);
        ModelUtils.textureHackUpper(this.field_3482, this.rightFootPants);
        ModelUtils.textureHackUpper(this.field_3479, this.leftFootPants);
    }

    public static class_5609 createMesh(class_5605 cubeDeformation, boolean slim) {
        class_5609 meshDefinition = VRPlayerModel_WithArms.createMesh(cubeDeformation, slim);
        class_5610 partDefinition = meshDefinition.method_32111();
        boolean connected = ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected;
        int upperExtension = connected ? 2 : 0;
        int lowerExtension = connected ? 2 : 0;
        float lowerShrinkage = connected ? -0.05f : 0.0f;
        partDefinition.method_32117("left_foot", class_5606.method_32108().method_32101(16, 55 - lowerExtension).method_32098(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.method_32094(lowerShrinkage)), class_5603.method_32090((float)1.9f, (float)24.0f, (float)0.0f));
        partDefinition.method_32117("left_foot_pants", class_5606.method_32108().method_32101(0, 55 - lowerExtension).method_32098(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.method_32094(0.25f + lowerShrinkage)), class_5603.method_32090((float)1.9f, (float)24.0f, (float)0.0f));
        partDefinition.method_32117("right_foot", class_5606.method_32108().method_32101(0, 23 - lowerExtension).method_32098(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.method_32094(lowerShrinkage)), class_5603.method_32090((float)-1.9f, (float)24.0f, (float)0.0f));
        partDefinition.method_32117("right_foot_pants", class_5606.method_32108().method_32101(0, 39 - lowerExtension).method_32098(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.method_32094(0.25f + lowerShrinkage)), class_5603.method_32090((float)-1.9f, (float)24.0f, (float)0.0f));
        partDefinition.method_32117("left_leg", class_5606.method_32108().method_32101(16, 48).method_32098(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), class_5603.method_32090((float)1.9f, (float)12.0f, (float)0.0f));
        partDefinition.method_32117("left_pants", class_5606.method_32108().method_32101(0, 48).method_32098(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation.method_32094(0.25f)), class_5603.method_32090((float)1.9f, (float)12.0f, (float)0.0f));
        partDefinition.method_32117("right_leg", class_5606.method_32108().method_32101(0, 16).method_32098(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), class_5603.method_32090((float)-1.9f, (float)12.0f, (float)0.0f));
        partDefinition.method_32117("right_pants", class_5606.method_32108().method_32101(0, 32).method_32098(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation.method_32094(0.25f)), class_5603.method_32090((float)-1.9f, (float)12.0f, (float)0.0f));
        return meshDefinition;
    }

    @Override
    protected Iterable<class_630> method_22948() {
        return Iterables.concat(super.method_22948(), (Iterable)ImmutableList.of((Object)this.leftFoot, (Object)this.rightFoot, (Object)this.leftFootPants, (Object)this.rightFootPants));
    }

    @Override
    public void method_17087(T player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean noLegs;
        super.method_17087(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (this.rotInfo == null) {
            return;
        }
        boolean bl = noLegs = this.field_3449 || this.laying && (player.method_5799() || this.rotInfo.fbtMode == FBTMode.ARMS_ONLY) || player.method_6128();
        if (!noLegs) {
            Vector3f kneePos;
            if (ClientDataHolderVR.getInstance().vrSettings.playerWalkAnim) {
                float limbRotation = class_3532.method_15362((float)(limbSwing * 0.6662f)) * limbSwingAmount;
                this.footOffset.set(0.0f, -0.5f, 0.0f).rotateX(limbRotation).sub(0.0f, -0.5f, 0.0f).mul(1.0f, 0.75f, 1.0f).rotateY(-this.bodyYaw);
                this.kneeOffset.set(0.0f, -0.5f, 0.0f).rotateX(-Math.abs(limbRotation)).sub(0.0f, -0.5f, 0.0f).rotateY(-this.bodyYaw);
            } else {
                this.footOffset.zero();
                this.kneeOffset.zero();
            }
            if (this.rotInfo.fbtMode == FBTMode.ARMS_ONLY) {
                this.footPos.set(this.field_3397.field_3657, 24.0f + Math.min(this.field_3391.field_3656, 0.0f), this.field_3397.field_3655);
                ModelUtils.modelToWorld(player, (Vector3fc)this.footPos, this.rotInfo, this.bodyYaw, true, true, this.footPos);
                this.footQuat.identity().rotateY((float)Math.PI - this.bodyYaw);
                if (player.method_6123()) {
                    this.footPos.y -= 1.0f;
                }
            } else {
                this.footPos.set(this.rotInfo.leftFootPos);
                this.footQuat.set(this.rotInfo.leftFootQuat);
            }
            if (this.rotInfo.fbtMode == FBTMode.WITH_JOINTS) {
                this.kneePosTemp.set(this.rotInfo.leftKneePos);
                this.kneePosTemp.add((Vector3fc)this.kneeOffset);
                kneePos = this.kneePosTemp;
            } else {
                kneePos = null;
            }
            this.footPos.add((Vector3fc)this.footOffset);
            if (ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected) {
                this.positionConnectedLimb((class_1309)player, this.field_3397, this.leftFoot, (Vector3fc)this.footPos, (Quaternionfc)this.footQuat, 0.0f, (Vector3fc)kneePos, false, null, true);
            } else {
                this.footQuat.transform(MathUtils.BACK, this.footDir);
                this.positionSplitLimb((class_1309)player, this.field_3397, this.leftFoot, (Vector3fc)this.footPos, (Quaternionfc)this.footQuat, -1.5707964f, 0.0f, (Vector3fc)kneePos, false, null, true);
            }
            if (this.rotInfo.fbtMode == FBTMode.ARMS_ONLY) {
                this.footPos.set(this.field_3392.field_3657, 24.0f + Math.min(this.field_3391.field_3656, 0.0f), this.field_3392.field_3655);
                ModelUtils.modelToWorld(player, (Vector3fc)this.footPos, this.rotInfo, this.bodyYaw, true, true, this.footPos);
                if (player.method_6123()) {
                    this.footPos.y -= 1.0f;
                }
            } else {
                this.footPos.set(this.rotInfo.rightFootPos);
                this.footQuat.set(this.rotInfo.rightFootQuat);
            }
            if (this.rotInfo.fbtMode == FBTMode.WITH_JOINTS) {
                this.kneePosTemp.set(this.rotInfo.rightKneePos);
                this.kneePosTemp.add((Vector3fc)this.kneeOffset);
                kneePos = this.kneePosTemp;
            } else {
                kneePos = null;
            }
            this.footPos.add(-this.footOffset.x, this.footOffset.y, -this.footOffset.z);
            if (ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected) {
                this.positionConnectedLimb((class_1309)player, this.field_3392, this.rightFoot, (Vector3fc)this.footPos, (Quaternionfc)this.footQuat, 0.0f, (Vector3fc)kneePos, false, null, true);
            } else {
                this.footQuat.transform(MathUtils.BACK, this.footDir);
                this.positionSplitLimb((class_1309)player, this.field_3392, this.rightFoot, (Vector3fc)this.footPos, (Quaternionfc)this.footQuat, -1.5707964f, 0.0f, (Vector3fc)kneePos, false, null, true);
            }
        }
        if (this.layAmount > 0.0f) {
            ModelUtils.applySwimRotationOffset(player, this.xRot, this.tempV, this.tempV2, new class_630[]{this.field_3397, this.field_3392, this.leftFoot, this.rightFoot});
        }
        if (noLegs) {
            this.footQuat.rotationZYX(this.field_3397.field_3674, this.field_3397.field_3675, this.field_3397.field_3654);
            this.footQuat.transform(0.0f, 12.0f, 0.0f, this.tempV);
            this.leftFoot.method_2851(this.field_3397.field_3657 + this.tempV.x, this.field_3397.field_3656 + this.tempV.y, this.field_3397.field_3655 + this.tempV.z);
            this.rightFoot.method_2851(this.field_3392.field_3657 - this.tempV.x, this.field_3392.field_3656 + this.tempV.y, this.field_3392.field_3655 + (this.field_3449 ? this.tempV.z : -this.tempV.z));
            this.leftFoot.method_33425(this.field_3397.field_3654, this.field_3397.field_3675, this.field_3397.field_3674);
            this.rightFoot.method_33425(this.field_3392.field_3654, this.field_3392.field_3675, this.field_3392.field_3674);
        }
        ((ModelPartExtension)this.leftFoot).vivecraft$setScale(this.legScale, 1.0f, this.legScale);
        ((ModelPartExtension)this.rightFoot).vivecraft$setScale(this.legScale, 1.0f, this.legScale);
        if (player.method_6123()) {
            VRPlayerModel_WithArmsLegs.spinOffset(this.field_3397, this.field_3392, this.leftFoot, this.rightFoot);
        }
        this.field_3482.method_17138(this.field_3397);
        this.field_3479.method_17138(this.field_3392);
        this.leftFootPants.method_17138(this.leftFoot);
        this.rightFootPants.method_17138(this.rightFoot);
        this.leftFootPants.field_3665 = this.field_3482.field_3665;
        this.rightFootPants.field_3665 = this.field_3479.field_3665;
    }

    @Override
    public class_630 getLeftFoot() {
        return this.leftFoot;
    }

    @Override
    public class_630 getRightFoot() {
        return this.rightFoot;
    }

    @Override
    public void method_2818(class_572<T> model) {
        super.method_2818(model);
        if (model instanceof FeetModel) {
            FeetModel feetModel = (FeetModel)model;
            feetModel.getLeftFoot().method_17138(this.leftFoot);
            feetModel.getRightFoot().method_17138(this.rightFoot);
        }
    }

    @Override
    public void method_2805(boolean visible) {
        super.method_2805(visible);
        this.leftFoot.field_3665 = visible;
        this.rightFoot.field_3665 = visible;
        this.leftFootPants.field_3665 = visible;
        this.rightFootPants.field_3665 = visible;
    }
}

