/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_327;
import net.minecraft.class_5222;
import net.minecraft.class_5348;

public class TextUtils {
    private static final char[] ILLEGAL_CHARS = new char[]{'\"', '<', '>', '|', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ':', '*', '?', '\\', '/'};

    public static String sanitizeFileName(String fileName) {
        StringBuilder sanitized = new StringBuilder();
        for (int i = 0; i < fileName.length(); ++i) {
            char ch = fileName.charAt(i);
            if (Arrays.binarySearch(ILLEGAL_CHARS, ch) < 0) {
                sanitized.append(ch);
                continue;
            }
            sanitized.append('_');
        }
        return sanitized.toString();
    }

    public static void wordWrap(String in, int length, ArrayList<String> wrapped) {
        if (length == 0) {
            wrapped.add(in);
            return;
        }
        String newLine = "\n";
        boolean quickExit = false;
        if ((in = in.replace("\r", "")).length() < length) {
            quickExit = true;
            length = in.length();
        }
        if (in.substring(0, length).contains(newLine)) {
            String wrappedLine = in.substring(0, in.indexOf(newLine)).trim();
            wrapped.add(wrappedLine);
            TextUtils.wordWrap(in.substring(in.indexOf(newLine) + 1), length, wrapped);
        } else if (quickExit) {
            wrapped.add(in);
        } else {
            int spaceIndex = Math.max(Math.max(in.lastIndexOf(" ", length), in.lastIndexOf("\t", length)), in.lastIndexOf("-", length));
            if (spaceIndex == -1) {
                spaceIndex = length;
            }
            String wrappedLine = in.substring(0, spaceIndex).trim();
            wrapped.add(wrappedLine);
            TextUtils.wordWrap(in.substring(spaceIndex), length, wrapped);
        }
    }

    public static List<class_5348> wrapText(class_5348 text, int width, class_327 font, @Nullable class_5348 linePrefix) {
        class_5222 componentcollector = new class_5222();
        text.method_27658((style, str) -> {
            componentcollector.method_27462(class_5348.method_29431((String)str, (class_2583)style));
            return Optional.empty();
        }, class_2583.field_24360);
        ArrayList list = Lists.newArrayList();
        font.method_27527().method_29971(componentcollector.method_27463(), width, class_2583.field_24360, (lineText, sameLine) -> list.add(sameLine != false && linePrefix != null ? class_5348.method_29433((class_5348[])new class_5348[]{linePrefix, lineText}) : lineText));
        return list.isEmpty() ? Lists.newArrayList((Object[])new class_5348[]{class_5348.field_25310}) : list;
    }

    public static List<class_124> styleToFormats(class_2583 style) {
        if (style.method_10967()) {
            return new ArrayList<class_124>();
        }
        ArrayList<class_124> arraylist = new ArrayList<class_124>();
        if (style.method_10973() != null) {
            arraylist.add(class_124.method_533((String)style.method_10973().method_27721()));
        }
        if (style.method_10984()) {
            arraylist.add(class_124.field_1067);
        }
        if (style.method_10966()) {
            arraylist.add(class_124.field_1056);
        }
        if (style.method_10986()) {
            arraylist.add(class_124.field_1055);
        }
        if (style.method_10965()) {
            arraylist.add(class_124.field_1073);
        }
        if (style.method_10987()) {
            arraylist.add(class_124.field_1051);
        }
        return arraylist;
    }

    public static String formatsToString(List<class_124> formats) {
        if (formats.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        formats.forEach(builder::append);
        return builder.toString();
    }

    public static String styleToFormatString(class_2583 style) {
        return TextUtils.formatsToString(TextUtils.styleToFormats(style));
    }

    public static class_2561 throwableToComponent(Throwable throwable) {
        class_2585 result = new class_2585(throwable.getClass().getName() + (String)(throwable.getMessage() == null ? "" : ": " + throwable.getMessage()));
        for (StackTraceElement element : throwable.getStackTrace()) {
            result.method_10852((class_2561)new class_2585("\n" + element.toString()));
        }
        return result;
    }

    static {
        Arrays.sort(ILLEGAL_CHARS);
    }
}

