/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_276;
import net.minecraft.class_310;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.vivecraft.Xplat;
import org.vivecraft.client.extensions.RenderTargetExtension;
import org.vivecraft.client_vr.render.helpers.opengl.OpenGLHelper;

public class VRTextureTarget
extends class_276 {
    private final String name;
    public boolean anisotropicFiltering;

    private VRTextureTarget(String name, int width, int height, boolean useDepth, int texId, boolean linearFilter, boolean mipmaps, boolean anisotropicFiltering, boolean useStencil, Vector4fc clearColor) {
        super(useDepth);
        this.method_1236(clearColor.x(), clearColor.y(), clearColor.z(), clearColor.w());
        this.name = name;
        RenderSystem.assertOnGameThreadOrInit();
        ((RenderTargetExtension)((Object)this)).vivecraft$setTexId(texId);
        ((RenderTargetExtension)((Object)this)).vivecraft$setLinearFilter(linearFilter);
        ((RenderTargetExtension)((Object)this)).vivecraft$setMipmaps(mipmaps);
        this.anisotropicFiltering = anisotropicFiltering;
        this.field_1480 = width;
        this.field_1477 = height;
        this.field_1482 = width;
        this.field_1481 = height;
        if (useStencil && !Xplat.enableRenderTargetStencil(this)) {
            ((RenderTargetExtension)((Object)this)).vivecraft$setStencil(true);
        }
        this.method_1234(width, height, class_310.field_1703);
    }

    public void method_1231(int width, int height, boolean clearError) {
        super.method_1231(width, height, clearError);
        if (((RenderTargetExtension)((Object)this)).vivecraft$hasMipmaps()) {
            if (this.anisotropicFiltering) {
                OpenGLHelper.enableAnisotropicFiltering(this);
            }
            OpenGLHelper.genMipmaps(this);
        }
    }

    public String toString() {
        return "\nVivecraft RenderTarget: %s\nSize: %s x %s\nFB ID: %s\nTex ID: %s".formatted(this.name, this.field_1480, this.field_1477, this.field_1476, this.field_1475);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final String name;
        private int width;
        private int height;
        private boolean useDepth;
        private int texId = -1;
        private boolean linearFilter;
        private boolean mipmaps;
        private boolean anisotropicFiltering;
        private boolean stencil;
        private final Vector4f clearColor = new Vector4f(0.0f);

        private Builder(String name) {
            this.name = name;
        }

        public Builder withSize(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder withTexId(int texId) {
            this.texId = texId;
            return this;
        }

        public Builder withDepth() {
            this.useDepth = true;
            return this;
        }

        public Builder withLinearFilter() {
            this.linearFilter = true;
            return this;
        }

        public Builder withMipmaps(boolean useMipmaps) {
            this.mipmaps = useMipmaps;
            return this;
        }

        public Builder withAnisotropicFiltering(boolean useAF) {
            this.anisotropicFiltering = useAF;
            return this;
        }

        public Builder withStencil(boolean useStencil) {
            this.stencil = useStencil;
            return this;
        }

        public Builder withClearColor(float red, float green, float blue, float alpha) {
            this.clearColor.set(red, green, blue, alpha);
            return this;
        }

        public VRTextureTarget build() {
            if (this.width <= 0 || this.height <= 0) {
                throw new IllegalArgumentException("Width and height must be greater than 0");
            }
            return new VRTextureTarget(this.name, this.width, this.height, this.useDepth, this.texId, this.linearFilter, this.mipmaps, this.anisotropicFiltering, this.stencil, (Vector4fc)this.clearColor);
        }
    }
}

