/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.interact_modules;

import net.minecraft.class_1268;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2846;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.InteractModule;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.interact_modules.DebugRenderModule;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.trackers.ClimbTracker;
import org.vivecraft.client_vr.render.helpers.DebugRenderHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;

public class InteractiveHotbarModule
implements DebugRenderModule,
InteractModule {
    private static final class_2960 ID = new class_2960("vivecraft", "interactive_hotbar");
    private final ClientDataHolderVR dh;
    private final class_310 mc;
    public int hotbar = -1;
    private int previousHotbar = -1;

    public InteractiveHotbarModule(class_310 mc, ClientDataHolderVR dh) {
        this.dh = dh;
        this.mc = mc;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public boolean swingsArm() {
        return false;
    }

    @Override
    public void reset(class_746 player, class_1268 hand) {
        if (hand == class_1268.field_5808) {
            this.previousHotbar = this.hotbar;
            this.hotbar = -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isActive(class_746 player, class_1268 hand, class_243 handPosition) {
        float pos;
        int box;
        if (hand != class_1268.field_5808) {
            return false;
        }
        if (this.dh.vrSettings.seated) {
            return false;
        }
        if (this.mc.field_1755 != null) return false;
        if (!this.dh.vrSettings.vrTouchHotbar) {
            return false;
        }
        if (this.dh.vrSettings.vrHudLockMode == VRSettings.HUDLock.HEAD) return false;
        if (!GuiHandler.HUD_POPUP) {
            return false;
        }
        if (player == null) return false;
        if (player.method_31548() == null) {
            return false;
        }
        if (this.dh.climbTracker.isGrabbingLadder() && ClimbTracker.isClaws(player.method_6047())) {
            return false;
        }
        if (!this.dh.interactTracker.isActive(player)) {
            return false;
        }
        if (GuiHandler.GUI_RENDER_POS_ROOM == null) {
            return false;
        }
        float scale = GuiHandler.GUI_SCALE_APPLIED * (float)this.mc.method_22683().method_4495() / (float)GuiHandler.GUI_SCALE_FACTOR_MAX;
        Vector3f barStart = this.getHotbarStart(scale);
        Vector3f barEnd = this.getHotbarEnd((Vector3fc)barStart, scale);
        Vector3f main = this.dh.vrPlayer.vrdata_room_pre.getController(0).getPositionF();
        Vector3f barLine = barStart.sub((Vector3fc)barEnd, new Vector3f());
        Vector3f handToBar = barStart.sub((Vector3fc)main, new Vector3f());
        float dist = handToBar.cross((Vector3fc)barLine, new Vector3f()).length() / barLine.length();
        if (dist > 0.06f) {
            return false;
        }
        float fact = handToBar.dot((Vector3fc)barLine) / barLine.lengthSquared();
        if (fact < -1.0f) {
            return false;
        }
        Vector3f point = barLine.mul(fact, new Vector3f()).sub((Vector3fc)handToBar);
        main.sub((Vector3fc)point, point);
        float barSize = barLine.length();
        float ilen = barStart.distance((Vector3fc)point);
        if (fact < 0.0f) {
            ilen *= -1.0f;
        }
        if ((box = (int)Math.floor(pos = ilen / barSize * 9.0f)) > 8) {
            if (!this.dh.vrSettings.reverseHands) return false;
            if (!((double)pos >= 9.5)) return false;
            if (!((double)pos <= 10.5)) return false;
            box = 9;
        } else if (box < 0) {
            if (this.dh.vrSettings.reverseHands) return false;
            if (!((double)pos <= -0.5)) return false;
            if (!((double)pos >= -1.5)) return false;
            box = 9;
        }
        this.hotbar = box;
        if (this.previousHotbar != this.hotbar) {
            this.dh.vr.triggerHapticPulse(0, 750);
        }
        if (this.hotbar < 0) return false;
        return true;
    }

    private Vector3f getHotbarStart(float scale) {
        Vector3f offset = GuiHandler.GUI_OFFSET_LOCAL.add(-0.32f * scale, -0.38f * scale, 0.0f, new Vector3f());
        GuiHandler.GUI_RENDER_ROTATION_ROOM.transformDirection(offset);
        return offset.add((Vector3fc)GuiHandler.GUI_RENDER_POS_ROOM);
    }

    private Vector3f getHotbarEnd(Vector3fc start, float scale) {
        Vector3f endDir = GuiHandler.GUI_RENDER_ROTATION_ROOM.transformDirection(MathUtils.LEFT, new Vector3f()).mul(0.64f * scale);
        return endDir.add(start);
    }

    @Override
    public boolean onPress(class_746 player, class_1268 hand) {
        if (this.hotbar >= 0 && this.hotbar < 9 && player.method_31548().field_7545 != this.hotbar && hand == class_1268.field_5808) {
            player.method_31548().field_7545 = this.hotbar;
            return true;
        }
        if (this.hotbar == 9 && hand == class_1268.field_5808) {
            player.field_3944.method_2883((class_2596)new class_2846(class_2846.class_2847.field_12969, class_2338.field_10980, class_2350.field_11033));
            return true;
        }
        return false;
    }

    @Override
    public void renderDebug(class_4587 poseStack, boolean isActive) {
        if (this.dh.vrSettings.seated) {
            return;
        }
        if (this.mc.field_1755 != null || !this.dh.vrSettings.vrTouchHotbar) {
            return;
        }
        if (this.dh.vrSettings.vrHudLockMode == VRSettings.HUDLock.HEAD || !GuiHandler.HUD_POPUP) {
            return;
        }
        float scale = GuiHandler.GUI_SCALE_APPLIED * (float)this.mc.method_22683().method_4495() / (float)GuiHandler.GUI_SCALE_FACTOR_MAX;
        VRData world = this.dh.vrPlayer.getVRDataWorld();
        Vector3f barStartRoom = this.getHotbarStart(scale);
        Vector3f barEndRoom = this.getHotbarEnd((Vector3fc)barStartRoom, scale);
        class_243 barStart = VRPlayer.roomToWorldPos((Vector3fc)barStartRoom, world);
        class_243 barEnd = VRPlayer.roomToWorldPos((Vector3fc)barEndRoom, world);
        Vector3f line = MathUtils.subtractToVector3f(barEnd, barStart).div(9.0f);
        Vector3f slotPos = MathUtils.subtractToVector3f(barStart, world.getEye(this.dh.currentPass).getPosition());
        float size = 0.06f * world.worldScale;
        if (!this.dh.vrSettings.reverseHands) {
            DebugRenderHelper.renderCylinder(poseStack, (Vector3fc)slotPos.sub((Vector3fc)line.mul(1.5f, new Vector3f()), new Vector3f()), (Vector3fc)line, size, this.hotbar == 9 ? MathUtils.GREEN : MathUtils.RED);
        }
        for (int i = 0; i < 9; ++i) {
            DebugRenderHelper.renderCylinder(poseStack, (Vector3fc)slotPos, (Vector3fc)line, size, this.hotbar == i ? MathUtils.GREEN : MathUtils.RED);
            slotPos.add((Vector3fc)line);
        }
        if (this.dh.vrSettings.reverseHands) {
            DebugRenderHelper.renderCylinder(poseStack, (Vector3fc)slotPos.add((Vector3fc)line.mul(0.5f, new Vector3f()), new Vector3f()), (Vector3fc)line, size, this.hotbar == 9 ? MathUtils.GREEN : MathUtils.RED);
        }
    }
}

