/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.interact_modules;

import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.HeldInteractModule;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.interact_modules.DebugRenderModule;
import org.vivecraft.client_vr.render.helpers.DebugRenderHelper;
import org.vivecraft.common.utils.MathUtils;

public class ScreenshotCameraModule
implements DebugRenderModule,
HeldInteractModule {
    private static final class_2960 ID = new class_2960("vivecraft", "screenshot_camera");
    private static final float INTERACT_DIST = 0.11f;
    private final ClientDataHolderVR dh;
    private class_243 camPos;

    public ScreenshotCameraModule(ClientDataHolderVR dh) {
        this.dh = dh;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public int getPriority() {
        return 750;
    }

    @Override
    public boolean isActive(@Nullable class_746 player, class_1268 hand, class_243 handPosition) {
        if (this.dh.cameraTracker.isVisible() && !this.dh.cameraTracker.isQuickMode()) {
            VRData.VRDevicePose camData = this.dh.vrPlayer.vrdata_world_pre.getEye(RenderPass.CAMERA);
            Vector3f offset = camData.getCustomVector(MathUtils.BACK).mul(0.08f * this.dh.vrPlayer.vrdata_world_pre.worldScale);
            this.camPos = camData.getPosition().method_1023((double)offset.x, (double)offset.y, (double)offset.z);
            return handPosition.method_1022(this.camPos) < (double)(0.11f * this.dh.vrPlayer.vrdata_world_pre.worldScale);
        }
        return false;
    }

    @Override
    public boolean onPress(@Nullable class_746 player, class_1268 hand) {
        this.dh.cameraTracker.startMoving(hand.ordinal());
        return true;
    }

    @Override
    public void onRelease(@Nullable class_746 player, class_1268 hand) {
        if (this.dh.cameraTracker.isMoving() && this.dh.cameraTracker.getMovingController() == hand.ordinal() && !this.dh.cameraTracker.isQuickMode()) {
            this.dh.cameraTracker.stopMoving();
        }
    }

    public boolean isActive() {
        return this.dh.interactTracker.isActiveModule(this);
    }

    @Override
    public void renderDebug(class_4587 poseStack, boolean isActive) {
        if (this.dh.cameraTracker.isVisible() && !this.dh.cameraTracker.isQuickMode() && this.camPos != null) {
            VRData world = this.dh.vrPlayer.getVRDataWorld();
            DebugRenderHelper.renderSphere(poseStack, (Vector3fc)MathUtils.subtractToVector3f(this.camPos, world.getEye(this.dh.currentPass).getPosition()), 0.11f * world.worldScale, isActive ? MathUtils.GREEN : MathUtils.RED);
        }
    }
}

