/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.menuworlds;

import com.google.common.io.Files;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraft.class_1208;
import net.minecraft.class_155;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3513;
import net.minecraft.class_3542;
import net.minecraft.class_3551;
import net.minecraft.class_4761;
import net.minecraft.class_4763;
import net.minecraft.class_5455;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import org.vivecraft.Xplat;
import org.vivecraft.client_vr.menuworlds.FakeBlockAccess;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.mixin.client_vr.world.level.biome.BiomeAccessor;

public class MenuWorldExporter {
    public static final int VERSION = 5;
    public static final int MIN_VERSION = 2;
    private static final DataFixer DATA_FIXER = class_3551.method_15450();
    private static final class_5485 DUMMY_GENERATION_SETTINGS = new class_5485.class_5495().method_30987();
    private static final class_5483 DUMMY_MOB_SPAWN_SETTINGS = new class_5483.class_5496().method_31007();

    public static byte[] saveArea(class_1937 level, int xMin, int zMin, int xSize, int zSize, int ground) throws IOException {
        int i;
        BlockStateMapper blockStateMapper = new BlockStateMapper();
        PaletteBiomeMapper biomeMapper = new PaletteBiomeMapper();
        int yMin = level.method_31607();
        int ySize = level.method_31605();
        int[] blocks = new int[xSize * ySize * zSize];
        byte[] skylightmap = new byte[xSize * ySize * zSize];
        byte[] blocklightmap = new byte[xSize * ySize * zSize];
        int[] biomemap = new int[xSize * ySize * zSize / 64];
        for (int x = xMin; x < xMin + xSize; ++x) {
            int xl = x - xMin;
            for (int z = zMin; z < zMin + zSize; ++z) {
                int zl = z - zMin;
                for (int y = yMin; y < yMin + ySize; ++y) {
                    int yl = y - yMin;
                    int index3 = (yl * zSize + zl) * xSize + xl;
                    class_2338 pos3 = new class_2338(x, y, z);
                    class_2680 state = level.method_8320(pos3);
                    blocks[index3] = blockStateMapper.getId(state);
                    skylightmap[index3] = (byte)level.method_8314(class_1944.field_9284, pos3);
                    blocklightmap[index3] = (byte)level.method_8314(class_1944.field_9282, pos3);
                    if (x % 4 != 0 || y % 4 != 0 || z % 4 != 0) continue;
                    int indexBiome = (yl / 4 * (zSize / 4) + zl / 4) * (xSize / 4) + xl / 4;
                    biomemap[indexBiome] = biomeMapper.getId((class_1959)level.method_16359(x / 4, y / 4, z / 4).comp_349());
                }
            }
        }
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(data);
        dos.writeInt(xSize);
        dos.writeInt(ySize);
        dos.writeInt(zSize);
        dos.writeInt(ground);
        dos.writeUTF(level.method_8597().method_31181().toString());
        if (level instanceof class_3218) {
            dos.writeBoolean(((class_3218)level).method_28125());
        } else {
            dos.writeBoolean(((class_638)level).method_28104().field_24607);
        }
        dos.writeBoolean(level.method_8597().method_12491());
        if (level instanceof class_3218) {
            dos.writeLong(((class_3218)level).method_8412());
        } else {
            dos.writeLong(level.method_22385().field_20641);
        }
        dos.writeInt(class_155.method_16673().method_37912().method_38494());
        dos.writeBoolean(level.method_8597().field_24761.isPresent());
        if (level.method_8597().field_24761.isPresent()) {
            dos.writeLong(level.method_8597().field_24761.getAsLong());
        }
        dos.writeBoolean(level.method_8597().method_27998());
        dos.writeInt(level.method_8597().method_29959());
        dos.writeFloat(level.method_8597().field_24766);
        dos.writeFloat(switch (class_310.method_1551().field_1724.method_5735()) {
            case class_2350.field_11035 -> 180.0f;
            case class_2350.field_11039 -> -90.0f;
            case class_2350.field_11034 -> 90.0f;
            default -> 0.0f;
        });
        dos.writeBoolean(level.method_8430(1.0f) > 0.0f);
        dos.writeBoolean(level.method_8478(1.0f) > 0.0f);
        blockStateMapper.writePalette(dos);
        biomeMapper.writePalette(dos, level.method_30349());
        for (i = 0; i < blocks.length; ++i) {
            dos.writeInt(blocks[i]);
        }
        for (i = 0; i < skylightmap.length; ++i) {
            dos.writeByte(skylightmap[i] | blocklightmap[i] << 4);
        }
        for (i = 0; i < biomemap.length; ++i) {
            dos.writeInt(biomemap[i]);
        }
        Header header = new Header();
        header.version = 5;
        header.uncompressedSize = data.size();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream headerStream = new DataOutputStream(output);
        header.write(headerStream);
        Deflater deflater = new Deflater(9);
        deflater.setInput(data.toByteArray());
        deflater.finish();
        byte[] buffer = new byte[0x100000];
        while (!deflater.finished()) {
            int len = deflater.deflate(buffer);
            output.write(buffer, 0, len);
        }
        return output.toByteArray();
    }

    public static void saveAreaToFile(class_1937 world, int xMin, int zMin, int xSize, int zSize, int ground, File file) throws IOException {
        byte[] bytes = MenuWorldExporter.saveArea(world, xMin, zMin, xSize, zSize, ground);
        Files.write((byte[])bytes, (File)file);
    }

    public static FakeBlockAccess loadWorld(byte[] data) throws IOException, DataFormatException {
        BiomeMapper biomeMapper;
        float dimAmbientLight;
        int dimMinY;
        boolean dimHasCeiling;
        int dataVersion;
        class_2960 dimName;
        Header header = new Header();
        try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));){
            header.read(dis);
        }
        if (header.version > 5 || header.version < 2) {
            throw new DataFormatException("Unsupported menu world version: " + header.version);
        }
        Inflater inflater = new Inflater();
        inflater.setInput(data, 8, data.length - 8);
        ByteArrayOutputStream output = new ByteArrayOutputStream(header.uncompressedSize);
        byte[] buffer = new byte[0x100000];
        while (!inflater.finished()) {
            int len = inflater.inflate(buffer);
            output.write(buffer, 0, len);
        }
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(output.toByteArray()));
        int xSize = dis.readInt();
        int ySize = dis.readInt();
        int zSize = dis.readInt();
        int ground = dis.readInt();
        if (header.version < 4) {
            int dimId = dis.readInt();
            dimName = switch (dimId) {
                case -1 -> class_2874.field_26753;
                case 1 -> class_2874.field_26754;
                default -> class_2874.field_26752;
            };
        } else {
            dimName = new class_2960(dis.readUTF());
        }
        boolean isFlat = header.version < 4 ? dis.readUTF().equals("flat") : dis.readBoolean();
        boolean dimHasSkyLight = dis.readBoolean();
        long seed = 0L;
        if (header.version >= 3) {
            seed = dis.readLong();
        }
        if ((dataVersion = header.version == 2 ? 1631 : (header.version == 3 ? 2230 : (header.version == 4 ? 2586 : dis.readInt()))) > class_155.method_16673().method_37912().method_38494()) {
            VRSettings.LOGGER.warn("Vivecraft: Menuworld data version is newer than current, this menu world may not load correctly.");
        }
        OptionalLong dimFixedTime = OptionalLong.empty();
        if (header.version < 5) {
            if (class_2874.field_26753.equals((Object)dimName)) {
                dimFixedTime = OptionalLong.of(18000L);
                dimHasCeiling = true;
                dimMinY = 0;
                dimAmbientLight = 0.1f;
            } else if (class_2874.field_26754.equals((Object)dimName)) {
                dimFixedTime = OptionalLong.of(6000L);
                dimHasCeiling = false;
                dimMinY = 0;
                dimAmbientLight = 0.0f;
            } else {
                dimHasCeiling = false;
                dimMinY = 0;
                dimAmbientLight = 0.0f;
            }
        } else {
            if (dis.readBoolean()) {
                dimFixedTime = OptionalLong.of(dis.readLong());
            }
            dimHasCeiling = dis.readBoolean();
            dimMinY = dis.readInt();
            dimAmbientLight = dis.readFloat();
        }
        class_2874 dimensionType = class_2874.method_32922((OptionalLong)dimFixedTime, (boolean)dimHasSkyLight, (boolean)dimHasCeiling, (boolean)false, (boolean)false, (double)1.0, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)dimMinY, (int)ySize, (int)ySize, (class_6862)class_3481.field_25588, (class_2960)dimName, (float)dimAmbientLight);
        float rotation = 0.0f;
        boolean rain = false;
        boolean thunder = false;
        if (header.version >= 5) {
            rotation = dis.readFloat();
            rain = dis.readBoolean();
            thunder = dis.readBoolean();
        }
        BlockStateMapper blockStateMapper = new BlockStateMapper();
        blockStateMapper.readPalette(dis, dataVersion);
        if (header.version >= 5) {
            biomeMapper = new PaletteBiomeMapper();
            ((PaletteBiomeMapper)biomeMapper).readPalette(dis);
        } else {
            biomeMapper = new LegacyBiomeMapper();
        }
        class_2680[] blocks = new class_2680[xSize * ySize * zSize];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = blockStateMapper.getState(dis.readInt());
        }
        short[][] heightmap = new short[xSize][zSize];
        for (int x = 0; x < xSize; ++x) {
            block12: for (int z = 0; z < zSize; ++z) {
                for (int y = ySize - 1; y >= 0; --y) {
                    int index = (y * zSize + z) * xSize + x;
                    if (!blocks[index].method_26207().method_15801() && blocks[index].method_26227().method_15769()) continue;
                    heightmap[x][z] = (short)(y + 1);
                    continue block12;
                }
            }
        }
        byte[] skylightmap = new byte[xSize * ySize * zSize];
        byte[] blocklightmap = new byte[xSize * ySize * zSize];
        for (int i = 0; i < skylightmap.length; ++i) {
            int b = dis.readByte() & 0xFF;
            skylightmap[i] = (byte)(b & 0xF);
            blocklightmap[i] = (byte)(b >> 4);
        }
        class_1959[] biomemap = new class_1959[xSize * ySize * zSize / 64];
        if (header.version == 2) {
            class_1959[] tempBiomemap = new class_1959[xSize * zSize];
            for (int i = 0; i < tempBiomemap.length; ++i) {
                tempBiomemap[i] = biomeMapper.getBiome(dis.readInt());
            }
            for (int x = 0; x < xSize / 4; ++x) {
                for (int z = 0; z < zSize / 4; ++z) {
                    biomemap[z * (xSize / 4) + x] = tempBiomemap[z * 4 * xSize + x * 4];
                }
            }
            int yStride = xSize / 4 * (zSize / 4);
            for (int y = 1; y < ySize / 4; ++y) {
                System.arraycopy(biomemap, 0, biomemap, yStride * y, yStride);
            }
        } else {
            for (int i = 0; i < biomemap.length; ++i) {
                biomemap[i] = biomeMapper.getBiome(dis.readInt());
            }
        }
        return new FakeBlockAccess(header.version, seed, blocks, skylightmap, blocklightmap, biomemap, heightmap, xSize, ySize, zSize, ground, dimensionType, isFlat, rotation, rain, thunder);
    }

    public static FakeBlockAccess loadWorld(InputStream is) throws IOException, DataFormatException {
        int count;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        byte[] buffer = new byte[0x100000];
        while ((count = is.read(buffer)) != -1) {
            data.write(buffer, 0, count);
        }
        return MenuWorldExporter.loadWorld(data.toByteArray());
    }

    public static int readVersion(File file) throws IOException {
        try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
            Header header = new Header();
            header.read(dis);
            int n = header.version;
            return n;
        }
    }

    private static <T extends Enum> Optional<T> decodeEnum(Class<T> type, String input) {
        return Arrays.stream((Enum[])type.getEnumConstants()).filter(e -> input.equals(((class_3542)e).method_15434())).findFirst();
    }

    private static class BlockStateMapper {
        class_3513<class_2680> paletteMap = class_3513.method_37913((int)256);

        private BlockStateMapper() {
        }

        int getId(class_2680 state) {
            int id = this.paletteMap.method_10206((Object)state);
            return id == -1 ? this.paletteMap.method_15225((Object)state) : id;
        }

        class_2680 getState(int id) {
            return (class_2680)this.paletteMap.method_10200(id);
        }

        void readPalette(DataInputStream dis, int dataVersion) throws IOException {
            this.paletteMap.method_15229();
            int size = dis.readInt();
            for (int i = 0; i < size; ++i) {
                class_2487 tag = (class_2487)class_2487.field_21029.method_23262((DataInput)dis, 0, class_2505.field_11556);
                tag = (class_2487)DATA_FIXER.update(class_1208.field_5720, new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag), dataVersion, class_155.method_16673().method_37912().method_38494()).getValue();
                this.paletteMap.method_15225((Object)class_2512.method_10681((class_2487)tag));
            }
        }

        void writePalette(DataOutputStream dos) throws IOException {
            dos.writeInt(this.paletteMap.method_10204());
            for (int i = 0; i < this.paletteMap.method_10204(); ++i) {
                class_2487 compoundtag = class_2512.method_10686((class_2680)((class_2680)this.paletteMap.method_10200(i)));
                compoundtag.method_10713((DataOutput)dos);
            }
        }
    }

    private static class PaletteBiomeMapper
    implements BiomeMapper {
        private final class_3513<class_1959> paletteMap = class_3513.method_37913((int)256);

        private PaletteBiomeMapper() {
        }

        @Override
        public int getId(class_1959 biome) {
            int id = this.paletteMap.method_10206((Object)biome);
            return id == -1 ? this.paletteMap.method_15225((Object)biome) : id;
        }

        @Override
        public class_1959 getBiome(int id) {
            return (class_1959)this.paletteMap.method_10200(id);
        }

        void readPalette(DataInputStream dis) throws IOException {
            this.paletteMap.method_15229();
            int size = dis.readInt();
            for (int i = 0; i < size; ++i) {
                class_1959.class_1960 builder = new class_1959.class_1960();
                dis.readUTF();
                boolean hasPrecipitation = dis.readBoolean();
                float temperature = dis.readFloat();
                builder.method_8735(hasPrecipitation ? (temperature < 0.15f ? class_1959.class_1963.field_9383 : class_1959.class_1963.field_9382) : class_1959.class_1963.field_9384);
                builder.method_8747(temperature);
                builder.method_8738(class_1959.class_1961.field_9371);
                MenuWorldExporter.decodeEnum(class_1959.class_5484.class, dis.readUTF()).ifPresent(arg_0 -> ((class_1959.class_1960)builder).method_30777(arg_0));
                builder.method_8727(dis.readFloat());
                class_4763.class_4764 effectsBuilder = new class_4763.class_4764();
                effectsBuilder.method_24392(dis.readInt());
                effectsBuilder.method_24395(dis.readInt());
                effectsBuilder.method_24397(dis.readInt());
                effectsBuilder.method_30820(dis.readInt());
                if (dis.readBoolean()) {
                    effectsBuilder.method_30821(dis.readInt());
                }
                if (dis.readBoolean()) {
                    effectsBuilder.method_30822(dis.readInt());
                }
                MenuWorldExporter.decodeEnum(class_4763.class_5486.class, dis.readUTF()).ifPresent(arg_0 -> ((class_4763.class_4764)effectsBuilder).method_30818(arg_0));
                if (dis.readBoolean()) {
                    class_2396 particleType = (class_2396)class_2378.field_11141.method_10223(new class_2960(dis.readUTF()));
                    float probability = dis.readFloat();
                    if (particleType instanceof class_2394) {
                        effectsBuilder.method_24393(new class_4761((class_2394)particleType, probability));
                    }
                }
                class_1959 biome = builder.method_24379(effectsBuilder.method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972();
                this.paletteMap.method_15225((Object)biome);
            }
        }

        void writePalette(DataOutputStream dos, class_5455 registryAccess) throws IOException {
            dos.writeInt(this.paletteMap.method_10204());
            for (int i = 0; i < this.paletteMap.method_10204(); ++i) {
                class_1959 biome = (class_1959)this.paletteMap.method_10200(i);
                dos.writeUTF(registryAccess.method_30530(class_2378.field_25114).method_10221((Object)biome).toString());
                class_1959.class_5482 climateSettings = ((BiomeAccessor)biome).getClimateSettings();
                dos.writeBoolean(biome.method_8694() != class_1959.class_1963.field_9384);
                dos.writeFloat(biome.method_8712());
                dos.writeUTF(climateSettings.field_26401.method_15434());
                dos.writeFloat(biome.method_8715());
                class_4763 specialEffects = Xplat.getBiomeEffects(biome);
                dos.writeInt(specialEffects.method_24387());
                dos.writeInt(specialEffects.method_24388());
                dos.writeInt(specialEffects.method_24389());
                dos.writeInt(specialEffects.method_30810());
                dos.writeBoolean(specialEffects.method_30811().isPresent());
                if (specialEffects.method_30811().isPresent()) {
                    dos.writeInt((Integer)specialEffects.method_30811().get());
                }
                dos.writeBoolean(specialEffects.method_30812().isPresent());
                if (specialEffects.method_30812().isPresent()) {
                    dos.writeInt((Integer)specialEffects.method_30812().get());
                }
                dos.writeUTF(specialEffects.method_30814().method_15434());
                dos.writeBoolean(specialEffects.method_24390().isPresent());
                if (!specialEffects.method_24390().isPresent()) continue;
                class_4761 ambientParticleSettings = (class_4761)specialEffects.method_24390().get();
                dos.writeUTF(class_2378.field_11141.method_10221((Object)ambientParticleSettings.method_24369().method_10295()).toString());
                dos.writeFloat(ambientParticleSettings.field_22035);
            }
        }
    }

    public static class Header {
        public static final int SIZE = 8;
        public int version;
        public int uncompressedSize;

        public void read(DataInputStream dis) throws IOException {
            this.version = dis.readInt();
            this.uncompressedSize = dis.readInt();
        }

        public void write(DataOutputStream dos) throws IOException {
            dos.writeInt(this.version);
            dos.writeInt(this.uncompressedSize);
        }
    }

    private static class LegacyBiomeMapper
    implements BiomeMapper {
        private static final Map<Integer, class_1959> MAP = new HashMap<Integer, class_1959>();

        private LegacyBiomeMapper() {
        }

        @Override
        public int getId(class_1959 biome) {
            throw new UnsupportedOperationException("this mapper does not support reversing biomes to IDs");
        }

        @Override
        public class_1959 getBiome(int id) {
            class_1959 biome = MAP.get(id);
            return biome != null ? biome : MAP.get(1);
        }

        static {
            MAP.put(1, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.8f).method_8727(0.4f).method_8738(class_1959.class_1961.field_9355).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7907327).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(127, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(0.5f).method_8727(0.5f).method_8738(class_1959.class_1961.field_9371).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8103167).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(0, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.5f).method_8727(0.5f).method_8738(class_1959.class_1961.field_9367).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8103167).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(2, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(2.0f).method_8727(0.0f).method_8738(class_1959.class_1961.field_9368).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7254527).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(3, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.2f).method_8727(0.3f).method_8738(class_1959.class_1961.field_9357).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8233727).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(4, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.7f).method_8727(0.8f).method_8738(class_1959.class_1961.field_9370).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7972607).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(5, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.25f).method_8727(0.8f).method_8738(class_1959.class_1961.field_9361).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8233983).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(6, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.8f).method_8727(0.9f).method_8738(class_1959.class_1961.field_9364).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(6388580).method_24397(2302743).method_30820(7907327).method_30821(6975545).method_30818(class_4763.class_5486.field_26428).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(7, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.5f).method_8727(0.5f).method_8738(class_1959.class_1961.field_9369).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8103167).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(8, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(2.0f).method_8727(0.0f).method_8738(class_1959.class_1961.field_9366).method_24379(new class_4763.class_4764().method_24392(0x330808).method_24395(4159204).method_24397(329011).method_30820(7254527).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(9, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(0.5f).method_8727(0.5f).method_8738(class_1959.class_1961.field_9360).method_24379(new class_4763.class_4764().method_24392(0xA080A0).method_24395(4159204).method_24397(329011).method_30820(0).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(10, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9383).method_8747(0.0f).method_8727(0.5f).method_30777(class_1959.class_5484.field_26408).method_8738(class_1959.class_1961.field_9367).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(3750089).method_24397(329011).method_30820(8364543).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(11, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9383).method_8747(0.0f).method_8727(0.5f).method_8738(class_1959.class_1961.field_9369).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(3750089).method_24397(329011).method_30820(8364543).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(12, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9383).method_8747(0.0f).method_8727(0.5f).method_8738(class_1959.class_1961.field_9362).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8364543).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(13, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9383).method_8747(0.0f).method_8727(0.5f).method_8738(class_1959.class_1961.field_9362).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8364543).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(14, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.9f).method_8727(1.0f).method_8738(class_1959.class_1961.field_9365).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7842047).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(15, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.9f).method_8727(1.0f).method_8738(class_1959.class_1961.field_9365).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7842047).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(16, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.8f).method_8727(0.4f).method_8738(class_1959.class_1961.field_9363).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7907327).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(17, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(2.0f).method_8738(class_1959.class_1961.field_9368).method_8727(0.0f).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7254527).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(18, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.7f).method_8738(class_1959.class_1961.field_9370).method_8727(0.8f).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7972607).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(19, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.25f).method_8727(0.8f).method_8738(class_1959.class_1961.field_9361).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8233983).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(20, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.2f).method_8727(0.3f).method_8738(class_1959.class_1961.field_9357).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8233727).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(21, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.95f).method_8727(0.9f).method_8738(class_1959.class_1961.field_9358).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7842047).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(22, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.95f).method_8727(0.9f).method_8738(class_1959.class_1961.field_9358).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7842047).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(23, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.95f).method_8727(0.8f).method_8738(class_1959.class_1961.field_9358).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7842047).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(24, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.5f).method_8727(0.5f).method_8738(class_1959.class_1961.field_9367).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8103167).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(25, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.2f).method_8727(0.3f).method_8738(class_1959.class_1961.field_9371).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8233727).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(26, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9383).method_8747(0.05f).method_8727(0.3f).method_8738(class_1959.class_1961.field_9363).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4020182).method_24397(329011).method_30820(8364543).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(27, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.6f).method_8727(0.6f).method_8738(class_1959.class_1961.field_9370).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8037887).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(28, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.6f).method_8727(0.6f).method_8738(class_1959.class_1961.field_9370).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8037887).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(29, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.7f).method_8727(0.8f).method_8738(class_1959.class_1961.field_9370).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7972607).method_30818(class_4763.class_5486.field_26427).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(30, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9383).method_8747(-0.5f).method_8727(0.4f).method_8738(class_1959.class_1961.field_9361).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4020182).method_24397(329011).method_30820(8625919).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(31, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9383).method_8747(-0.5f).method_8727(0.4f).method_8738(class_1959.class_1961.field_9361).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4020182).method_24397(329011).method_30820(8625919).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(32, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.3f).method_8727(0.8f).method_8738(class_1959.class_1961.field_9361).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8168447).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(33, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.3f).method_8727(0.8f).method_8738(class_1959.class_1961.field_9361).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8168447).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(34, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.2f).method_8727(0.3f).method_8738(class_1959.class_1961.field_9357).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8233727).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(35, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(1.2f).method_8727(0.0f).method_8738(class_1959.class_1961.field_9356).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7711487).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(36, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(1.0f).method_8727(0.0f).method_8738(class_1959.class_1961.field_9356).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7776511).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(37, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(2.0f).method_8727(0.0f).method_8738(class_1959.class_1961.field_9354).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7254527).method_30821(10387789).method_30822(9470285).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(38, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(2.0f).method_8727(0.0f).method_8738(class_1959.class_1961.field_9354).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7254527).method_30821(10387789).method_30822(9470285).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(39, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(2.0f).method_8727(0.0f).method_8738(class_1959.class_1961.field_9354).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7254527).method_30821(10387789).method_30822(9470285).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(40, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(0.5f).method_8727(0.5f).method_8738(class_1959.class_1961.field_9360).method_24379(new class_4763.class_4764().method_24392(0xA080A0).method_24395(4159204).method_24397(329011).method_30820(0).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(41, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(0.5f).method_8727(0.5f).method_8738(class_1959.class_1961.field_9360).method_24379(new class_4763.class_4764().method_24392(0xA080A0).method_24395(4159204).method_24397(329011).method_30820(0).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(42, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(0.5f).method_8727(0.5f).method_8738(class_1959.class_1961.field_9360).method_24379(new class_4763.class_4764().method_24392(0xA080A0).method_24395(4159204).method_24397(329011).method_30820(0).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(43, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(0.5f).method_8727(0.5f).method_8738(class_1959.class_1961.field_9360).method_24379(new class_4763.class_4764().method_24392(0xA080A0).method_24395(4159204).method_24397(329011).method_30820(0).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(44, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.5f).method_8727(0.5f).method_8738(class_1959.class_1961.field_9367).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4445678).method_24397(270131).method_30820(8103167).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(45, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.5f).method_8727(0.5f).method_8738(class_1959.class_1961.field_9367).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4566514).method_24397(267827).method_30820(8103167).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(46, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.5f).method_8727(0.5f).method_8738(class_1959.class_1961.field_9367).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4020182).method_24397(329011).method_30820(8103167).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(47, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.5f).method_8727(0.5f).method_8738(class_1959.class_1961.field_9367).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4445678).method_24397(270131).method_30820(8103167).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(48, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.5f).method_8727(0.5f).method_8738(class_1959.class_1961.field_9367).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4566514).method_24397(267827).method_30820(8103167).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(49, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.5f).method_8727(0.5f).method_8738(class_1959.class_1961.field_9367).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4020182).method_24397(329011).method_30820(8103167).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(50, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.5f).method_8727(0.5f).method_30777(class_1959.class_5484.field_26408).method_8738(class_1959.class_1961.field_9367).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(3750089).method_24397(329011).method_30820(8103167).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(129, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.8f).method_8727(0.4f).method_8738(class_1959.class_1961.field_9355).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7907327).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(130, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(2.0f).method_8727(0.0f).method_8738(class_1959.class_1961.field_9368).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7254527).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(131, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.2f).method_8727(0.3f).method_8738(class_1959.class_1961.field_9357).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8233727).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(132, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.7f).method_8727(0.8f).method_8738(class_1959.class_1961.field_9370).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7972607).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(133, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.25f).method_8727(0.8f).method_8738(class_1959.class_1961.field_9361).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8233983).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(134, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.8f).method_8727(0.9f).method_8738(class_1959.class_1961.field_9364).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(6388580).method_24397(2302743).method_30820(7907327).method_30821(6975545).method_30818(class_4763.class_5486.field_26428).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(140, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9383).method_8747(0.0f).method_8727(0.5f).method_8738(class_1959.class_1961.field_9362).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8364543).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(149, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.95f).method_8727(0.9f).method_8738(class_1959.class_1961.field_9358).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7842047).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(151, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.95f).method_8727(0.8f).method_8738(class_1959.class_1961.field_9358).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7842047).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(155, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.6f).method_8727(0.6f).method_8738(class_1959.class_1961.field_9370).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8037887).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(156, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.6f).method_8727(0.6f).method_8738(class_1959.class_1961.field_9370).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8037887).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(157, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.7f).method_8727(0.8f).method_8738(class_1959.class_1961.field_9370).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7972607).method_30818(class_4763.class_5486.field_26427).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(158, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9383).method_8747(-0.5f).method_8727(0.4f).method_8738(class_1959.class_1961.field_9361).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4020182).method_24397(329011).method_30820(8625919).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(160, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.25f).method_8727(0.8f).method_8738(class_1959.class_1961.field_9361).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8233983).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(161, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.25f).method_8727(0.8f).method_8738(class_1959.class_1961.field_9361).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8233983).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(162, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.2f).method_8727(0.3f).method_8738(class_1959.class_1961.field_9357).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(8233727).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(163, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(1.1f).method_8727(0.0f).method_8738(class_1959.class_1961.field_9356).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7776767).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(164, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(1.0f).method_8727(0.0f).method_8738(class_1959.class_1961.field_9356).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7776511).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(165, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(2.0f).method_8727(0.0f).method_8738(class_1959.class_1961.field_9354).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7254527).method_30821(10387789).method_30822(9470285).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(166, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(2.0f).method_8727(0.0f).method_8738(class_1959.class_1961.field_9354).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7254527).method_30821(10387789).method_30822(9470285).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(167, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(2.0f).method_8727(0.0f).method_8738(class_1959.class_1961.field_9354).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7254527).method_30821(10387789).method_30822(9470285).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(168, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.95f).method_8727(0.9f).method_8738(class_1959.class_1961.field_9358).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7842047).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(169, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9382).method_8747(0.95f).method_8727(0.9f).method_8738(class_1959.class_1961.field_9358).method_24379(new class_4763.class_4764().method_24392(12638463).method_24395(4159204).method_24397(329011).method_30820(7842047).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(170, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(2.0f).method_8727(0.0f).method_8738(class_1959.class_1961.field_9366).method_24379(new class_4763.class_4764().method_24392(1787717).method_24395(4159204).method_24397(329011).method_30820(7254527).method_24393(new class_4761((class_2394)class_2378.field_11141.method_10223(new class_2960("minecraft:ash")), 0.00625f)).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(171, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(2.0f).method_8727(0.0f).method_8738(class_1959.class_1961.field_9366).method_24379(new class_4763.class_4764().method_24392(0x330303).method_24395(4159204).method_24397(329011).method_30820(7254527).method_24393(new class_4761((class_2394)class_2378.field_11141.method_10223(new class_2960("minecraft:crimson_spore")), 0.025f)).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(172, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(2.0f).method_8727(0.0f).method_8738(class_1959.class_1961.field_9366).method_24379(new class_4763.class_4764().method_24392(1705242).method_24395(4159204).method_24397(329011).method_30820(7254527).method_24393(new class_4761((class_2394)class_2378.field_11141.method_10223(new class_2960("minecraft:warped_spore")), 0.01428f)).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
            MAP.put(173, new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8747(2.0f).method_8727(0.0f).method_8738(class_1959.class_1961.field_9366).method_24379(new class_4763.class_4764().method_24392(6840176).method_24395(4159204).method_24397(4341314).method_30820(7254527).method_24393(new class_4761((class_2394)class_2378.field_11141.method_10223(new class_2960("minecraft:white_ash")), 0.118093f)).method_24391()).method_30973(DUMMY_GENERATION_SETTINGS).method_30974(DUMMY_MOB_SPAWN_SETTINGS).method_30972());
        }
    }

    private static interface BiomeMapper {
        public int getId(class_1959 var1);

        public class_1959 getBiome(int var1);
    }
}

