/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.blaze3d.audio;

import com.llamalad7.mixinextras.sugar.Local;
import java.nio.IntBuffer;
import java.util.Objects;
import net.minecraft.class_4225;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.SOFTHRTF;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.settings.VRSettings;

@Mixin(value={class_4225.class})
public class LibraryVRMixin {
    @Shadow
    private long field_18898;

    @Inject(method={"init"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/audio/OpenAlUtil;checkALError(Ljava/lang/String;)Z", ordinal=0, shift=At.Shift.AFTER)})
    private void vivecraft$setHRTF(String string, CallbackInfo ci, @Local ALCCapabilities aLCCapabilities) {
        if (!VRState.VR_RUNNING) {
            return;
        }
        ClientDataHolderVR.getInstance().hrtfList.clear();
        if (aLCCapabilities.ALC_SOFT_HRTF) {
            int hrtfCount = ALC10.alcGetInteger((long)this.field_18898, (int)6548);
            if (hrtfCount > 0) {
                VRSettings.LOGGER.info("Vivecraft: Available HRTFs:");
                for (int i = 0; i < hrtfCount; ++i) {
                    String name = Objects.requireNonNull(SOFTHRTF.alcGetStringiSOFT((long)this.field_18898, (int)6549, (int)i));
                    ClientDataHolderVR.getInstance().hrtfList.add(name);
                    VRSettings.LOGGER.info("Vivecraft: {}: {}", (Object)i, (Object)name);
                }
                int selectedIndex = ClientDataHolderVR.getInstance().vrSettings.hrtfSelection;
                int hrtfEnable = selectedIndex == -1 ? 0 : 1;
                IntBuffer buf = BufferUtils.createIntBuffer((int)10).put(6546).put(hrtfEnable);
                if (selectedIndex != -1) {
                    if (selectedIndex > 0 && selectedIndex <= ClientDataHolderVR.getInstance().hrtfList.size()) {
                        VRSettings.LOGGER.info("Using HRTF: {}", (Object)ClientDataHolderVR.getInstance().hrtfList.get(selectedIndex - 1));
                        buf.put(6550).put(selectedIndex - 1);
                    } else {
                        if (selectedIndex > ClientDataHolderVR.getInstance().hrtfList.size()) {
                            VRSettings.LOGGER.warn("Invalid HRTF index: {}", (Object)selectedIndex);
                        }
                        VRSettings.LOGGER.info("Using default HRTF");
                    }
                } else {
                    VRSettings.LOGGER.info("Disabling HRTF");
                }
                buf.put(0).flip();
                SOFTHRTF.alcResetDeviceSOFT((long)this.field_18898, (IntBuffer)buf);
                if (!this.vivecraft$checkALError("HRTF initialization")) {
                    VRSettings.LOGGER.info("Vivecraft: HRTF initialized.");
                    switch (ALC10.alcGetInteger((long)this.field_18898, (int)6547)) {
                        case 0: {
                            VRSettings.LOGGER.info("Vivecraft: HRTF status: disabled");
                            break;
                        }
                        case 1: {
                            VRSettings.LOGGER.info("Vivecraft: HRTF status: enabled");
                            break;
                        }
                        case 2: {
                            VRSettings.LOGGER.info("Vivecraft: HRTF status: denied");
                            break;
                        }
                        case 3: {
                            VRSettings.LOGGER.info("Vivecraft: HRTF status: required");
                            break;
                        }
                        case 4: {
                            VRSettings.LOGGER.info("Vivecraft: HRTF status: headphones detected");
                            break;
                        }
                        case 5: {
                            VRSettings.LOGGER.info("Vivecraft: HRTF status: unsupported format");
                        }
                    }
                }
            } else {
                VRSettings.LOGGER.warn("Vivecraft: No HRTFs found.");
            }
        } else {
            VRSettings.LOGGER.warn("Vivecraft: ALC_SOFT_HRTF is not supported.");
        }
    }

    @Unique
    private boolean vivecraft$checkALError(String operationState) {
        int error = AL10.alGetError();
        if (error != 0) {
            VRSettings.LOGGER.error("{}: {}", (Object)operationState, (Object)this.vivecraft$alErrorToString(error));
            return true;
        }
        return false;
    }

    @Unique
    private String vivecraft$alErrorToString(int errorCode) {
        return switch (errorCode) {
            case 40961 -> "Invalid name parameter.";
            case 40962 -> "Invalid enumerated parameter value.";
            case 40963 -> "Invalid parameter parameter value.";
            case 40964 -> "Invalid operation.";
            case 40965 -> "Unable to allocate memory.";
            default -> "An unrecognized error occurred.";
        };
    }
}

