/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.screens;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.vivecraft.client.gui.framework.screens.GuiListScreen;
import org.vivecraft.client.gui.framework.widgets.SettingsList;

public class GuiSelectionListScreen<T>
extends GuiListScreen {
    private final Supplier<List<T>> valuesSupplier;
    private final Function<T, class_2561> componentSupplier;
    private final Function<T, String> categorySupplier;
    private final Consumer<T> consumer;
    private final boolean hasReset;
    private final boolean resettable;
    private final Function<T, class_339> widgetSupplier;

    public GuiSelectionListScreen(class_2561 title, class_437 lastScreen, Supplier<List<T>> valuesSupplier, Function<T, class_2561> componentSupplier, @Nullable Function<T, String> categorySupplier, Consumer<T> consumer, boolean hasReset, boolean resettable, @Nullable Function<T, class_339> widgetSupplier) {
        super(title, lastScreen);
        this.valuesSupplier = valuesSupplier;
        this.componentSupplier = componentSupplier;
        this.categorySupplier = categorySupplier != null ? categorySupplier : item -> "";
        this.consumer = consumer;
        this.hasReset = hasReset;
        this.resettable = resettable;
        this.widgetSupplier = widgetSupplier != null ? widgetSupplier : item -> null;
    }

    @Override
    protected void addLowerButtons(int top) {
        if (this.hasReset) {
            this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)(this.resettable ? "controls.reset" : "vivecraft.gui.clear")), p -> {
                this.consumer.accept(null);
                this.method_25419();
            }).method_46434(this.field_22789 / 2 - 155, top, 150, 20).method_46431());
            this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"gui.cancel"), p -> this.method_25419()).method_46434(this.field_22789 / 2 + 5, top, 150, 20).method_46431());
        } else {
            this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"gui.cancel"), p -> this.method_25419()).method_46434(this.field_22789 / 2 - 75, top, 150, 20).method_46431());
        }
    }

    @Override
    protected List<SettingsList.BaseEntry> getEntries() {
        LinkedList<SettingsList.BaseEntry> entries = new LinkedList<SettingsList.BaseEntry>();
        String currentCategory = "";
        SettingsList.GroupedEntry activeCategory = null;
        for (T item : this.valuesSupplier.get()) {
            String newCategory = this.categorySupplier.apply(item);
            if (!currentCategory.equals(newCategory)) {
                currentCategory = newCategory;
                activeCategory = new SettingsList.GroupedEntry((class_2561)class_2561.method_43471((String)newCategory));
                entries.add(activeCategory);
            }
            SettingsList.SelectableEntry entry = new SettingsList.SelectableEntry(this.componentSupplier.apply(item), this.widgetSupplier.apply(item), () -> {
                this.consumer.accept(item);
                this.method_25419();
            });
            if (activeCategory != null) {
                activeCategory.add(entry);
                continue;
            }
            entries.add(entry);
        }
        return entries;
    }
}

