/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.class_1091;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7417;
import net.minecraft.class_746;
import net.minecraft.class_9334;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.ItemInUseTracker;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.data.ViveItemTags;

public class TelescopeTracker
implements ItemInUseTracker {
    public static final class_1091 SCOPE_MODEL = new class_1091(class_2960.method_60655((String)"vivecraft", (String)"item/spyglass_in_hand"), "standalone");
    private static final float LENS_DIST_MAX = 0.05f;
    private static final float LENS_DIST_MIN = 0.185f;
    private static final float LENS_DOT_MAX = 0.9f;
    private static final float LENS_DOT_MIN = 0.75f;
    private final boolean[] viewing = new boolean[2];
    private final class_310 mc;
    private final ClientDataHolderVR dh;

    public TelescopeTracker(class_310 mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    @Override
    public boolean isActive(class_746 player) {
        return player != null && !this.dh.bowTracker.isActive(player) && (TelescopeTracker.isTelescope(player.method_6047()) || TelescopeTracker.isTelescope(player.method_6079()));
    }

    @Override
    public boolean itemInUse(class_746 player) {
        return this.viewing[0] || this.viewing[1];
    }

    @Override
    public void inactiveProcess(class_746 player) {
        this.viewing[0] = false;
        this.viewing[1] = false;
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(class_746 player) {
        for (int c = 0; c < 2; ++c) {
            if (TelescopeTracker.isTelescope(player.method_5998(class_1268.values()[c]))) {
                if (TelescopeTracker.isViewing(c)) {
                    if (!this.viewing[c]) {
                        this.mc.field_1761.method_2919((class_1657)player, class_1268.values()[c]);
                    }
                    this.viewing[c] = true;
                    continue;
                }
                this.viewing[c] = false;
                continue;
            }
            this.viewing[c] = false;
        }
    }

    public static boolean isTelescope(class_1799 itemStack) {
        return itemStack != null && (itemStack.method_31574(class_1802.field_27070) || TelescopeTracker.isLegacyTelescope(itemStack) || itemStack.method_31573(ViveItemTags.VIVECRAFT_TELESCOPE));
    }

    public static boolean isLegacyTelescope(class_1799 itemStack) {
        class_2588 translatableContents;
        class_7417 class_74172;
        if (itemStack.method_7960()) {
            return false;
        }
        if (!itemStack.method_57826(class_9334.field_49631)) {
            return false;
        }
        if (itemStack.method_7909() != class_1802.field_8449) {
            return false;
        }
        if (!itemStack.method_57826(class_9334.field_49630)) {
            return false;
        }
        return itemStack.method_7964().getString().equals("Eye of the Farseer") || (class_74172 = itemStack.method_7964().method_10851()) instanceof class_2588 && (translatableContents = (class_2588)class_74172).method_11022().equals("vivecraft.item.telescope");
    }

    private static Vector3f getLensOrigin(int controller) {
        VRData.VRDevicePose con = ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_pre.getController(controller);
        return con.getPositionF().add((Vector3fc)TelescopeTracker.getViewVector(controller).mul(-0.2f).add((Vector3fc)con.getDirection().mul(0.05f)));
    }

    private static Vector3f getViewVector(int controller) {
        return ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_pre.getController(controller).getCustomVector(MathUtils.DOWN);
    }

    public static boolean isViewing(int controller) {
        return TelescopeTracker.viewPercent(controller) > 0.0f;
    }

    public static float viewPercent(int controller) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && ClientDataHolderVR.getInstance().vrSettings.seated) {
            if (TelescopeTracker.isTelescope(player.method_6030())) {
                return 1.0f;
            }
            return 0.0f;
        }
        float out = 0.0f;
        out = Math.max(out, TelescopeTracker.viewPercent(controller, RenderPass.LEFT));
        out = Math.max(out, TelescopeTracker.viewPercent(controller, RenderPass.RIGHT));
        return out;
    }

    private static float viewPercent(int controller, RenderPass renderPass) {
        if (ClientDataHolderVR.getInstance().vrPlayer == null) {
            return 0.0f;
        }
        VRData.VRDevicePose eyeRoom = ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_pre.getEye(renderPass);
        float dist = eyeRoom.getPositionF().sub((Vector3fc)TelescopeTracker.getLensOrigin(controller)).length();
        Vector3f look = eyeRoom.getDirection();
        float dot = Math.abs(look.dot((Vector3fc)TelescopeTracker.getViewVector(controller)));
        float dfact = 0.0f;
        float distfact = 0.0f;
        if (dot > 0.75f) {
            dfact = dot > 0.9f ? 1.0f : (dot - 0.75f) / 0.14999998f;
        }
        if (dist < 0.185f) {
            distfact = dist < 0.05f ? 1.0f : 1.0f - (dist - 0.05f) / 0.135f;
        }
        return Math.min(dfact, distfact);
    }
}

