/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render;

import net.minecraft.class_1087;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1744;
import net.minecraft.class_1747;
import net.minecraft.class_1758;
import net.minecraft.class_1759;
import net.minecraft.class_1764;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1819;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_2248;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_8810;
import net.minecraft.class_918;
import net.minecraft.class_9362;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.trackers.ClimbTracker;
import org.vivecraft.client_vr.gameplay.trackers.SwingTracker;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.data.ViveItemTags;

public class VivecraftItemRendering {
    private static final ClientDataHolderVR DH = ClientDataHolderVR.getInstance();

    public static VivecraftItemTransformType getTransformType(class_1799 itemStack, class_742 player, class_918 itemRenderer) {
        VivecraftItemTransformType itemTransformType = VivecraftItemTransformType.ITEM;
        class_1792 item = itemStack.method_7909();
        if (itemStack.method_7976() == class_1839.field_8950 || itemStack.method_7976() == class_1839.field_8946) {
            itemTransformType = VivecraftItemTransformType.NOMS;
        } else if (item instanceof class_1747) {
            class_1087 bakedmodel;
            class_2248 block = ((class_1747)item).method_7711();
            itemTransformType = block instanceof class_8810 ? VivecraftItemTransformType.BLOCK_STICK : ((bakedmodel = itemRenderer.method_4019(itemStack, player.method_37908(), (class_1309)player, 0)).method_4712() ? VivecraftItemTransformType.BLOCK_3D : VivecraftItemTransformType.BLOCK_ITEM);
        } else if (item instanceof class_1806 || itemStack.method_31573(ViveItemTags.VIVECRAFT_MAPS)) {
            itemTransformType = VivecraftItemTransformType.MAP;
        } else if (itemStack.method_7976() == class_1839.field_8953 && !itemStack.method_31573(ViveItemTags.VIVECRAFT_BOW_EXCLUSION)) {
            itemTransformType = VivecraftItemTransformType.BOW_SEATED;
            if (VivecraftItemRendering.DH.bowTracker.isActive((class_746)player)) {
                itemTransformType = VivecraftItemRendering.DH.bowTracker.isDrawing() ? VivecraftItemTransformType.BOW_ROOMSCALE_DRAWING : VivecraftItemTransformType.BOW_ROOMSCALE;
            }
        } else if (itemStack.method_7976() == class_1839.field_39058) {
            itemTransformType = VivecraftItemTransformType.HORN;
        } else if (itemStack.method_31573(ViveItemTags.VIVECRAFT_ROTATED_TOOLS)) {
            itemTransformType = VivecraftItemTransformType.ROTATED_TOOL;
        } else if (item instanceof class_9362 || itemStack.method_31573(ViveItemTags.VIVECRAFT_MACES)) {
            itemTransformType = VivecraftItemTransformType.MACE;
        } else if (item instanceof class_1829 || itemStack.method_31573(ViveItemTags.VIVECRAFT_SWORDS)) {
            itemTransformType = VivecraftItemTransformType.SWORD;
        } else if (item instanceof class_1819 || itemStack.method_31573(ViveItemTags.VIVECRAFT_SHIELDS)) {
            itemTransformType = VivecraftItemTransformType.SHIELD;
        } else if (item instanceof class_1835 || itemStack.method_31573(ViveItemTags.VIVECRAFT_SPEARS)) {
            itemTransformType = VivecraftItemTransformType.SPEAR;
        } else if (item instanceof class_1764 || itemStack.method_31573(ViveItemTags.VIVECRAFT_CROSSBOWS)) {
            itemTransformType = VivecraftItemTransformType.CROSSBOW;
        } else if (item instanceof class_1759 || item == class_1802.field_8557 || itemStack.method_31573(ViveItemTags.VIVECRAFT_COMPASSES)) {
            itemTransformType = VivecraftItemTransformType.COMPASS;
        } else if (SwingTracker.isTool(itemStack)) {
            itemTransformType = VivecraftItemTransformType.TOOL;
            if (item instanceof class_1758 || item instanceof class_1787 || itemStack.method_31573(ViveItemTags.VIVECRAFT_FISHING_RODS)) {
                itemTransformType = VivecraftItemTransformType.TOOL_ROD;
            }
        } else if (TelescopeTracker.isTelescope(itemStack)) {
            itemTransformType = VivecraftItemTransformType.TELESCOPE;
        }
        return itemTransformType;
    }

    public static void applyThirdPersonItemTransforms(class_4587 poseStack, VivecraftItemTransformType itemTransformType, boolean mainHand, class_742 player, float equippedProgress, float partialTick, class_1799 itemStack, class_1268 hand) {
        int k = mainHand ? 1 : -1;
        float scale = 0.525f;
        float translateX = 0.0f;
        float translateY = 0.05f;
        float translateZ = 0.0f;
        boolean useLeftHandModelinLeftHand = false;
        if (ClimbTracker.isClaws(itemStack)) {
            scale = 0.4f;
        }
        poseStack.method_46416(translateX, translateY, translateZ);
        poseStack.method_22905(scale, scale, scale);
    }

    public static void applyFirstPersonItemTransforms(class_4587 poseStack, VivecraftItemTransformType itemTransformType, boolean mainHand, class_742 player, float equippedProgress, float partialTick, class_1799 itemStack, class_1268 hand) {
        float gunAngle = VivecraftItemRendering.DH.vr.getGunAngle();
        float scale = 0.7f;
        float translateX = -0.05f;
        float translateY = 0.005f;
        float translateZ = 0.0f;
        Quaternionf rotation = new Quaternionf();
        Quaternionf preRotation = new Quaternionf();
        rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(-110.0f + gunAngle));
        switch (itemTransformType.ordinal()) {
            case 8: {
                rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f - gunAngle));
                translateY += -0.1f;
                translateZ += 0.1f;
                break;
            }
            case 9: {
                preRotation.set((Quaternionfc)rotation);
                rotation.identity();
                translateX -= 0.0225f;
                translateY -= 0.25f;
                translateZ += 0.025f + 0.03f * gunAngle / 40.0f;
                scale = 1.0f;
                break;
            }
            case 10: {
                rotation.identity();
                scale = 1.0f;
                int bowHand = 1;
                if (VivecraftItemRendering.DH.vrSettings.reverseShootingEye && ClientNetworking.supportsReversedBow()) {
                    bowHand = 0;
                }
                Vector3fc aim = VivecraftItemRendering.DH.bowTracker.getAimVector();
                Vector3f forward = VivecraftItemRendering.DH.vrPlayer.vrdata_world_render.getHand(bowHand).getCustomVector(MathUtils.FORWARD);
                if (VivecraftItemRendering.DH.bowTracker.isCharged()) {
                    long j = class_156.method_658() - VivecraftItemRendering.DH.bowTracker.startDrawTime;
                    translateX += 0.003f * class_3532.method_15374((float)j);
                }
                poseStack.method_46416(0.0f, 0.0f, 0.1f);
                poseStack.method_23760().method_23761().mul((Matrix4fc)VivecraftItemRendering.DH.vrPlayer.vrdata_world_render.getController(bowHand).getMatrix().transpose());
                preRotation = new Quaternionf().lookAlong(aim, (Vector3fc)forward).conjugate();
                rotation = class_7833.field_40716.rotationDegrees(180.0f);
                rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(160.0f));
                translateX += 0.125f;
                translateY += 0.1225f;
                translateZ += 0.16f;
                break;
            }
            case 14: {
                rotation = class_7833.field_40716.rotationDegrees(10.0f);
                translateX += 0.01f;
                translateZ -= 0.02f;
                translateY -= 0.02f;
                scale = 0.5f;
                break;
            }
            case 12: {
                rotation = class_7833.field_40714.rotationDegrees(-45.0f);
                translateX = 0.0f;
                translateY = 0.16f;
                translateZ = -0.075f;
                scale = 0.75f;
                break;
            }
            case 13: {
                rotation = class_7833.field_40718.rotationDegrees(180.0f);
                rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(-135.0f));
                translateX += 0.08f;
                translateZ += 0.02f + 0.006f * class_3532.method_15374((float)player.method_6014());
                scale = 0.4f;
                break;
            }
            case 0: 
            case 3: {
                rotation = class_7833.field_40718.rotationDegrees(180.0f);
                rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(-135.0f));
                translateX += 0.08f;
                translateZ += -0.08f;
                scale = 0.4f;
                break;
            }
            case 16: {
                rotation = class_7833.field_40716.rotationDegrees(90.0f);
                rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(25.0f));
                scale = 0.4f;
                break;
            }
            case 1: {
                translateX += 0.05f;
                translateZ -= 0.1f;
                rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f - gunAngle));
                scale = 0.3f;
                break;
            }
            case 2: {
                rotation = class_7833.field_40714.rotationDegrees(-45.0f + gunAngle);
                translateY += -0.105f + 0.06f * gunAngle / 40.0f;
                translateZ -= 0.1f;
                break;
            }
            case 17: {
                rotation = class_7833.field_40714.rotationDegrees(-45.0f + gunAngle);
                translateY += -0.105f + 0.06f * gunAngle / 40.0f;
                translateZ -= 0.1f;
                scale = 0.3f;
                break;
            }
            case 4: {
                int side;
                int n = side = mainHand ? 1 : -1;
                if (VivecraftItemRendering.DH.vrSettings.reverseHands) {
                    side *= -1;
                }
                scale = 0.4f;
                translateY += 0.18f;
                if (side == 1) {
                    rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(105.0f - gunAngle));
                    translateX += 0.11f;
                } else {
                    rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(115.0f - gunAngle));
                    translateX -= 0.015f;
                }
                translateZ += 0.1f;
                if (player.method_6115() && player.method_6014() > 0 && player.method_6058() == hand) {
                    rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees((float)side * 5.0f));
                    rotation.mul((Quaternionfc)class_7833.field_40718.rotationDegrees(-5.0f));
                    if (side == 1) {
                        translateX += 0.04f;
                        translateY -= 0.12f;
                        translateZ -= 0.1f;
                    } else {
                        translateX += 0.19f;
                        translateY -= 0.12f;
                        translateZ -= 0.11f;
                    }
                    if (player.method_6039()) {
                        rotation.mul((Quaternionfc)class_7833.field_40716.rotationDegrees((float)side * 90.0f));
                    } else {
                        rotation.mul((Quaternionfc)class_7833.field_40716.rotationDegrees((1.0f - equippedProgress) * (float)side * 90.0f));
                    }
                }
                rotation.mul((Quaternionfc)class_7833.field_40716.rotationDegrees((float)side * -90.0f));
                break;
            }
            case 11: {
                rotation.identity();
                translateX -= 0.135f;
                translateZ += 0.575f;
                scale = 0.6f;
                float progress = 0.0f;
                boolean charging = false;
                float riptideLevel = 0.0f;
                if (player.method_6115() && player.method_6014() > 0 && player.method_6058() == hand) {
                    charging = true;
                    riptideLevel = class_1890.method_60123((class_1799)itemStack, (class_1309)player);
                    if ((riptideLevel <= 0.0f || player.method_5721()) && (progress = (float)itemStack.method_7935((class_1309)player) - ((float)player.method_6014() - partialTick + 1.0f)) > 10.0f) {
                        float rotationProgress = progress - 10.0f;
                        progress = 10.0f;
                        if (riptideLevel > 0.0f && player.method_5721()) {
                            poseStack.method_22907(class_7833.field_40718.rotationDegrees(-rotationProgress * 10.0f * riptideLevel));
                        }
                        if (VivecraftItemRendering.DH.frameIndex % 4L == 0L) {
                            VivecraftItemRendering.DH.vr.triggerHapticPulse(mainHand ? 0 : 1, 200);
                        }
                        translateX += 0.003f * (float)Math.sin(class_156.method_658());
                    }
                }
                if (player.method_6123()) {
                    riptideLevel = 5.0f;
                    translateZ -= 0.15f;
                    poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)(-VivecraftItemRendering.DH.tickCounter * 10) * riptideLevel % 360.0f - partialTick * 10.0f * riptideLevel));
                    charging = true;
                }
                if (!charging) {
                    translateY += 0.2f * gunAngle / 40.0f;
                    rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(gunAngle));
                }
                rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(-65.0f));
                translateZ += -0.75f + progress / 10.0f * 0.25f;
                break;
            }
            case 7: {
                rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(40.0f));
                translateY += -0.02f + gunAngle / 40.0f * 0.1f;
                translateX += 0.05f;
                translateZ -= 0.15f;
                scale = 0.8f;
                break;
            }
            case 19: {
                rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
                translateY += -0.125f + gunAngle / 40.0f * 0.1f;
                translateZ -= 0.1f;
                break;
            }
            case 6: {
                if (!(itemStack.method_7909() instanceof class_1744) && !itemStack.method_31573(ViveItemTags.VIVECRAFT_ARROWS)) break;
                preRotation = class_7833.field_40718.rotationDegrees(-180.0f);
                rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(-gunAngle));
                break;
            }
            case 15: {
                preRotation.identity();
                rotation.identity();
                translateX = (mainHand ? -0.03f : 0.03f) * (scale *= 0.625f);
                translateY = 0.0f;
                translateZ = -0.1f * scale;
                break;
            }
            case 18: {
                preRotation = class_7833.field_40714.rotationDegrees(gunAngle);
                rotation = rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(-gunAngle));
                translateX = 0.0f;
                translateY = 0.0125f;
                translateZ = -0.06f;
                scale = 0.56f;
                break;
            }
        }
        poseStack.method_22907(preRotation);
        poseStack.method_46416(translateX, translateY, translateZ);
        poseStack.method_22907(rotation);
        poseStack.method_22905(scale, scale, scale);
    }

    public static enum VivecraftItemTransformType {
        ITEM,
        BLOCK_3D,
        BLOCK_STICK,
        BLOCK_ITEM,
        SHIELD,
        SWORD,
        TOOL,
        TOOL_ROD,
        BOW_SEATED,
        BOW_ROOMSCALE,
        BOW_ROOMSCALE_DRAWING,
        SPEAR,
        MAP,
        NOMS,
        CROSSBOW,
        TELESCOPE,
        COMPASS,
        HORN,
        MACE,
        ROTATED_TOOL;

    }
}

