/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.menuworlds;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_10799;
import net.minecraft.class_10889;
import net.minecraft.class_11285;
import net.minecraft.class_11515;
import net.minecraft.class_11531;
import net.minecraft.class_156;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4063;
import net.minecraft.class_4538;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5294;
import net.minecraft.class_5365;
import net.minecraft.class_5636;
import net.minecraft.class_5819;
import net.minecraft.class_6491;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7134;
import net.minecraft.class_7285;
import net.minecraft.class_758;
import net.minecraft.class_776;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import net.minecraft.class_8251;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.class_9848;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.system.MemoryStack;
import org.vivecraft.Xplat;
import org.vivecraft.client.extensions.BufferBuilderExtension;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.StateHolderExtension;
import org.vivecraft.client_vr.menuworlds.FakeBlockAccess;
import org.vivecraft.client_vr.menuworlds.MenuWorldDownloader;
import org.vivecraft.client_vr.menuworlds.MenuWorldExporter;
import org.vivecraft.client_vr.render.rendertypes.VRRenderTypes;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.mod_compat_vr.iris.IrisHelper;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;
import org.vivecraft.mod_compat_vr.sodium.SodiumHelper;

public class MenuWorldRenderer {
    private static final class_2960 MOON_LOCATION = class_2960.method_60656((String)"textures/environment/moon_phases.png");
    private static final class_2960 SUN_LOCATION = class_2960.method_60656((String)"textures/environment/sun.png");
    private static final class_2960 CLOUDS_LOCATION = class_2960.method_60656((String)"textures/environment/clouds.png");
    private static final class_2960 END_SKY_LOCATION = class_2960.method_60656((String)"textures/environment/end_sky.png");
    private static final class_2960 FORCEFIELD_LOCATION = class_2960.method_60656((String)"textures/misc/forcefield.png");
    private static final class_2960 RAIN_LOCATION = class_2960.method_60656((String)"textures/environment/rain.png");
    private static final class_2960 SNOW_LOCATION = class_2960.method_60656((String)"textures/environment/snow.png");
    private final class_310 mc;
    private class_5294 dimensionInfo;
    private FakeBlockAccess blockAccess;
    private final GpuTexture lightMap;
    private final GpuTextureView lightMapView;
    private final class_11285 lightMapUbo;
    private boolean lightmapUpdateNeeded;
    private float blockLightRedFlicker;
    private int waterVisionTime;
    public int ticks = 0;
    public long time = 1000L;
    public boolean fastTime;
    private HashMap<class_11515, List<Pair<Integer, GpuBuffer>>> vertexBuffers;
    private GpuBuffer starVBO;
    private final RenderSystem.class_5590 starIndices = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
    private int starIndexCount;
    private GpuBuffer skyVBO;
    private GpuBuffer sky2VBO;
    private GpuBuffer endSkyVBO;
    private int renderDistance;
    private int renderDistanceChunks;
    public final MenuFogRenderer fogRenderer;
    public Set<class_1058> animatedSprites;
    private final Random rand;
    private boolean ready;
    private int skyFlashTime;
    private float rainLevel;
    private float thunderLevel;
    private float worldRotation;
    private final float[] rainSizeX = new float[1024];
    private final float[] rainSizeZ = new float[1024];
    private CompletableFuture<FakeBlockAccess> getWorldTask;
    public int renderMaxTime = 40;
    public class_2382 segmentSize = new class_2382(64, 64, 64);
    private boolean building = false;
    private boolean reenableShaders = false;
    private long buildStartTime;
    private Map<Pair<class_11515, class_2338>, class_287> bufferBuilders;
    private Map<Pair<class_11515, class_2338>, class_2338.class_2339> currentPositions;
    private Map<Pair<class_11515, class_2338>, Integer> blockCounts;
    private Map<Pair<class_11515, class_2338>, Long> renderTimes;
    private final List<CompletableFuture<Void>> builderFutures = new ArrayList<CompletableFuture<Void>>();
    private final Queue<Thread> builderThreads = new ConcurrentLinkedQueue<Thread>();
    private Throwable builderError;
    private static boolean FIRST_RENDER_DONE;
    private boolean rendering = false;

    public MenuWorldRenderer() {
        this.mc = class_310.method_1551();
        this.lightMap = RenderSystem.getDevice().createTexture("MenuWOrld Light Texture", 12, TextureFormat.RGBA8, 16, 16, 1, 1);
        this.lightMap.setTextureFilter(FilterMode.LINEAR, false);
        this.lightMapView = RenderSystem.getDevice().createTextureView(this.lightMap);
        RenderSystem.getDevice().createCommandEncoder().clearColorTexture(this.lightMap, -1);
        this.lightMapUbo = new class_11285(() -> "Menuworld Lightmap UBO", 130, new Std140SizeCalculator().putFloat().putFloat().putFloat().putInt().putFloat().putFloat().putFloat().putFloat().putVec3().get());
        this.fogRenderer = new MenuFogRenderer(this);
        this.rand = new Random();
        this.rand.nextInt();
    }

    public void init() {
        if (ClientDataHolderVR.getInstance().vrSettings.menuWorldSelection == VRSettings.MenuWorld.NONE) {
            VRSettings.LOGGER.info("Vivecraft: Main menu worlds disabled.");
            return;
        }
        try {
            VRSettings.LOGGER.info("Vivecraft: MenuWorlds: Initializing main menu world renderer...");
            this.loadRenderers();
            this.getWorldTask = CompletableFuture.supplyAsync(() -> {
                FakeBlockAccess fakeBlockAccess;
                block8: {
                    InputStream inputStream = MenuWorldDownloader.getRandomWorld();
                    try {
                        VRSettings.LOGGER.info("Vivecraft: MenuWorlds: Loading world data...");
                        FakeBlockAccess fakeBlockAccess2 = fakeBlockAccess = inputStream != null ? MenuWorldExporter.loadWorld(inputStream) : null;
                        if (inputStream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            VRSettings.LOGGER.error("Vivecraft: Exception thrown when loading main menu world, falling back to old menu room.", (Throwable)e);
                            return null;
                        }
                    }
                    inputStream.close();
                }
                return fakeBlockAccess;
            }, (Executor)class_156.method_18349());
        }
        catch (Exception e) {
            VRSettings.LOGGER.error("Vivecraft: Exception thrown when initializing main menu world renderer, falling back to old menu room.", (Throwable)e);
        }
    }

    public void checkTask() {
        if (this.getWorldTask == null || !this.getWorldTask.isDone()) {
            return;
        }
        try {
            FakeBlockAccess world = this.getWorldTask.get();
            if (world != null) {
                this.setWorld(world);
                this.prepare();
            } else {
                VRSettings.LOGGER.warn("Vivecraft: Failed to load any main menu world, falling back to old menu room");
            }
        }
        catch (Exception e) {
            VRSettings.LOGGER.error("Vivecraft: error starting menuworld building:", (Throwable)e);
        }
        finally {
            this.getWorldTask = null;
        }
    }

    public void render(Matrix4fStack poseStack) {
        this.rendering = true;
        class_5365 current = (class_5365)this.mc.field_1690.method_42534().method_41753();
        if (current == class_5365.field_25429) {
            this.mc.field_1690.method_42534().method_41748((Object)class_5365.field_25428);
        }
        poseStack.pushMatrix();
        poseStack.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(this.worldRotation));
        poseStack.translate(-0.5f, -class_3532.method_22450((float)this.blockAccess.getGround()), -0.5f);
        class_243 offset = new class_243(0.5, (double)(-class_3532.method_22450((float)this.blockAccess.getGround())), 0.5).method_1024(this.worldRotation * ((float)Math.PI / 180));
        class_243 eyePosition = this.getEyePos().method_1019(offset).method_1024(-this.worldRotation * ((float)Math.PI / 180));
        this.fogRenderer.setFog(class_758.class_4596.field_60102);
        this.renderSky(poseStack, eyePosition);
        this.renderChunkLayer(class_11531.field_61022);
        float cloudHeight = this.blockAccess.method_8597().comp_4037().orElse(0).intValue();
        if (OptifineHelper.isOptifineLoaded()) {
            cloudHeight += (float)(OptifineHelper.getCloudHeight() * 128.0);
        }
        if (eyePosition.field_1351 + (double)this.blockAccess.getGround() + (double)this.blockAccess.method_31607() < (double)cloudHeight) {
            this.renderClouds(eyePosition.field_1352, eyePosition.field_1351 + (double)this.blockAccess.getGround() + (double)this.blockAccess.method_31607(), eyePosition.field_1350);
        }
        this.renderChunkLayer(class_11531.field_61023);
        this.renderChunkLayer(class_11531.field_61024);
        if (eyePosition.field_1351 + (double)this.blockAccess.getGround() + (double)this.blockAccess.method_31607() >= (double)cloudHeight) {
            this.renderClouds(eyePosition.field_1352, eyePosition.field_1351 + (double)this.blockAccess.getGround() + (double)this.blockAccess.method_31607(), eyePosition.field_1350);
        }
        this.renderSnowAndRain(eyePosition.field_1352, 0.0, eyePosition.field_1350);
        poseStack.popMatrix();
        this.turnOffLightLayer();
        this.mc.field_1690.method_42534().method_41748((Object)current);
        this.fogRenderer.setFog(class_758.class_4596.field_60101);
        this.rendering = false;
    }

    private void renderChunkLayer(class_11531 group) {
        for (class_11515 layer : group.method_72167()) {
            List<Pair<Integer, GpuBuffer>> buffers = this.vertexBuffers.get(layer);
            if (buffers.isEmpty()) continue;
            GpuBufferSlice gpuBufferSlice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 1.0f);
            for (Pair<Integer, GpuBuffer> buffer : buffers) {
                RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
                GpuBuffer indexBuffer = autoStorageIndexBuffer.method_68274(((Integer)buffer.getLeft()).intValue());
                RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Menuworld: " + layer.method_72022(), this.mc.field_1689.method_71639(), OptionalInt.empty(), this.mc.field_1689.method_71640(), OptionalDouble.empty());
                try {
                    renderPass.setUniform("DynamicTransforms", gpuBufferSlice);
                    RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
                    renderPass.setPipeline(layer.method_72020());
                    renderPass.bindSampler("Sampler2", this.lightMapView);
                    renderPass.bindSampler("Sampler0", layer.method_72024());
                    renderPass.setVertexBuffer(0, (GpuBuffer)buffer.getRight());
                    renderPass.setIndexBuffer(indexBuffer, autoStorageIndexBuffer.method_31924());
                    renderPass.drawIndexed(0, 0, ((Integer)buffer.getLeft()).intValue(), 1);
                }
                finally {
                    if (renderPass == null) continue;
                    renderPass.close();
                }
            }
        }
    }

    public boolean isRendering() {
        return this.rendering;
    }

    public void prepare() {
        if (this.vertexBuffers == null && !this.building) {
            VRSettings.LOGGER.info("Vivecraft: MenuWorlds: Building geometry...");
            if (this.rand.nextInt(1000) == 0) {
                this.blockAccess.setGroundOffset(100.0f);
            }
            this.fastTime = new Random().nextInt(10) == 0;
            this.animatedSprites = ConcurrentHashMap.newKeySet();
            this.blockCounts = new ConcurrentHashMap<Pair<class_11515, class_2338>, Integer>();
            this.renderTimes = new ConcurrentHashMap<Pair<class_11515, class_2338>, Long>();
            if (IrisHelper.isLoaded() && IrisHelper.isShaderActive() && IrisHelper.hasIssuesWithMenuWorld()) {
                VRSettings.LOGGER.info("Vivecraft: Temporarily disabling shaders to build Menuworld.");
                this.reenableShaders = true;
                ClientUtils.addChatMessage((class_2561)class_2561.method_43471((String)"vivecraft.messages.menuworldshaderdisable"));
                IrisHelper.setShadersActive(false);
            }
            try {
                this.vertexBuffers = new HashMap();
                this.bufferBuilders = new HashMap<Pair<class_11515, class_2338>, class_287>();
                this.currentPositions = new HashMap<Pair<class_11515, class_2338>, class_2338.class_2339>();
                for (class_11515 layer : class_11515.values()) {
                    this.vertexBuffers.put(layer, new LinkedList());
                    for (int x = -this.blockAccess.getXSize() / 2; x < this.blockAccess.getXSize() / 2; x += this.segmentSize.method_10263()) {
                        for (int y = (int)(-this.blockAccess.getGround()); y < this.blockAccess.getYSize() - (int)this.blockAccess.getGround(); y += this.segmentSize.method_10264()) {
                            for (int z = -this.blockAccess.getZSize() / 2; z < this.blockAccess.getZSize() / 2; z += this.segmentSize.method_10260()) {
                                class_2338 pos = new class_2338(x, y, z);
                                Pair pair = Pair.of((Object)layer, (Object)pos);
                                boolean wasSkipping = false;
                                if (IrisHelper.isLoaded()) {
                                    wasSkipping = IrisHelper.getSkipBufferExtension();
                                    IrisHelper.setSkipBufferExtension(true);
                                }
                                class_287 vertBuffer = new class_287(new class_9799(32768), VertexFormat.class_5596.field_27382, class_290.field_1590);
                                if (!wasSkipping && IrisHelper.isLoaded()) {
                                    IrisHelper.setSkipBufferExtension(false);
                                }
                                this.bufferBuilders.put((Pair<class_11515, class_2338>)pair, vertBuffer);
                                this.currentPositions.put((Pair<class_11515, class_2338>)pair, pos.method_25503());
                            }
                        }
                    }
                }
            }
            catch (OutOfMemoryError e) {
                VRSettings.LOGGER.error("Vivecraft: OutOfMemoryError while building main menu world. Low system memory or 32-bit Java?", (Throwable)e);
                this.destroy();
                return;
            }
            catch (NullPointerException e) {
                VRSettings.LOGGER.error("Vivecraft: Something canceled menu world building while preparing", (Throwable)e);
                this.destroy();
                return;
            }
            this.buildStartTime = ClientUtils.milliTime();
            this.building = true;
        }
    }

    public boolean isBuilding() {
        return this.building;
    }

    public void buildNext() {
        if (!this.builderFutures.stream().allMatch(CompletableFuture::isDone) || this.builderError != null) {
            return;
        }
        this.builderFutures.clear();
        if (this.currentPositions.entrySet().stream().allMatch(entry -> ((class_2338.class_2339)entry.getValue()).method_10264() >= Math.min(this.segmentSize.method_10264() + ((class_2338)((Pair)entry.getKey()).getRight()).method_10264(), this.blockAccess.getYSize() - (int)this.blockAccess.getGround()))) {
            this.finishBuilding();
            return;
        }
        long startTime = ClientUtils.milliTime();
        for (Pair<class_11515, class_2338> pair : this.bufferBuilders.keySet()) {
            if (this.currentPositions.get(pair).method_10264() >= Math.min(this.segmentSize.method_10264() + ((class_2338)pair.getRight()).method_10264(), this.blockAccess.getYSize() - (int)this.blockAccess.getGround())) continue;
            if (FIRST_RENDER_DONE || !SodiumHelper.isLoaded() || !SodiumHelper.hasIssuesWithParallelBlockBuilding()) {
                this.builderFutures.add(CompletableFuture.runAsync(() -> this.buildGeometry(pair, startTime, this.renderMaxTime), (Executor)class_156.method_18349()));
                continue;
            }
            this.buildGeometry(pair, startTime, this.renderMaxTime);
            if (this.blockCounts.getOrDefault(pair, 0) <= 0) continue;
            FIRST_RENDER_DONE = true;
        }
        CompletableFuture.allOf(this.builderFutures.toArray(new CompletableFuture[0])).thenRunAsync(this::handleError, (Executor)class_156.method_18349());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildGeometry(Pair<class_11515, class_2338> pair, long startTime, int maxTime) {
        if (ClientUtils.milliTime() - startTime >= (long)maxTime) {
            return;
        }
        class_11515 layer = (class_11515)pair.getLeft();
        class_2338 offset = (class_2338)pair.getRight();
        this.builderThreads.add(Thread.currentThread());
        long realStartTime = ClientUtils.milliTime();
        try {
            class_4587 thisPose = new class_4587();
            int renderDistSquare = (this.renderDistance + 1) * (this.renderDistance + 1);
            class_776 blockRenderer = this.mc.method_1541();
            class_287 vertBuffer = this.bufferBuilders.get(pair);
            class_2338.class_2339 pos = this.currentPositions.get(pair);
            class_5819 randomSource = class_5819.method_43047();
            int count = 0;
            while (ClientUtils.milliTime() - startTime < (long)maxTime && pos.method_10264() < Math.min(this.segmentSize.method_10264() + offset.method_10264(), this.blockAccess.getYSize() - (int)this.blockAccess.getGround()) && this.building) {
                class_2680 state;
                if (class_3532.method_15382((int)pos.method_10264()) <= this.renderDistance + 1 && class_3532.method_41189((double)pos.method_10263(), (double)pos.method_10260()) <= (double)renderDistSquare && (state = this.blockAccess.method_8320((class_2338)pos)) != null) {
                    class_3610 fluidState = state.method_26227();
                    if (!fluidState.method_15769() && class_4696.method_23680((class_3610)fluidState) == layer) {
                        for (class_1058 sprite : Xplat.getFluidTextures((class_1920)this.blockAccess, (class_2338)pos, fluidState)) {
                            if (sprite == null || sprite.method_45851().method_45817().sum() <= 1) continue;
                            this.animatedSprites.add(sprite);
                        }
                        blockRenderer.method_3352((class_2338)pos, (class_1920)this.blockAccess, (class_4588)vertBuffer, state, (class_3610)new FluidStateWrapper(fluidState));
                        ++count;
                    }
                    if (state.method_26217() != class_2464.field_11455 && class_4696.method_23679((class_2680)state) == layer) {
                        List parts = this.mc.method_1554().method_4743().method_3335(state).method_68512(randomSource);
                        for (class_10889 modelPart : parts) {
                            for (class_777 quad : modelPart.method_68509(null)) {
                                if (quad.comp_3724().method_45851().method_45817().sum() <= 1) continue;
                                this.animatedSprites.add(quad.comp_3724());
                            }
                        }
                        thisPose.method_22903();
                        thisPose.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
                        blockRenderer.method_3355(state, (class_2338)pos, (class_1920)this.blockAccess, thisPose, (class_4588)vertBuffer, true, parts);
                        ++count;
                        thisPose.method_22909();
                    }
                }
                pos.method_33097(pos.method_10263() + 1);
                if (pos.method_10263() < Math.min(this.segmentSize.method_10263() + offset.method_10263(), this.blockAccess.getXSize() / 2)) continue;
                pos.method_33097(offset.method_10263());
                pos.method_33099(pos.method_10260() + 1);
                if (pos.method_10260() < Math.min(this.segmentSize.method_10260() + offset.method_10260(), this.blockAccess.getZSize() / 2)) continue;
                pos.method_33099(offset.method_10260());
                pos.method_33098(pos.method_10264() + 1);
            }
            this.blockCounts.put(pair, this.blockCounts.getOrDefault(pair, 0) + count);
            this.renderTimes.put(pair, this.renderTimes.getOrDefault(pair, 0L) + (ClientUtils.milliTime() - realStartTime));
            if (pos.method_10264() >= Math.min(this.segmentSize.method_10264() + offset.method_10264(), this.blockAccess.getYSize() - (int)this.blockAccess.getGround())) {
                VRSettings.LOGGER.debug("Vivecraft: MenuWorlds: Built {} blocks on {} layer at {},{},{} in {} ms", new Object[]{this.blockCounts.get(pair), layer.method_72022(), offset.method_10263(), offset.method_10264(), offset.method_10260(), this.renderTimes.get(pair)});
            }
        }
        catch (Throwable e) {
            this.builderError = e;
        }
        finally {
            this.builderThreads.remove(Thread.currentThread());
        }
    }

    private void finishBuilding() {
        this.building = false;
        ArrayList<Map.Entry<Pair<class_11515, class_2338>, class_287>> entryList = new ArrayList<Map.Entry<Pair<class_11515, class_2338>, class_287>>(this.bufferBuilders.entrySet());
        entryList.sort(Comparator.comparing(entry -> (class_2338)((Pair)entry.getKey()).getRight(), (posA, posB) -> {
            class_2382 center = new class_2382(this.segmentSize.method_10263() / 2, this.segmentSize.method_10264() / 2, this.segmentSize.method_10260() / 2);
            double distA = posA.method_10081(center).method_10262((class_2382)class_2338.field_10980);
            double distB = posB.method_10081(center).method_10262((class_2382)class_2338.field_10980);
            return Double.compare(distA, distB);
        }));
        int totalMemory = 0;
        int count = 0;
        try (class_9799 builder = new class_9799(32768);){
            for (Map.Entry<Pair<class_11515, class_2338>, class_287> entry2 : entryList) {
                class_11515 layer = (class_11515)entry2.getKey().getLeft();
                class_287 bufferBuilder = entry2.getValue();
                class_9801 meshData = bufferBuilder.method_60794();
                if (meshData != null) {
                    if (layer.method_72020() == class_10799.field_56895) {
                        meshData.method_60819(builder, class_8251.method_49906((float)0.0f, (float)class_3532.method_22450((float)this.blockAccess.getGround()), (float)0.0f));
                    }
                    this.uploadGeometry(layer, meshData);
                    ++count;
                }
                totalMemory = (int)((long)totalMemory + ((BufferBuilderExtension)bufferBuilder).vivecraft$getBufferSize());
                ((BufferBuilderExtension)bufferBuilder).vivecraft$freeBuffer();
            }
        }
        this.bufferBuilders = null;
        this.currentPositions = null;
        this.ready = true;
        VRSettings.LOGGER.info("Vivecraft: MenuWorlds: Built {} blocks in {} ms ({} ms CPU time)", new Object[]{this.blockCounts.values().stream().reduce(Integer::sum).orElse(0), ClientUtils.milliTime() - this.buildStartTime, this.renderTimes.values().stream().reduce(Long::sum).orElse(0L)});
        VRSettings.LOGGER.info("Vivecraft: MenuWorlds: Used {} temporary buffers ({} MiB), uploaded {} non-empty buffers", new Object[]{entryList.size(), totalMemory / 0x100000, count});
        if (this.reenableShaders) {
            this.reenableShaders = false;
            IrisHelper.setShadersActive(true);
        }
    }

    public boolean isOnBuilderThread() {
        return this.builderThreads.contains(Thread.currentThread());
    }

    private void handleError() {
        if (this.builderError == null) {
            return;
        }
        if (this.builderError instanceof OutOfMemoryError || this.builderError.getCause() instanceof OutOfMemoryError) {
            VRSettings.LOGGER.error("Vivecraft: OutOfMemoryError while building main menu world. Low system memory or 32-bit Java?", this.builderError);
        } else {
            VRSettings.LOGGER.error("Vivecraft: Exception thrown when building main menu world, falling back to old menu room.:", this.builderError);
        }
        this.destroy();
        this.setWorld(null);
        this.builderError = null;
    }

    private void uploadGeometry(class_11515 layer, class_9801 meshData) {
        try (class_9801 class_98012 = meshData;){
            this.vertexBuffers.get(layer).add((Pair<Integer, GpuBuffer>)Pair.of((Object)meshData.method_60822().comp_751(), (Object)RenderSystem.getDevice().createBuffer(null, 40, meshData.method_60818())));
        }
    }

    public void cancelBuilding() {
        this.building = false;
        this.builderFutures.forEach(CompletableFuture::join);
        this.builderFutures.clear();
        if (this.bufferBuilders != null) {
            for (class_287 vertBuffer : this.bufferBuilders.values()) {
                ((BufferBuilderExtension)vertBuffer).vivecraft$freeBuffer();
            }
            this.bufferBuilders = null;
        }
        this.currentPositions = null;
    }

    public void destroy() {
        this.cancelBuilding();
        if (this.vertexBuffers != null) {
            for (List<Pair<Integer, GpuBuffer>> buffers : this.vertexBuffers.values()) {
                for (Pair<Integer, GpuBuffer> buffer : buffers) {
                    if (buffer.getRight() == null) continue;
                    ((GpuBuffer)buffer.getRight()).close();
                }
            }
            this.vertexBuffers = null;
        }
        this.animatedSprites = null;
        this.ready = false;
    }

    public void completeDestroy() {
        this.destroy();
        if (this.starVBO != null) {
            this.starVBO.close();
        }
        if (this.skyVBO != null) {
            this.skyVBO.close();
        }
        if (this.sky2VBO != null) {
            this.sky2VBO.close();
        }
        if (this.endSkyVBO != null) {
            this.endSkyVBO.close();
        }
        this.fogRenderer.close();
        this.lightMap.close();
        this.lightMapView.close();
        this.lightMapUbo.close();
        this.ready = false;
    }

    public void tick() {
        ++this.ticks;
        this.updateTorchFlicker();
        if (this.areEyesInFluid((class_6862<class_3611>)class_3486.field_15517)) {
            int i = 1;
            this.waterVisionTime = class_3532.method_15340((int)(this.waterVisionTime + i), (int)0, (int)600);
        } else if (this.waterVisionTime > 0) {
            this.areEyesInFluid((class_6862<class_3611>)class_3486.field_15517);
            this.waterVisionTime = class_3532.method_15340((int)(this.waterVisionTime - 10), (int)0, (int)600);
        }
        if (SodiumHelper.isLoaded() && this.animatedSprites != null) {
            for (class_1058 sprite : this.animatedSprites) {
                SodiumHelper.markTextureAsActive(sprite);
            }
        }
        if (OptifineHelper.isOptifineLoaded()) {
            for (class_1058 sprite : this.animatedSprites) {
                OptifineHelper.markTextureAsActive(sprite);
            }
        }
    }

    public FakeBlockAccess getLevel() {
        return this.blockAccess;
    }

    public void setWorld(FakeBlockAccess blockAccess) {
        this.blockAccess = blockAccess;
        if (blockAccess != null) {
            this.dimensionInfo = blockAccess.getDimensionReaderInfo();
            this.lightmapUpdateNeeded = true;
            this.renderDistance = blockAccess.getXSize() / 2;
            this.renderDistanceChunks = this.renderDistance / 16;
            this.rainLevel = blockAccess.getRain() ? 1.0f : 0.0f;
            this.thunderLevel = blockAccess.getThunder() ? 1.0f : 0.0f;
            this.worldRotation = blockAccess.getRotation();
        }
    }

    public void loadRenderers() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float g = i - 16;
                float h = class_3532.method_15355((float)(f * f + g * g));
                this.rainSizeX[i << 5 | j] = -g / h;
                this.rainSizeZ[i << 5 | j] = f / h;
            }
        }
        this.generateSky();
        this.generateEndSky();
        this.generateStars();
    }

    public boolean isReady() {
        return this.ready;
    }

    private void copyVisibleTextures() {
    }

    public void pushVisibleTextures() {
    }

    public void renderSky(Matrix4fStack poseStack, class_243 position) {
        if (this.dimensionInfo.method_29992() == class_5294.class_5401.field_25641) {
            this.renderEndSky();
        } else if (this.dimensionInfo.method_29992() == class_5294.class_5401.field_25640) {
            class_243 skyColor = this.getSkyColor(position);
            if (OptifineHelper.isOptifineLoaded()) {
                skyColor = OptifineHelper.getCustomSkyColor(skyColor, (class_1920)this.blockAccess, position.field_1352, position.field_1351, position.field_1350);
            }
            if (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSkyEnabled()) {
                GpuBufferSlice gpuBufferSlice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f((float)skyColor.field_1352, (float)skyColor.field_1351, (float)skyColor.field_1350, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
                try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Menuworld sky", this.mc.method_1522().method_71639(), OptionalInt.empty(), this.mc.method_1522().method_71640(), OptionalDouble.empty());){
                    renderPass.setPipeline(class_10799.field_56874);
                    RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
                    renderPass.setUniform("DynamicTransforms", gpuBufferSlice);
                    renderPass.setVertexBuffer(0, this.skyVBO);
                    renderPass.draw(0, 10);
                }
            }
            int sunriseColor = 0;
            try {
                sunriseColor = this.dimensionInfo.method_62184(this.getTimeOfDay());
            }
            catch (Exception renderPass) {
                // empty catch block
            }
            class_4597.class_4598 bufferSource = this.mc.method_22940().method_23000();
            if (sunriseColor != 0 && this.dimensionInfo.method_62183(this.getTimeOfDay()) && (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSunMoonEnabled())) {
                Matrix4f rotation = new Matrix4f();
                rotation.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
                rotation.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(class_3532.method_15374((float)this.getSunAngle()) < 0.0f ? 180.0f : 0.0f));
                rotation.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(90.0f));
                class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_65220());
                vertexConsumer.method_22918(rotation, 0.0f, 100.0f, 0.0f).method_39415(sunriseColor);
                for (int j = 0; j <= 16; ++j) {
                    float f6 = (float)j * ((float)Math.PI * 2) / 16.0f;
                    float f7 = class_3532.method_15374((float)f6);
                    float f8 = class_3532.method_15362((float)f6);
                    vertexConsumer.method_22918(rotation, f7 * 120.0f, f8 * 120.0f, -f8 * 40.0f * class_9848.method_65100((int)sunriseColor)).method_39415(class_9848.method_61335((int)sunriseColor));
                }
                bufferSource.method_37104();
            }
            poseStack.pushMatrix();
            float skyVisibility = 1.0f - this.getRainLevel();
            poseStack.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-90.0f));
            poseStack.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(this.getTimeOfDay() * 360.0f));
            float size = 30.0f;
            if (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSunMoonEnabled()) {
                int color = class_9848.method_61317((float)skyVisibility);
                class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_65215((class_2960)SUN_LOCATION));
                vertexConsumer.method_22912(-size, 100.0f, -size).method_22913(0.0f, 0.0f).method_39415(color);
                vertexConsumer.method_22912(size, 100.0f, -size).method_22913(1.0f, 0.0f).method_39415(color);
                vertexConsumer.method_22912(size, 100.0f, size).method_22913(1.0f, 1.0f).method_39415(color);
                vertexConsumer.method_22912(-size, 100.0f, size).method_22913(0.0f, 1.0f).method_39415(color);
            }
            size = 20.0f;
            if (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSunMoonEnabled()) {
                int moonPhase = this.getMoonPhase();
                int l = moonPhase % 4;
                int i1 = moonPhase / 4 % 2;
                float u0 = (float)l / 4.0f;
                float v0 = (float)i1 / 2.0f;
                float u1 = (float)(l + 1) / 4.0f;
                float v1 = (float)(i1 + 1) / 2.0f;
                int color = class_9848.method_61317((float)skyVisibility);
                class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_65215((class_2960)MOON_LOCATION));
                vertexConsumer.method_22912(-size, -100.0f, size).method_22913(u0, v1).method_39415(color);
                vertexConsumer.method_22912(size, -100.0f, size).method_22913(u1, v1).method_39415(color);
                vertexConsumer.method_22912(size, -100.0f, -size).method_22913(u1, v0).method_39415(color);
                vertexConsumer.method_22912(-size, -100.0f, -size).method_22913(u0, v0).method_39415(color);
            }
            bufferSource.method_22993();
            float starBrightness = this.getStarBrightness() * skyVisibility;
            if (starBrightness > 0.0f && (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isStarsEnabled())) {
                GpuBufferSlice gpuBufferSlice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)poseStack, (Vector4fc)new Vector4f(starBrightness), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
                GpuBuffer indexBuffer = this.starIndices.method_68274(this.starIndexCount);
                try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Menuworld Stars", this.mc.method_1522().method_71639(), OptionalInt.empty(), this.mc.method_1522().method_71640(), OptionalDouble.empty());){
                    renderPass.setPipeline(class_10799.field_56877);
                    RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
                    renderPass.setUniform("DynamicTransforms", gpuBufferSlice);
                    renderPass.setVertexBuffer(0, this.starVBO);
                    renderPass.setIndexBuffer(indexBuffer, this.starIndices.method_31924());
                    renderPass.drawIndexed(0, 0, this.starIndexCount, 1);
                }
            }
            poseStack.popMatrix();
            double horizonDistance = position.field_1351 - this.blockAccess.getHorizon();
            if (horizonDistance < 0.0) {
                Matrix4fStack stack = RenderSystem.getModelViewStack();
                stack.pushMatrix();
                stack.translate(0.0f, 12.0f, 0.0f);
                GpuBufferSlice gpuBufferSlice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)stack, (Vector4fc)new Vector4f(0.0f, 0.0f, 0.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
                try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Menuworld Dark Kky", this.mc.method_1522().method_71639(), OptionalInt.empty(), this.mc.method_1522().method_71640(), OptionalDouble.empty());){
                    renderPass.setPipeline(class_10799.field_56874);
                    RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
                    renderPass.setUniform("DynamicTransforms", gpuBufferSlice);
                    renderPass.setVertexBuffer(0, this.sky2VBO);
                    renderPass.draw(0, 10);
                }
                stack.popMatrix();
            }
        }
    }

    private void renderEndSky() {
        if (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSkyEnabled()) {
            class_1044 endSkyTexture = this.mc.method_1531().method_4619(END_SKY_LOCATION);
            endSkyTexture.method_70950(false);
            RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
            GpuBuffer indexBuffer = autoStorageIndexBuffer.method_68274(36);
            GpuBufferSlice gpuBufferSlice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
            try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Menuworld Endsky", this.mc.method_1522().method_71639(), OptionalInt.empty(), this.mc.method_1522().method_71640(), OptionalDouble.empty());){
                renderPass.setPipeline(class_10799.field_56875);
                RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
                renderPass.setUniform("DynamicTransforms", gpuBufferSlice);
                renderPass.bindSampler("Sampler0", endSkyTexture.method_71659());
                renderPass.setVertexBuffer(0, this.endSkyVBO);
                renderPass.setIndexBuffer(indexBuffer, autoStorageIndexBuffer.method_31924());
                renderPass.drawIndexed(0, 0, 36, 1);
            }
        }
    }

    public void renderClouds(double x, double y, double z) {
        Optional cloudHeight = this.blockAccess.method_8597().comp_4037();
        if (cloudHeight.isPresent() && this.mc.field_1690.method_1632() != class_4063.field_18162) {
            this.mc.field_1769.method_62196().method_62168(this.getCloudColour(), this.mc.field_1690.method_1632(), (float)((Integer)cloudHeight.get()).intValue() + 0.35f, new class_243(x, y, z), (float)this.ticks + this.mc.method_61966().method_60637(false));
        }
    }

    private void renderSnowAndRain(double inX, double inY, double inZ) {
        if (this.getRainLevel() <= 0.0f) {
            return;
        }
        int xFloor = class_3532.method_15357((double)inX);
        int yFloor = class_3532.method_15357((double)inY);
        int zFloor = class_3532.method_15357((double)inZ);
        int rainDistance = 5;
        if (class_310.method_1517()) {
            rainDistance = 10;
        }
        float rainAnimationTime = (float)this.ticks + ClientUtils.getCurrentPartialTick();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_4597.class_4598 bufferSource = this.mc.method_22940().method_23000();
        for (int rainZ = zFloor - rainDistance; rainZ <= zFloor + rainDistance; ++rainZ) {
            for (int rainX = xFloor - rainDistance; rainX <= xFloor + rainDistance; ++rainX) {
                float blend;
                class_4588 vertexConsumer;
                int upper;
                int blockingHeight;
                int lower;
                int q = (rainZ - zFloor + 16) * 32 + rainX - xFloor + 16;
                double r = (double)this.rainSizeX[q] * 0.5;
                double s = (double)this.rainSizeZ[q] * 0.5;
                mutableBlockPos.method_10102((double)rainX, inY, (double)rainZ);
                class_1959 biome = (class_1959)this.blockAccess.method_23753((class_2338)mutableBlockPos).comp_349();
                if (!biome.method_48163() || (lower = Math.max(yFloor - rainDistance, blockingHeight = this.blockAccess.getHeightBlocking(rainX, rainZ))) == (upper = Math.max(yFloor + rainDistance, blockingHeight))) continue;
                int rainY = Math.max(blockingHeight, yFloor);
                class_5819 randomSource = class_5819.method_43049((long)((long)(rainX * rainX) * 3121L + (long)rainX * 45238971L ^ (long)(rainZ * rainZ) * 418711L + (long)rainZ * 13761L));
                mutableBlockPos.method_33098(lower);
                class_1959.class_1963 precipitation = biome.method_48162((class_2338)mutableBlockPos, this.blockAccess.method_8615());
                if (precipitation == class_1959.class_1963.field_9384) continue;
                mutableBlockPos.method_33098(rainY);
                double localX = (double)rainX + 0.5;
                double localZ = (double)rainZ + 0.5;
                float distance = (float)Math.sqrt(localX * localX + localZ * localZ) / (float)rainDistance;
                float xOffset = 0.0f;
                float yOffset = 0.0f;
                int skyLight = this.blockAccess.method_8314(class_1944.field_9284, (class_2338)mutableBlockPos) << 4;
                int blockLight = this.blockAccess.method_8314(class_1944.field_9282, (class_2338)mutableBlockPos) << 4;
                if (precipitation == class_1959.class_1963.field_9382) {
                    vertexConsumer = bufferSource.getBuffer(VRRenderTypes.weatherNoLightmapChange(RAIN_LOCATION));
                    blend = (1.0f - distance * distance) * 0.5f + 0.5f;
                    int x = this.ticks + rainX * rainX * 3121 + rainX * 45238971 + rainZ * rainZ * 418711 + rainZ * 13761 & 0x1F;
                    yOffset = -((float)x + ClientUtils.getCurrentPartialTick()) / 32.0f * (3.0f + randomSource.method_43057());
                } else {
                    if (precipitation != class_1959.class_1963.field_9383) continue;
                    vertexConsumer = bufferSource.getBuffer(VRRenderTypes.weatherNoLightmapChange(SNOW_LOCATION));
                    blend = (1.0f - distance * distance) * 0.3f + 0.5f;
                    xOffset = (float)(randomSource.method_43058() + (double)rainAnimationTime * 0.01 * (double)((float)randomSource.method_43059()));
                    float ae = -((float)(this.ticks & 0x1FF) + ClientUtils.getCurrentPartialTick()) / 512.0f;
                    float af = (float)(randomSource.method_43058() + (double)(rainAnimationTime * (float)randomSource.method_43059()) * 0.001);
                    yOffset = ae + af;
                    skyLight = (skyLight * 3 + 240) / 4;
                    blockLight = (blockLight * 3 + 240) / 4;
                }
                vertexConsumer.method_22912((float)(localX - r), (float)upper - (float)inY, (float)(localZ - s)).method_22913(0.0f + xOffset, (float)lower * 0.25f + yOffset).method_22915(1.0f, 1.0f, 1.0f, blend).method_22921(blockLight, skyLight);
                vertexConsumer.method_22912((float)(localX + r), (float)upper - (float)inY, (float)(localZ + s)).method_22913(1.0f + xOffset, (float)lower * 0.25f + yOffset).method_22915(1.0f, 1.0f, 1.0f, blend).method_22921(blockLight, skyLight);
                vertexConsumer.method_22912((float)(localX + r), (float)lower - (float)inY, (float)(localZ + s)).method_22913(1.0f + xOffset, (float)upper * 0.25f + yOffset).method_22915(1.0f, 1.0f, 1.0f, blend).method_22921(blockLight, skyLight);
                vertexConsumer.method_22912((float)(localX - r), (float)lower - (float)inY, (float)(localZ - s)).method_22913(0.0f + xOffset, (float)upper * 0.25f + yOffset).method_22915(1.0f, 1.0f, 1.0f, blend).method_22921(blockLight, skyLight);
            }
        }
        this.turnOnLightLayer();
        bufferSource.method_22993();
        this.turnOffLightLayer();
    }

    public static int getLightColor(class_1920 blockAndTintGetter, class_2338 blockPos) {
        int i = blockAndTintGetter.method_8314(class_1944.field_9284, blockPos);
        int j = blockAndTintGetter.method_8314(class_1944.field_9282, blockPos);
        return i << 20 | j << 4;
    }

    public float getTimeOfDay() {
        return this.blockAccess.method_8597().method_28528(this.time);
    }

    public float getSunAngle() {
        float dayTime = this.getTimeOfDay();
        return dayTime * ((float)Math.PI * 2);
    }

    public int getMoonPhase() {
        return this.blockAccess.method_8597().method_28531(this.time);
    }

    public float getSkyDarken() {
        float dayTime = this.getTimeOfDay();
        float h = 1.0f - (class_3532.method_15362((float)(dayTime * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        h = class_3532.method_15363((float)h, (float)0.0f, (float)1.0f);
        h = 1.0f - h;
        h *= 1.0f - this.getRainLevel() * 5.0f / 16.0f;
        return (h *= 1.0f - this.getThunderLevel() * 5.0f / 16.0f) * 0.8f + 0.2f;
    }

    public float getRainLevel() {
        return this.rainLevel;
    }

    public float getThunderLevel() {
        return this.thunderLevel * this.getRainLevel();
    }

    public float getStarBrightness() {
        float f = this.getTimeOfDay();
        float f1 = 1.0f - (class_3532.method_15362((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        f1 = class_3532.method_15363((float)f1, (float)0.0f, (float)1.0f);
        return f1 * f1 * 0.5f;
    }

    public class_243 getSkyColor(class_243 position) {
        float f;
        float darkening;
        float luminance;
        float dayTime = this.getTimeOfDay();
        class_243 samplePosition = position.method_1023(2.0, 2.0, 2.0).method_1021(0.25);
        class_243 skyColor = class_6491.method_24895((class_243)samplePosition, (i, j, k) -> class_243.method_24457((int)((class_1959)this.blockAccess.method_22385().method_24854(i, j, k).comp_349()).method_8697()));
        float h = class_3532.method_15362((float)(dayTime * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        h = class_3532.method_15363((float)h, (float)0.0f, (float)1.0f);
        float skyColorR = (float)skyColor.field_1352 * h;
        float skyColorG = (float)skyColor.field_1351 * h;
        float skyColorB = (float)skyColor.field_1350 * h;
        float rain = this.getRainLevel();
        if (rain > 0.0f) {
            luminance = (skyColorR * 0.3f + skyColorG * 0.59f + skyColorB * 0.11f) * 0.6f;
            darkening = 1.0f - rain * 0.75f;
            skyColorR = skyColorR * darkening + luminance * (1.0f - darkening);
            skyColorG = skyColorG * darkening + luminance * (1.0f - darkening);
            skyColorB = skyColorB * darkening + luminance * (1.0f - darkening);
        }
        float thunder = this.getThunderLevel();
        if (f > 0.0f) {
            luminance = (skyColorR * 0.3f + skyColorG * 0.59f + skyColorB * 0.11f) * 0.2f;
            darkening = 1.0f - thunder * 0.75f;
            skyColorR = skyColorR * darkening + luminance * (1.0f - darkening);
            skyColorG = skyColorG * darkening + luminance * (1.0f - darkening);
            skyColorB = skyColorB * darkening + luminance * (1.0f - darkening);
        }
        if (!((Boolean)this.mc.field_1690.method_41784().method_41753()).booleanValue() && this.skyFlashTime > 0) {
            float flash = (float)this.skyFlashTime - ClientUtils.getCurrentPartialTick();
            if (flash > 1.0f) {
                flash = 1.0f;
            }
            skyColorR = skyColorR * (1.0f - (flash *= 0.45f)) + 0.8f * flash;
            skyColorG = skyColorG * (1.0f - flash) + 0.8f * flash;
            skyColorB = skyColorB * (1.0f - flash) + flash;
        }
        return new class_243((double)skyColorR, (double)skyColorG, (double)skyColorB);
    }

    public class_243 getFogColor(class_243 pos) {
        float f = class_3532.method_15363((float)(class_3532.method_15362((float)(this.getTimeOfDay() * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        class_243 scaledPos = pos.method_1023(2.0, 2.0, 2.0).method_1021(0.25);
        return class_6491.method_24895((class_243)scaledPos, (x, y, z) -> this.dimensionInfo.method_28112(class_243.method_24457((int)((class_1959)this.blockAccess.method_22385().method_24854(x, y, z).comp_349()).method_24376()), f));
    }

    public int getCloudColour() {
        int color = -1;
        float rain = this.getRainLevel();
        if (rain > 0.0f) {
            int j = class_9848.method_61321((int)class_9848.method_61333((int)color), (float)0.6f);
            color = class_9848.method_61319((float)(rain * 0.95f), (int)color, (int)j);
        }
        float dayTime = this.getTimeOfDay();
        float k = class_3532.method_15362((float)(dayTime * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        k = class_3532.method_15363((float)k, (float)0.0f, (float)1.0f);
        color = class_9848.method_61322((int)color, (int)class_9848.method_61318((float)1.0f, (float)(k * 0.9f + 0.1f), (float)(k * 0.9f + 0.1f), (float)(k * 0.85f + 0.15f)));
        float thunder = this.getThunderLevel();
        if (thunder > 0.0f) {
            int greyColor = class_9848.method_61321((int)class_9848.method_61333((int)color), (float)0.2f);
            color = class_9848.method_61319((float)(thunder * 0.95f), (int)color, (int)greyColor);
        }
        return color;
    }

    private void generateSky() {
        if (this.skyVBO != null) {
            this.skyVBO.close();
        }
        if (this.sky2VBO != null) {
            this.sky2VBO.close();
        }
        try (class_9799 byteBufferBuilder = new class_9799(10 * class_290.field_1592.getVertexSize());){
            class_287 bufferBuilder = new class_287(byteBufferBuilder, VertexFormat.class_5596.field_27381, class_290.field_1592);
            MenuWorldRenderer.buildSkyDisc((class_4588)bufferBuilder, 16.0f);
            try (class_9801 meshData = bufferBuilder.method_60800();){
                this.skyVBO = RenderSystem.getDevice().createBuffer(() -> "Top sky vertex buffer", 40, meshData.method_60818());
            }
            bufferBuilder = new class_287(byteBufferBuilder, VertexFormat.class_5596.field_27381, class_290.field_1592);
            MenuWorldRenderer.buildSkyDisc((class_4588)bufferBuilder, -16.0f);
            meshData = bufferBuilder.method_60800();
            try {
                this.sky2VBO = RenderSystem.getDevice().createBuffer(() -> "Bottom sky vertex buffer", 40, meshData.method_60818());
            }
            finally {
                if (meshData != null) {
                    meshData.close();
                }
            }
        }
    }

    private void generateEndSky() {
        if (this.endSkyVBO != null) {
            this.endSkyVBO.close();
        }
        try (class_9799 byteBufferBuilder = new class_9799(24 * class_290.field_1575.getVertexSize());){
            class_287 bufferBuilder = new class_287(byteBufferBuilder, VertexFormat.class_5596.field_27382, class_290.field_1575);
            for (int i = 0; i < 6; ++i) {
                Matrix4f matrix = new Matrix4f();
                switch (i) {
                    case 1: {
                        matrix.rotationX(1.5707964f);
                        break;
                    }
                    case 2: {
                        matrix.rotationX(-1.5707964f);
                        break;
                    }
                    case 3: {
                        matrix.rotationX((float)Math.PI);
                        break;
                    }
                    case 4: {
                        matrix.rotationZ(1.5707964f);
                        break;
                    }
                    case 5: {
                        matrix.rotationZ(-1.5707964f);
                    }
                }
                int r = 40;
                int g = 40;
                int b = 40;
                if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isCustomColors()) {
                    class_243 newSkyColor = new class_243((double)r / 255.0, (double)g / 255.0, (double)b / 255.0);
                    newSkyColor = OptifineHelper.getCustomSkyColorEnd(newSkyColor);
                    r = (int)(newSkyColor.field_1352 * 255.0);
                    g = (int)(newSkyColor.field_1351 * 255.0);
                    b = (int)(newSkyColor.field_1350 * 255.0);
                }
                bufferBuilder.method_22918(matrix, -100.0f, -100.0f, -100.0f).method_22913(0.0f, 0.0f).method_1336(r, g, b, 255);
                bufferBuilder.method_22918(matrix, -100.0f, -100.0f, 100.0f).method_22913(0.0f, 16.0f).method_1336(r, g, b, 255);
                bufferBuilder.method_22918(matrix, 100.0f, -100.0f, 100.0f).method_22913(16.0f, 16.0f).method_1336(r, g, b, 255);
                bufferBuilder.method_22918(matrix, 100.0f, -100.0f, -100.0f).method_22913(16.0f, 0.0f).method_1336(r, g, b, 255);
            }
            try (class_9801 meshData = bufferBuilder.method_60800();){
                this.endSkyVBO = RenderSystem.getDevice().createBuffer(() -> "End sky vertex buffer", 40, meshData.method_60818());
            }
        }
    }

    private static void buildSkyDisc(class_4588 vertexConsumer, float posY) {
        float g = Math.signum(posY) * 512.0f;
        vertexConsumer.method_22912(0.0f, posY, 0.0f);
        for (int i = -180; i <= 180; i += 45) {
            vertexConsumer.method_22912(g * class_3532.method_15362((float)((float)i * ((float)Math.PI / 180))), posY, 512.0f * class_3532.method_15374((float)((float)i * ((float)Math.PI / 180))));
        }
    }

    private void generateStars() {
        if (this.starVBO != null) {
            this.starVBO.close();
        }
        this.starVBO = this.buildStars();
    }

    private GpuBuffer buildStars() {
        class_5819 randomSource = class_5819.method_43049((long)10842L);
        int starCount = 1500;
        float starDistance = 100.0f;
        try (class_9799 byteBufferBuilder = new class_9799(class_290.field_1592.getVertexSize() * starCount * 4);){
            GpuBuffer gpuBuffer;
            block12: {
                class_287 bufferBuilder = new class_287(byteBufferBuilder, VertexFormat.class_5596.field_27382, class_290.field_1592);
                for (int i = 0; i < starCount; ++i) {
                    Vector3f starPoint = new Vector3f(randomSource.method_43057(), randomSource.method_43057(), randomSource.method_43057()).mul(2.0f).sub(1.0f, 1.0f, 1.0f);
                    float starSize = 0.15f + randomSource.method_43057() * 0.1f;
                    float distance = starPoint.lengthSquared();
                    if (distance <= 0.010000001f || distance >= 1.0f) continue;
                    starPoint.normalize(starDistance);
                    float starRotation = (float)(randomSource.method_43058() * Math.PI * 2.0);
                    Matrix3f rotation = new Matrix3f().rotateTowards((Vector3fc)starPoint.negate(new Vector3f()), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)).rotateZ(-starRotation);
                    bufferBuilder.method_60830(new Vector3f(starSize, -starSize, 0.0f).mul((Matrix3fc)rotation).add((Vector3fc)starPoint));
                    bufferBuilder.method_60830(new Vector3f(starSize, starSize, 0.0f).mul((Matrix3fc)rotation).add((Vector3fc)starPoint));
                    bufferBuilder.method_60830(new Vector3f(-starSize, starSize, 0.0f).mul((Matrix3fc)rotation).add((Vector3fc)starPoint));
                    bufferBuilder.method_60830(new Vector3f(-starSize, -starSize, 0.0f).mul((Matrix3fc)rotation).add((Vector3fc)starPoint));
                }
                class_9801 meshData = bufferBuilder.method_60800();
                try {
                    this.starIndexCount = meshData.method_60822().comp_751();
                    gpuBuffer = RenderSystem.getDevice().createBuffer(() -> "Stars vertex buffer", 40, meshData.method_60818());
                    if (meshData == null) break block12;
                }
                catch (Throwable throwable) {
                    if (meshData != null) {
                        try {
                            meshData.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                meshData.close();
            }
            return gpuBuffer;
        }
    }

    public void turnOffLightLayer() {
        RenderSystem.setShaderTexture((int)2, null);
    }

    public void turnOnLightLayer() {
        RenderSystem.setShaderTexture((int)2, (GpuTextureView)this.lightMapView);
    }

    public void updateTorchFlicker() {
        this.blockLightRedFlicker += (float)((Math.random() - Math.random()) * Math.random() * Math.random() * 0.1);
        this.blockLightRedFlicker *= 0.9f;
        this.lightmapUpdateNeeded = true;
    }

    public void updateLightmap() {
        if (this.lightmapUpdateNeeded) {
            float skyLight = this.getSkyDarken();
            float effectiveSkyLight = this.skyFlashTime > 0 ? 1.0f : skyLight * 0.95f + 0.05f;
            float waterVision = this.getWaterVision();
            float nightVision = 0.0f;
            Vector3f skylightColor = new Vector3f(skyLight, skyLight, 1.0f).lerp((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
            RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
            try (GpuBuffer.MappedView buffer = RenderSystem.getDevice().createCommandEncoder().mapBuffer(this.lightMapUbo.method_71119(), false, true);){
                Std140Builder.intoBuffer((ByteBuffer)buffer.data()).putFloat(this.blockAccess.method_8597().comp_656()).putFloat(effectiveSkyLight).putFloat(this.blockLightRedFlicker + 1.5f).putInt(this.dimensionInfo.method_28114() ? 1 : 0).putFloat(nightVision).putFloat(0.0f).putFloat(0.0f).putFloat(Math.max(0.0f, ((Double)this.mc.field_1690.method_42473().method_41753()).floatValue())).putVec3((Vector3fc)skylightColor);
            }
            try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Menuworld Lightmap", this.lightMapView, OptionalInt.empty());){
                renderPass.setPipeline(class_10799.field_56844);
                RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
                renderPass.setUniform("LightmapInfo", this.lightMapUbo.method_71119());
                renderPass.setVertexBuffer(0, RenderSystem.getQuadVertexBuffer());
                renderPass.setIndexBuffer(autoStorageIndexBuffer.method_68274(6), autoStorageIndexBuffer.method_31924());
                renderPass.drawIndexed(0, 0, 6, 1);
            }
            this.lightMapUbo.method_71121();
            this.lightmapUpdateNeeded = false;
        }
    }

    private float notGamma(float f) {
        float g = 1.0f - f;
        return 1.0f - g * g * g * g;
    }

    public float getWaterVision() {
        if (!this.areEyesInFluid((class_6862<class_3611>)class_3486.field_15517)) {
            return 0.0f;
        }
        if ((float)this.waterVisionTime >= 600.0f) {
            return 1.0f;
        }
        float f2 = class_3532.method_15363((float)((float)this.waterVisionTime / 100.0f), (float)0.0f, (float)1.0f);
        float f3 = (float)this.waterVisionTime < 100.0f ? 0.0f : class_3532.method_15363((float)(((float)this.waterVisionTime - 100.0f) / 500.0f), (float)0.0f, (float)1.0f);
        return f2 * 0.6f + f3 * 0.39999998f;
    }

    public boolean areEyesInFluid(class_6862<class_3611> tagIn) {
        if (this.blockAccess == null) {
            return false;
        }
        class_243 pos = this.getEyePos();
        class_2338 blockpos = class_2338.method_49638((class_2374)pos);
        class_3610 fluidstate = this.blockAccess.method_8316(blockpos);
        return this.isFluidTagged(fluidstate, tagIn) && pos.field_1351 < (double)((float)blockpos.method_10264() + (float)fluidstate.method_15761() + 0.11111111f);
    }

    public class_243 getEyePos() {
        return ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_post.hmd.getPosition();
    }

    private boolean isFluidTagged(class_3611 fluid, class_6862<class_3611> tag) {
        if (tag == class_3486.field_15517) {
            return fluid == class_3612.field_15910 || fluid == class_3612.field_15909;
        }
        if (tag == class_3486.field_15518) {
            return fluid == class_3612.field_15908 || fluid == class_3612.field_15907;
        }
        return false;
    }

    private boolean isFluidTagged(class_3610 fluidState, class_6862<class_3611> tag) {
        return this.isFluidTagged(fluidState.method_15772(), tag);
    }

    public static class MenuFogRenderer {
        public Vector4f fogColor = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        private int targetBiomeFog;
        private int previousBiomeFog;
        private long biomeChangedTime;
        private final MenuWorldRenderer menuWorldRenderer;
        private final GpuBuffer emptyBuffer;
        private final class_11285 fogBuffer;

        public MenuFogRenderer(MenuWorldRenderer menuWorldRenderer) {
            this.menuWorldRenderer = menuWorldRenderer;
            this.fogBuffer = new class_11285(() -> "Menuworld Fog UBO", 130, class_758.field_60096);
            try (MemoryStack memoryStack = MemoryStack.stackPush();){
                ByteBuffer byteBuffer = memoryStack.malloc(class_758.field_60096);
                Std140Builder.intoBuffer((ByteBuffer)byteBuffer).putVec4((Vector4fc)new Vector4f(0.0f)).putFloat(Float.MAX_VALUE).putFloat(Float.MAX_VALUE).putFloat(Float.MAX_VALUE).putFloat(Float.MAX_VALUE).putFloat(Float.MAX_VALUE).putFloat(Float.MAX_VALUE);
                this.emptyBuffer = RenderSystem.getDevice().createBuffer(() -> "Menuworld Empty fog", 128, byteBuffer.flip());
            }
        }

        public void close() {
            this.emptyBuffer.close();
            this.fogBuffer.close();
        }

        public void setupFogColor() {
            class_243 eyePos = this.menuWorldRenderer.getEyePos();
            class_5636 fogType = this.getEyeFogType();
            if (fogType == class_5636.field_27886) {
                this.updateWaterFog(this.menuWorldRenderer.getLevel());
            } else if (fogType == class_5636.field_27885) {
                this.fogColor.x = 0.6f;
                this.fogColor.y = 0.1f;
                this.fogColor.z = 0.0f;
                this.biomeChangedTime = -1L;
            } else if (fogType == class_5636.field_27887) {
                this.fogColor.x = 0.623f;
                this.fogColor.y = 0.734f;
                this.fogColor.z = 0.785f;
                this.biomeChangedTime = -1L;
            } else {
                this.updateSurfaceFog();
                this.biomeChangedTime = -1L;
            }
            float d0 = (float)((eyePos.field_1351 + (double)this.menuWorldRenderer.getLevel().getGround()) * this.menuWorldRenderer.getLevel().getVoidFogYFactor());
            if ((double)d0 < 1.0 && fogType != class_5636.field_27885 && fogType != class_5636.field_27887) {
                if (d0 < 0.0f) {
                    d0 = 0.0f;
                }
                d0 *= d0;
                this.fogColor.x *= d0;
                this.fogColor.y *= d0;
                this.fogColor.z *= d0;
            }
            if (fogType == class_5636.field_27886 && this.fogColor.x != 0.0f && this.fogColor.y != 0.0f && this.fogColor.z != 0.0f) {
                float f1 = this.menuWorldRenderer.getWaterVision();
                float f3 = Math.min(1.0f / this.fogColor.x, Math.min(1.0f / this.fogColor.y, 1.0f / this.fogColor.z));
                this.fogColor.x = this.fogColor.x * (1.0f - f1) + this.fogColor.x * f3 * f1;
                this.fogColor.y = this.fogColor.y * (1.0f - f1) + this.fogColor.y * f3 * f1;
                this.fogColor.z = this.fogColor.z * (1.0f - f1) + this.fogColor.z * f3 * f1;
            }
            if (OptifineHelper.isOptifineLoaded()) {
                class_243 colUnderlava;
                if (fogType == class_5636.field_27886) {
                    class_243 colUnderwater = OptifineHelper.getCustomUnderwaterColor((class_1920)this.menuWorldRenderer.blockAccess, eyePos.field_1352, eyePos.field_1351, eyePos.field_1350);
                    if (colUnderwater != null) {
                        this.fogColor.x = (float)colUnderwater.field_1352;
                        this.fogColor.y = (float)colUnderwater.field_1351;
                        this.fogColor.z = (float)colUnderwater.field_1350;
                    }
                } else if (fogType == class_5636.field_27885 && (colUnderlava = OptifineHelper.getCustomUnderlavaColor((class_1920)this.menuWorldRenderer.blockAccess, eyePos.field_1352, eyePos.field_1351, eyePos.field_1350)) != null) {
                    this.fogColor.x = (float)colUnderlava.field_1352;
                    this.fogColor.y = (float)colUnderlava.field_1351;
                    this.fogColor.z = (float)colUnderlava.field_1350;
                }
            }
        }

        private void updateSurfaceFog() {
            float f7;
            float f = 0.25f + 0.75f * (float)this.menuWorldRenderer.renderDistanceChunks / 32.0f;
            f = 1.0f - (float)Math.pow(f, 0.25);
            class_243 eyePos = this.menuWorldRenderer.getEyePos();
            class_243 skyColor = this.menuWorldRenderer.getSkyColor(eyePos);
            if (OptifineHelper.isOptifineLoaded()) {
                if (this.menuWorldRenderer.blockAccess.method_8597().comp_655().equals((Object)class_7134.field_37670)) {
                    skyColor = OptifineHelper.getCustomSkyColor(skyColor, (class_1920)this.menuWorldRenderer.blockAccess, eyePos.field_1352, eyePos.field_1351, eyePos.field_1350);
                } else if (this.menuWorldRenderer.blockAccess.method_8597().comp_655().equals((Object)class_7134.field_37672)) {
                    skyColor = OptifineHelper.getCustomSkyColorEnd(skyColor);
                }
            }
            float skyRed = (float)skyColor.field_1352;
            float skyGreen = (float)skyColor.field_1351;
            float skyBlue = (float)skyColor.field_1350;
            class_243 fogColor = this.menuWorldRenderer.getFogColor(eyePos);
            if (OptifineHelper.isOptifineLoaded()) {
                if (this.menuWorldRenderer.blockAccess.method_8597().comp_655().equals((Object)class_7134.field_37670)) {
                    fogColor = OptifineHelper.getCustomFogColor(fogColor, (class_1920)this.menuWorldRenderer.blockAccess, eyePos.field_1352, eyePos.field_1351, eyePos.field_1350);
                } else if (this.menuWorldRenderer.blockAccess.method_8597().comp_655().equals((Object)class_7134.field_37672)) {
                    fogColor = OptifineHelper.getCustomFogColorEnd(fogColor);
                } else if (this.menuWorldRenderer.blockAccess.method_8597().comp_655().equals((Object)class_7134.field_37671)) {
                    fogColor = OptifineHelper.getCustomFogColorNether(fogColor);
                }
            }
            this.fogColor.x = (float)fogColor.field_1352;
            this.fogColor.y = (float)fogColor.field_1351;
            this.fogColor.z = (float)fogColor.field_1350;
            if (this.menuWorldRenderer.renderDistanceChunks >= 4) {
                float d0 = class_3532.method_15374((float)this.menuWorldRenderer.getSunAngle()) > 0.0f ? -1.0f : 1.0f;
                float f5 = ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_post.hmd.getDirection().rotateY(-this.menuWorldRenderer.worldRotation * ((float)Math.PI / 180)).dot(d0, 0.0f, 0.0f);
                if (f5 < 0.0f) {
                    f5 = 0.0f;
                }
                if (f5 > 0.0f && this.menuWorldRenderer.dimensionInfo.method_62183(this.menuWorldRenderer.getTimeOfDay())) {
                    int sunriseColor = 0;
                    try {
                        sunriseColor = this.menuWorldRenderer.dimensionInfo.method_62184(this.menuWorldRenderer.getTimeOfDay());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (sunriseColor != 0) {
                        this.fogColor.x = this.fogColor.x * (1.0f - (f5 *= class_9848.method_65100((int)sunriseColor))) + class_9848.method_65101((int)sunriseColor) * f5;
                        this.fogColor.y = this.fogColor.y * (1.0f - f5) + class_9848.method_65102((int)sunriseColor) * f5;
                        this.fogColor.z = this.fogColor.z * (1.0f - f5) + class_9848.method_65103((int)sunriseColor) * f5;
                    }
                }
            }
            this.fogColor.x += (skyRed - this.fogColor.x) * f;
            this.fogColor.y += (skyGreen - this.fogColor.y) * f;
            this.fogColor.z += (skyBlue - this.fogColor.z) * f;
            float f6 = this.menuWorldRenderer.getRainLevel();
            if (f6 > 0.0f) {
                float f4 = 1.0f - f6 * 0.5f;
                float f8 = 1.0f - f6 * 0.4f;
                this.fogColor.x *= f4;
                this.fogColor.y *= f4;
                this.fogColor.z *= f8;
            }
            if ((f7 = this.menuWorldRenderer.getThunderLevel()) > 0.0f) {
                float f9 = 1.0f - f7 * 0.5f;
                this.fogColor.x *= f9;
                this.fogColor.y *= f9;
                this.fogColor.z *= f9;
            }
            this.biomeChangedTime = -1L;
        }

        private void updateWaterFog(class_4538 levelIn) {
            long currentTime = class_156.method_658();
            int waterFogColor = ((class_1959)levelIn.method_23753(class_2338.method_49638((class_2374)this.menuWorldRenderer.getEyePos())).comp_349()).method_8713();
            if (this.biomeChangedTime < 0L) {
                this.targetBiomeFog = waterFogColor;
                this.previousBiomeFog = waterFogColor;
                this.biomeChangedTime = currentTime;
            }
            int k = this.targetBiomeFog >> 16 & 0xFF;
            int l = this.targetBiomeFog >> 8 & 0xFF;
            int i1 = this.targetBiomeFog & 0xFF;
            int j1 = this.previousBiomeFog >> 16 & 0xFF;
            int k1 = this.previousBiomeFog >> 8 & 0xFF;
            int l1 = this.previousBiomeFog & 0xFF;
            float f = class_3532.method_15363((float)((float)(currentTime - this.biomeChangedTime) / 5000.0f), (float)0.0f, (float)1.0f);
            float f1 = class_3532.method_16439((float)f, (float)j1, (float)k);
            float f2 = class_3532.method_16439((float)f, (float)k1, (float)l);
            float f3 = class_3532.method_16439((float)f, (float)l1, (float)i1);
            this.fogColor.x = f1 / 255.0f;
            this.fogColor.y = f2 / 255.0f;
            this.fogColor.z = f3 / 255.0f;
            if (this.targetBiomeFog != waterFogColor) {
                this.targetBiomeFog = waterFogColor;
                this.previousBiomeFog = class_3532.method_15375((float)f1) << 16 | class_3532.method_15375((float)f2) << 8 | class_3532.method_15375((float)f3);
                this.biomeChangedTime = currentTime;
            }
        }

        public void updateFog() {
            class_5636 fogType = this.getEyeFogType();
            class_7285 fogData = new class_7285();
            if (fogType == class_5636.field_27885) {
                fogData.field_60582 = 0.25f;
                fogData.field_60584 = 1.0f;
            } else if (fogType == class_5636.field_27887) {
                fogData.field_60582 = 0.0f;
                fogData.field_60584 = 2.0f;
            } else if (fogType == class_5636.field_27886) {
                fogData.field_60582 = -8.0f;
                fogData.field_60584 = 96.0f;
                class_6880 holder = this.menuWorldRenderer.blockAccess.method_23753(class_2338.method_49638((class_2374)this.menuWorldRenderer.getEyePos()));
                if (holder.method_40220(class_6908.field_37378)) {
                    fogData.field_60584 *= 0.85f;
                }
            } else if (this.menuWorldRenderer.blockAccess.getDimensionReaderInfo().method_28110(0, 0)) {
                fogData.field_60582 = (float)this.menuWorldRenderer.renderDistance * 0.05f;
                fogData.field_60584 = Math.min((float)this.menuWorldRenderer.renderDistance, 192.0f) * 0.5f;
            } else if (fogType == class_5636.field_60563) {
                class_2338 center = class_2338.method_49637((double)0.0, (double)0.0, (double)0.0);
                class_1959 biome = (class_1959)this.menuWorldRenderer.blockAccess.method_23753(center).comp_349();
                float lightAmount = class_3532.method_15363((float)(((float)this.menuWorldRenderer.blockAccess.method_8314(class_1944.field_9284, center) - 8.0f) / 7.0f), (float)0.0f, (float)1.0f);
                float fog = this.menuWorldRenderer.rainLevel * lightAmount * (biome.method_48163() ? 1.0f : 0.5f);
                fogData.field_60582 = fog * -160.0f;
                fogData.field_60584 = 1024.0f - 256.0f * fog;
                fogData.field_60099 = this.menuWorldRenderer.renderDistance;
                fogData.field_60100 = (Integer)class_310.method_1551().field_1690.method_71270().method_41753() * 16;
            }
            if (fogType != class_5636.field_60563) {
                fogData.field_60099 = fogData.field_60584;
                fogData.field_60100 = fogData.field_60584;
            }
            float h = class_3532.method_15363((float)((float)this.menuWorldRenderer.renderDistance / 10.0f), (float)4.0f, (float)64.0f);
            fogData.field_60583 = (float)this.menuWorldRenderer.renderDistance - h;
            fogData.field_60585 = this.menuWorldRenderer.renderDistance;
            try (GpuBuffer.MappedView mappedView = RenderSystem.getDevice().createCommandEncoder().mapBuffer(this.fogBuffer.method_71119(), false, true);){
                mappedView.data().position(0);
                Std140Builder.intoBuffer((ByteBuffer)mappedView.data()).putVec4((Vector4fc)this.fogColor).putFloat(fogData.field_60582).putFloat(fogData.field_60584).putFloat(fogData.field_60583).putFloat(fogData.field_60585).putFloat(fogData.field_60099).putFloat(fogData.field_60100);
            }
        }

        private class_5636 getEyeFogType() {
            class_5636 fogType = class_5636.field_60563;
            if (this.menuWorldRenderer.areEyesInFluid((class_6862<class_3611>)class_3486.field_15517)) {
                fogType = class_5636.field_27886;
            } else if (this.menuWorldRenderer.areEyesInFluid((class_6862<class_3611>)class_3486.field_15518)) {
                fogType = class_5636.field_27885;
            } else if (this.menuWorldRenderer.blockAccess.method_8320(class_2338.method_49638((class_2374)this.menuWorldRenderer.getEyePos())).method_27852(class_2246.field_27879)) {
                fogType = class_5636.field_27887;
            }
            return fogType;
        }

        public GpuBufferSlice getBuffer(class_758.class_4596 fogMode) {
            return switch (fogMode) {
                default -> throw new MatchException(null, null);
                case class_758.class_4596.field_60101 -> this.emptyBuffer.slice(0, class_758.field_60096);
                case class_758.class_4596.field_60102 -> this.fogBuffer.method_71119().slice(0, class_758.field_60096);
            };
        }

        public void setFog(class_758.class_4596 fogMode) {
            RenderSystem.setShaderFog((GpuBufferSlice)this.getBuffer(fogMode));
        }
    }

    private static class FluidStateWrapper
    extends class_3610 {
        private final class_3610 fluidState;

        public FluidStateWrapper(class_3610 fluidState) {
            super(fluidState.method_15772(), null, fluidState.field_24740);
            ((StateHolderExtension)((Object)this)).vivecraft$setValues(fluidState.method_11656());
            this.fluidState = fluidState;
        }

        public boolean method_15767(class_6862<class_3611> tagIn) {
            if (tagIn == class_3486.field_15517) {
                return this.method_15772() == class_3612.field_15910 || this.method_15772() == class_3612.field_15909;
            }
            if (tagIn == class_3486.field_15518) {
                return this.method_15772() == class_3612.field_15908 || this.method_15772() == class_3612.field_15907;
            }
            return this.fluidState.method_15767(tagIn);
        }
    }
}

