/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.menuworlds;

import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CompiledShaderProgram;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ARGB;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.Xplat;
import org.vivecraft.client.extensions.BufferBuilderExtension;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.StateHolderExtension;
import org.vivecraft.client_vr.menuworlds.FakeBlockAccess;
import org.vivecraft.client_vr.menuworlds.MenuWorldDownloader;
import org.vivecraft.client_vr.menuworlds.MenuWorldExporter;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.mixin.client.renderer.RenderStateShardAccessor;
import org.vivecraft.mod_compat_vr.iris.IrisHelper;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;
import org.vivecraft.mod_compat_vr.sodium.SodiumHelper;

public class MenuWorldRenderer {
    private static final ResourceLocation MOON_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/environment/moon_phases.png");
    private static final ResourceLocation SUN_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/environment/sun.png");
    private static final ResourceLocation CLOUDS_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/environment/clouds.png");
    private static final ResourceLocation END_SKY_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/environment/end_sky.png");
    private static final ResourceLocation FORCEFIELD_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/misc/forcefield.png");
    private static final ResourceLocation RAIN_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/environment/rain.png");
    private static final ResourceLocation SNOW_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/environment/snow.png");
    private final Minecraft mc;
    private DimensionSpecialEffects dimensionInfo;
    private FakeBlockAccess blockAccess;
    private final TextureTarget lightMap;
    private boolean lightmapUpdateNeeded;
    private float blockLightRedFlicker;
    private int waterVisionTime;
    public int ticks = 0;
    public long time = 1000L;
    public boolean fastTime;
    private HashMap<RenderType, List<VertexBuffer>> vertexBuffers;
    private VertexBuffer starVBO;
    private VertexBuffer skyVBO;
    private VertexBuffer sky2VBO;
    private VertexBuffer endSkyVBO;
    private int renderDistance;
    private int renderDistanceChunks;
    public final MenuFogRenderer fogRenderer;
    public Set<TextureAtlasSprite> animatedSprites;
    private final Random rand;
    private boolean ready;
    private int skyFlashTime;
    private float rainLevel;
    private float thunderLevel;
    private float worldRotation;
    private final float[] rainSizeX = new float[1024];
    private final float[] rainSizeZ = new float[1024];
    private CompletableFuture<FakeBlockAccess> getWorldTask;
    public int renderMaxTime = 40;
    public Vec3i segmentSize = new Vec3i(64, 64, 64);
    private boolean building = false;
    private boolean reenableShaders = false;
    private long buildStartTime;
    private Map<Pair<RenderType, BlockPos>, BufferBuilder> bufferBuilders;
    private Map<Pair<RenderType, BlockPos>, BlockPos.MutableBlockPos> currentPositions;
    private Map<Pair<RenderType, BlockPos>, Integer> blockCounts;
    private Map<Pair<RenderType, BlockPos>, Long> renderTimes;
    private final List<CompletableFuture<Void>> builderFutures = new ArrayList<CompletableFuture<Void>>();
    private final Queue<Thread> builderThreads = new ConcurrentLinkedQueue<Thread>();
    private Throwable builderError;
    private static boolean FIRST_RENDER_DONE;
    private boolean rendering = false;

    public MenuWorldRenderer() {
        this.mc = Minecraft.getInstance();
        this.lightMap = new TextureTarget(16, 16, false);
        this.lightMap.setFilterMode(9729);
        this.lightMap.setClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.lightMap.clear();
        this.fogRenderer = new MenuFogRenderer(this);
        this.rand = new Random();
        this.rand.nextInt();
    }

    public void init() {
        if (ClientDataHolderVR.getInstance().vrSettings.menuWorldSelection == VRSettings.MenuWorld.NONE) {
            VRSettings.LOGGER.info("Vivecraft: Main menu worlds disabled.");
            return;
        }
        try {
            VRSettings.LOGGER.info("Vivecraft: MenuWorlds: Initializing main menu world renderer...");
            this.loadRenderers();
            this.getWorldTask = CompletableFuture.supplyAsync(() -> {
                FakeBlockAccess fakeBlockAccess;
                block8: {
                    InputStream inputStream = MenuWorldDownloader.getRandomWorld();
                    try {
                        VRSettings.LOGGER.info("Vivecraft: MenuWorlds: Loading world data...");
                        FakeBlockAccess fakeBlockAccess2 = fakeBlockAccess = inputStream != null ? MenuWorldExporter.loadWorld(inputStream) : null;
                        if (inputStream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            VRSettings.LOGGER.error("Vivecraft: Exception thrown when loading main menu world, falling back to old menu room.", (Throwable)e);
                            return null;
                        }
                    }
                    inputStream.close();
                }
                return fakeBlockAccess;
            }, (Executor)Util.backgroundExecutor());
        }
        catch (Exception e) {
            VRSettings.LOGGER.error("Vivecraft: Exception thrown when initializing main menu world renderer, falling back to old menu room.", (Throwable)e);
        }
    }

    public void checkTask() {
        if (this.getWorldTask == null || !this.getWorldTask.isDone()) {
            return;
        }
        try {
            FakeBlockAccess world = this.getWorldTask.get();
            if (world != null) {
                this.setWorld(world);
                this.prepare();
            } else {
                VRSettings.LOGGER.warn("Vivecraft: Failed to load any main menu world, falling back to old menu room");
            }
        }
        catch (Exception e) {
            VRSettings.LOGGER.error("Vivecraft: error starting menuworld building:", (Throwable)e);
        }
        finally {
            this.getWorldTask = null;
        }
    }

    public void render(Matrix4fStack poseStack) {
        this.rendering = true;
        GraphicsStatus current = (GraphicsStatus)this.mc.options.graphicsMode().get();
        if (current == GraphicsStatus.FABULOUS) {
            this.mc.options.graphicsMode().set((Object)GraphicsStatus.FANCY);
        }
        this.turnOnLightLayer();
        poseStack.pushMatrix();
        poseStack.rotate((Quaternionfc)Axis.YP.rotationDegrees(this.worldRotation));
        poseStack.translate(-0.5f, -Mth.frac((float)this.blockAccess.getGround()), -0.5f);
        Vec3 offset = new Vec3(0.5, (double)(-Mth.frac((float)this.blockAccess.getGround())), 0.5).yRot(this.worldRotation * ((float)Math.PI / 180));
        Vec3 eyePosition = this.getEyePos().add(offset).yRot(-this.worldRotation * ((float)Math.PI / 180));
        this.fogRenderer.setupFog(FogRenderer.FogMode.FOG_SKY);
        this.renderSky(poseStack, eyePosition);
        this.fogRenderer.setupFog(FogRenderer.FogMode.FOG_TERRAIN);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Matrix4f projection = RenderSystem.getProjectionMatrix();
        RenderSystem.disableBlend();
        this.renderChunkLayer(RenderType.solid(), (Matrix4f)poseStack, projection);
        this.renderChunkLayer(RenderType.cutoutMipped(), (Matrix4f)poseStack, projection);
        this.renderChunkLayer(RenderType.cutout(), (Matrix4f)poseStack, projection);
        RenderSystem.enableBlend();
        float cloudHeight = this.dimensionInfo.getCloudHeight();
        if (OptifineHelper.isOptifineLoaded()) {
            cloudHeight += (float)(OptifineHelper.getCloudHeight() * 128.0);
        }
        if (eyePosition.y + (double)this.blockAccess.getGround() + (double)this.blockAccess.getMinY() < (double)cloudHeight) {
            this.renderClouds(poseStack, eyePosition.x, eyePosition.y + (double)this.blockAccess.getGround() + (double)this.blockAccess.getMinY(), eyePosition.z);
        }
        this.renderChunkLayer(RenderType.translucent(), (Matrix4f)poseStack, projection);
        this.renderChunkLayer(RenderType.tripwire(), (Matrix4f)poseStack, projection);
        if (eyePosition.y + (double)this.blockAccess.getGround() + (double)this.blockAccess.getMinY() >= (double)cloudHeight) {
            this.renderClouds(poseStack, eyePosition.x, eyePosition.y + (double)this.blockAccess.getGround() + (double)this.blockAccess.getMinY(), eyePosition.z);
        }
        RenderSystem.depthMask((boolean)false);
        this.renderSnowAndRain(poseStack, eyePosition.x, 0.0, eyePosition.z);
        RenderSystem.depthMask((boolean)true);
        poseStack.popMatrix();
        this.turnOffLightLayer();
        this.mc.options.graphicsMode().set((Object)current);
        this.rendering = false;
    }

    private void renderChunkLayer(RenderType layer, Matrix4f modelView, Matrix4f Projection) {
        List<VertexBuffer> buffers = this.vertexBuffers.get(layer);
        if (buffers.isEmpty()) {
            return;
        }
        layer.setupRenderState();
        CompiledShaderProgram shaderInstance = RenderSystem.getShader();
        shaderInstance.apply();
        this.turnOnLightLayer();
        for (VertexBuffer vertexBuffer : buffers) {
            vertexBuffer.bind();
            vertexBuffer.drawWithShader(modelView, Projection, shaderInstance);
        }
        this.turnOffLightLayer();
    }

    public boolean isRendering() {
        return this.rendering;
    }

    public void prepare() {
        if (this.vertexBuffers == null && !this.building) {
            VRSettings.LOGGER.info("Vivecraft: MenuWorlds: Building geometry...");
            if (this.rand.nextInt(1000) == 0) {
                this.blockAccess.setGroundOffset(100.0f);
            }
            this.fastTime = new Random().nextInt(10) == 0;
            this.animatedSprites = ConcurrentHashMap.newKeySet();
            this.blockCounts = new ConcurrentHashMap<Pair<RenderType, BlockPos>, Integer>();
            this.renderTimes = new ConcurrentHashMap<Pair<RenderType, BlockPos>, Long>();
            if (IrisHelper.isLoaded() && IrisHelper.isShaderActive() && IrisHelper.hasIssuesWithMenuWorld()) {
                VRSettings.LOGGER.info("Vivecraft: Temporarily disabling shaders to build Menuworld.");
                this.reenableShaders = true;
                ClientUtils.addChatMessage((Component)Component.translatable((String)"vivecraft.messages.menuworldshaderdisable"));
                IrisHelper.setShadersActive(false);
            }
            try {
                this.vertexBuffers = new HashMap();
                this.bufferBuilders = new HashMap<Pair<RenderType, BlockPos>, BufferBuilder>();
                this.currentPositions = new HashMap<Pair<RenderType, BlockPos>, BlockPos.MutableBlockPos>();
                for (RenderType layer : RenderType.chunkBufferLayers()) {
                    this.vertexBuffers.put(layer, new LinkedList());
                    for (int x = -this.blockAccess.getXSize() / 2; x < this.blockAccess.getXSize() / 2; x += this.segmentSize.getX()) {
                        for (int y = (int)(-this.blockAccess.getGround()); y < this.blockAccess.getYSize() - (int)this.blockAccess.getGround(); y += this.segmentSize.getY()) {
                            for (int z = -this.blockAccess.getZSize() / 2; z < this.blockAccess.getZSize() / 2; z += this.segmentSize.getZ()) {
                                BlockPos pos = new BlockPos(x, y, z);
                                Pair pair = Pair.of((Object)layer, (Object)pos);
                                BufferBuilder vertBuffer = new BufferBuilder(new ByteBufferBuilder(32768), VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
                                this.bufferBuilders.put((Pair<RenderType, BlockPos>)pair, vertBuffer);
                                this.currentPositions.put((Pair<RenderType, BlockPos>)pair, pos.mutable());
                            }
                        }
                    }
                }
            }
            catch (OutOfMemoryError e) {
                VRSettings.LOGGER.error("Vivecraft: OutOfMemoryError while building main menu world. Low system memory or 32-bit Java?", (Throwable)e);
                this.destroy();
                return;
            }
            catch (NullPointerException e) {
                VRSettings.LOGGER.error("Vivecraft: Something canceled menu world building while preparing", (Throwable)e);
                this.destroy();
                return;
            }
            this.buildStartTime = ClientUtils.milliTime();
            this.building = true;
        }
    }

    public boolean isBuilding() {
        return this.building;
    }

    public void buildNext() {
        if (!this.builderFutures.stream().allMatch(CompletableFuture::isDone) || this.builderError != null) {
            return;
        }
        this.builderFutures.clear();
        if (this.currentPositions.entrySet().stream().allMatch(entry -> ((BlockPos.MutableBlockPos)entry.getValue()).getY() >= Math.min(this.segmentSize.getY() + ((BlockPos)((Pair)entry.getKey()).getRight()).getY(), this.blockAccess.getYSize() - (int)this.blockAccess.getGround()))) {
            this.finishBuilding();
            return;
        }
        long startTime = ClientUtils.milliTime();
        for (Pair<RenderType, BlockPos> pair : this.bufferBuilders.keySet()) {
            if (this.currentPositions.get(pair).getY() >= Math.min(this.segmentSize.getY() + ((BlockPos)pair.getRight()).getY(), this.blockAccess.getYSize() - (int)this.blockAccess.getGround())) continue;
            if (FIRST_RENDER_DONE || !SodiumHelper.isLoaded() || !SodiumHelper.hasIssuesWithParallelBlockBuilding()) {
                this.builderFutures.add(CompletableFuture.runAsync(() -> this.buildGeometry(pair, startTime, this.renderMaxTime), (Executor)Util.backgroundExecutor()));
                continue;
            }
            this.buildGeometry(pair, startTime, this.renderMaxTime);
            if (this.blockCounts.getOrDefault(pair, 0) <= 0) continue;
            FIRST_RENDER_DONE = true;
        }
        CompletableFuture.allOf(this.builderFutures.toArray(new CompletableFuture[0])).thenRunAsync(this::handleError, (Executor)Util.backgroundExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildGeometry(Pair<RenderType, BlockPos> pair, long startTime, int maxTime) {
        if (ClientUtils.milliTime() - startTime >= (long)maxTime) {
            return;
        }
        RenderType layer = (RenderType)pair.getLeft();
        BlockPos offset = (BlockPos)pair.getRight();
        this.builderThreads.add(Thread.currentThread());
        long realStartTime = ClientUtils.milliTime();
        try {
            PoseStack thisPose = new PoseStack();
            int renderDistSquare = (this.renderDistance + 1) * (this.renderDistance + 1);
            BlockRenderDispatcher blockRenderer = this.mc.getBlockRenderer();
            BufferBuilder vertBuffer = this.bufferBuilders.get(pair);
            BlockPos.MutableBlockPos pos = this.currentPositions.get(pair);
            RandomSource randomSource = RandomSource.create();
            int count = 0;
            while (ClientUtils.milliTime() - startTime < (long)maxTime && pos.getY() < Math.min(this.segmentSize.getY() + offset.getY(), this.blockAccess.getYSize() - (int)this.blockAccess.getGround()) && this.building) {
                BlockState state;
                if (Mth.abs((int)pos.getY()) <= this.renderDistance + 1 && Mth.lengthSquared((double)pos.getX(), (double)pos.getZ()) <= (double)renderDistSquare && (state = this.blockAccess.getBlockState((BlockPos)pos)) != null) {
                    FluidState fluidState = state.getFluidState();
                    if (!fluidState.isEmpty() && ItemBlockRenderTypes.getRenderLayer((FluidState)fluidState) == layer) {
                        for (TextureAtlasSprite sprite : Xplat.getFluidTextures((BlockAndTintGetter)this.blockAccess, (BlockPos)pos, fluidState)) {
                            if (sprite == null || sprite.contents().getUniqueFrames().sum() <= 1) continue;
                            this.animatedSprites.add(sprite);
                        }
                        blockRenderer.renderLiquid((BlockPos)pos, (BlockAndTintGetter)this.blockAccess, (VertexConsumer)vertBuffer, state, (FluidState)new FluidStateWrapper(fluidState));
                        ++count;
                    }
                    if (state.getRenderShape() != RenderShape.INVISIBLE && ItemBlockRenderTypes.getChunkRenderType((BlockState)state) == layer) {
                        for (BakedQuad quad : this.mc.getModelManager().getBlockModelShaper().getBlockModel(state).getQuads(state, null, randomSource)) {
                            if (quad.getSprite().contents().getUniqueFrames().sum() <= 1) continue;
                            this.animatedSprites.add(quad.getSprite());
                        }
                        thisPose.pushPose();
                        thisPose.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
                        blockRenderer.renderBatched(state, (BlockPos)pos, (BlockAndTintGetter)this.blockAccess, thisPose, (VertexConsumer)vertBuffer, true, randomSource);
                        ++count;
                        thisPose.popPose();
                    }
                }
                pos.setX(pos.getX() + 1);
                if (pos.getX() < Math.min(this.segmentSize.getX() + offset.getX(), this.blockAccess.getXSize() / 2)) continue;
                pos.setX(offset.getX());
                pos.setZ(pos.getZ() + 1);
                if (pos.getZ() < Math.min(this.segmentSize.getZ() + offset.getZ(), this.blockAccess.getZSize() / 2)) continue;
                pos.setZ(offset.getZ());
                pos.setY(pos.getY() + 1);
            }
            this.blockCounts.put(pair, this.blockCounts.getOrDefault(pair, 0) + count);
            this.renderTimes.put(pair, this.renderTimes.getOrDefault(pair, 0L) + (ClientUtils.milliTime() - realStartTime));
            if (pos.getY() >= Math.min(this.segmentSize.getY() + offset.getY(), this.blockAccess.getYSize() - (int)this.blockAccess.getGround())) {
                VRSettings.LOGGER.debug("Vivecraft: MenuWorlds: Built {} blocks on {} layer at {},{},{} in {} ms", new Object[]{this.blockCounts.get(pair), ((RenderStateShardAccessor)layer).getName(), offset.getX(), offset.getY(), offset.getZ(), this.renderTimes.get(pair)});
            }
        }
        catch (Throwable e) {
            this.builderError = e;
        }
        finally {
            this.builderThreads.remove(Thread.currentThread());
        }
    }

    private void finishBuilding() {
        this.building = false;
        ArrayList<Map.Entry<Pair<RenderType, BlockPos>, BufferBuilder>> entryList = new ArrayList<Map.Entry<Pair<RenderType, BlockPos>, BufferBuilder>>(this.bufferBuilders.entrySet());
        entryList.sort(Comparator.comparing(entry -> (BlockPos)((Pair)entry.getKey()).getRight(), (posA, posB) -> {
            Vec3i center = new Vec3i(this.segmentSize.getX() / 2, this.segmentSize.getY() / 2, this.segmentSize.getZ() / 2);
            double distA = posA.offset(center).distSqr((Vec3i)BlockPos.ZERO);
            double distB = posB.offset(center).distSqr((Vec3i)BlockPos.ZERO);
            return Double.compare(distA, distB);
        }));
        int totalMemory = 0;
        int count = 0;
        try (ByteBufferBuilder builder = new ByteBufferBuilder(32768);){
            for (Map.Entry<Pair<RenderType, BlockPos>, BufferBuilder> entry2 : entryList) {
                RenderType layer = (RenderType)entry2.getKey().getLeft();
                BufferBuilder bufferBuilder = entry2.getValue();
                MeshData meshData = bufferBuilder.build();
                if (meshData != null) {
                    if (layer == RenderType.translucent()) {
                        meshData.sortQuads(builder, VertexSorting.byDistance((float)0.0f, (float)Mth.frac((float)this.blockAccess.getGround()), (float)0.0f));
                    }
                    this.uploadGeometry(layer, meshData);
                    ++count;
                }
                totalMemory += ((BufferBuilderExtension)bufferBuilder).vivecraft$getBufferSize();
                ((BufferBuilderExtension)bufferBuilder).vivecraft$freeBuffer();
            }
        }
        this.bufferBuilders = null;
        this.currentPositions = null;
        this.ready = true;
        VRSettings.LOGGER.info("Vivecraft: MenuWorlds: Built {} blocks in {} ms ({} ms CPU time)", new Object[]{this.blockCounts.values().stream().reduce(Integer::sum).orElse(0), ClientUtils.milliTime() - this.buildStartTime, this.renderTimes.values().stream().reduce(Long::sum).orElse(0L)});
        VRSettings.LOGGER.info("Vivecraft: MenuWorlds: Used {} temporary buffers ({} MiB), uploaded {} non-empty buffers", new Object[]{entryList.size(), totalMemory / 0x100000, count});
        if (this.reenableShaders) {
            this.reenableShaders = false;
            IrisHelper.setShadersActive(true);
        }
    }

    public boolean isOnBuilderThread() {
        return this.builderThreads.contains(Thread.currentThread());
    }

    private void handleError() {
        if (this.builderError == null) {
            return;
        }
        if (this.builderError instanceof OutOfMemoryError || this.builderError.getCause() instanceof OutOfMemoryError) {
            VRSettings.LOGGER.error("Vivecraft: OutOfMemoryError while building main menu world. Low system memory or 32-bit Java?", this.builderError);
        } else {
            VRSettings.LOGGER.error("Vivecraft: Exception thrown when building main menu world, falling back to old menu room.:", this.builderError);
        }
        this.destroy();
        this.setWorld(null);
        this.builderError = null;
    }

    private void uploadGeometry(RenderType layer, MeshData meshData) {
        VertexBuffer buffer = new VertexBuffer(BufferUsage.STATIC_WRITE);
        buffer.bind();
        buffer.upload(meshData);
        VertexBuffer.unbind();
        this.vertexBuffers.get(layer).add(buffer);
    }

    public void cancelBuilding() {
        this.building = false;
        this.builderFutures.forEach(CompletableFuture::join);
        this.builderFutures.clear();
        if (this.bufferBuilders != null) {
            for (BufferBuilder vertBuffer : this.bufferBuilders.values()) {
                ((BufferBuilderExtension)vertBuffer).vivecraft$freeBuffer();
            }
            this.bufferBuilders = null;
        }
        this.currentPositions = null;
    }

    public void destroy() {
        this.cancelBuilding();
        if (this.vertexBuffers != null) {
            for (List<VertexBuffer> buffers : this.vertexBuffers.values()) {
                for (VertexBuffer vertexBuffer : buffers) {
                    if (vertexBuffer == null) continue;
                    vertexBuffer.close();
                }
            }
            this.vertexBuffers = null;
        }
        this.animatedSprites = null;
        this.ready = false;
    }

    public void completeDestroy() {
        this.destroy();
        if (this.starVBO != null) {
            this.starVBO.close();
        }
        if (this.skyVBO != null) {
            this.skyVBO.close();
        }
        if (this.sky2VBO != null) {
            this.sky2VBO.close();
        }
        if (this.endSkyVBO != null) {
            this.endSkyVBO.close();
        }
        this.lightMap.destroyBuffers();
        this.ready = false;
    }

    public void tick() {
        ++this.ticks;
        this.updateTorchFlicker();
        if (this.areEyesInFluid((TagKey<Fluid>)FluidTags.WATER)) {
            int i = 1;
            this.waterVisionTime = Mth.clamp((int)(this.waterVisionTime + i), (int)0, (int)600);
        } else if (this.waterVisionTime > 0) {
            this.areEyesInFluid((TagKey<Fluid>)FluidTags.WATER);
            this.waterVisionTime = Mth.clamp((int)(this.waterVisionTime - 10), (int)0, (int)600);
        }
        if (SodiumHelper.isLoaded() && this.animatedSprites != null) {
            for (TextureAtlasSprite sprite : this.animatedSprites) {
                SodiumHelper.markTextureAsActive(sprite);
            }
        }
        if (OptifineHelper.isOptifineLoaded()) {
            for (TextureAtlasSprite sprite : this.animatedSprites) {
                OptifineHelper.markTextureAsActive(sprite);
            }
        }
    }

    public FakeBlockAccess getLevel() {
        return this.blockAccess;
    }

    public void setWorld(FakeBlockAccess blockAccess) {
        this.blockAccess = blockAccess;
        if (blockAccess != null) {
            this.dimensionInfo = blockAccess.getDimensionReaderInfo();
            this.lightmapUpdateNeeded = true;
            this.renderDistance = blockAccess.getXSize() / 2;
            this.renderDistanceChunks = this.renderDistance / 16;
            this.rainLevel = blockAccess.getRain() ? 1.0f : 0.0f;
            this.thunderLevel = blockAccess.getThunder() ? 1.0f : 0.0f;
            this.worldRotation = blockAccess.getRotation();
        }
    }

    public void loadRenderers() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float g = i - 16;
                float h = Mth.sqrt((float)(f * f + g * g));
                this.rainSizeX[i << 5 | j] = -g / h;
                this.rainSizeZ[i << 5 | j] = f / h;
            }
        }
        this.generateSky();
        this.generateEndSky();
        this.generateStars();
    }

    public boolean isReady() {
        return this.ready;
    }

    private void copyVisibleTextures() {
    }

    public void pushVisibleTextures() {
    }

    public void renderSky(Matrix4fStack poseStack, Vec3 position) {
        if (this.dimensionInfo.skyType() == DimensionSpecialEffects.SkyType.END) {
            this.renderEndSky(poseStack);
        } else if (this.dimensionInfo.skyType() == DimensionSpecialEffects.SkyType.OVERWORLD) {
            float starBrightness;
            CompiledShaderProgram skyShader = RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION);
            this.fogRenderer.setupFog(FogRenderer.FogMode.FOG_SKY);
            Vec3 skyColor = this.getSkyColor(position);
            if (OptifineHelper.isOptifineLoaded()) {
                skyColor = OptifineHelper.getCustomSkyColor(skyColor, (BlockAndTintGetter)this.blockAccess, position.x, position.y, position.z);
            }
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)((float)skyColor.x), (float)((float)skyColor.y), (float)((float)skyColor.z), (float)1.0f);
            if (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSkyEnabled()) {
                this.skyVBO.bind();
                this.skyVBO.drawWithShader((Matrix4f)poseStack, RenderSystem.getProjectionMatrix(), skyShader);
                VertexBuffer.unbind();
            }
            RenderSystem.enableBlend();
            int sunriseColor = 0;
            try {
                sunriseColor = this.dimensionInfo.getSunriseOrSunsetColor(this.getTimeOfDay());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sunriseColor != 0 && this.dimensionInfo.isSunriseOrSunset(this.getTimeOfDay()) && (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSunMoonEnabled())) {
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_COLOR);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                poseStack.pushMatrix();
                poseStack.rotate((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                poseStack.rotate((Quaternionfc)Axis.ZP.rotationDegrees(Mth.sin((float)this.getSunAngle()) < 0.0f ? 180.0f : 0.0f));
                poseStack.rotate((Quaternionfc)Axis.ZP.rotationDegrees(90.0f));
                BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
                bufferBuilder.addVertex((Matrix4f)poseStack, 0.0f, 100.0f, 0.0f).setColor(sunriseColor);
                for (int j = 0; j <= 16; ++j) {
                    float f6 = (float)j * ((float)Math.PI * 2) / 16.0f;
                    float f7 = Mth.sin((float)f6);
                    float f8 = Mth.cos((float)f6);
                    bufferBuilder.addVertex((Matrix4f)poseStack, f7 * 120.0f, f8 * 120.0f, -f8 * 40.0f * ARGB.alphaFloat((int)sunriseColor)).setColor(ARGB.transparent((int)sunriseColor));
                }
                BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
                poseStack.popMatrix();
            }
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            poseStack.pushMatrix();
            float skyVisibility = 1.0f - this.getRainLevel();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)skyVisibility);
            poseStack.rotate((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
            poseStack.rotate((Quaternionfc)Axis.XP.rotationDegrees(this.getTimeOfDay() * 360.0f));
            float size = 30.0f;
            if (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSunMoonEnabled()) {
                RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_TEX);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)SUN_LOCATION);
                BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferBuilder.addVertex((Matrix4f)poseStack, -size, 100.0f, -size).setUv(0.0f, 0.0f);
                bufferBuilder.addVertex((Matrix4f)poseStack, size, 100.0f, -size).setUv(1.0f, 0.0f);
                bufferBuilder.addVertex((Matrix4f)poseStack, size, 100.0f, size).setUv(1.0f, 1.0f);
                bufferBuilder.addVertex((Matrix4f)poseStack, -size, 100.0f, size).setUv(0.0f, 1.0f);
                BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            }
            size = 20.0f;
            if (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSunMoonEnabled()) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)MOON_LOCATION);
                int moonPhase = this.getMoonPhase();
                int l = moonPhase % 4;
                int i1 = moonPhase / 4 % 2;
                float u0 = (float)l / 4.0f;
                float v0 = (float)i1 / 2.0f;
                float u1 = (float)(l + 1) / 4.0f;
                float v1 = (float)(i1 + 1) / 2.0f;
                BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferBuilder.addVertex((Matrix4f)poseStack, -size, -100.0f, size).setUv(u0, v1);
                bufferBuilder.addVertex((Matrix4f)poseStack, size, -100.0f, size).setUv(u1, v1);
                bufferBuilder.addVertex((Matrix4f)poseStack, size, -100.0f, -size).setUv(u1, v0);
                bufferBuilder.addVertex((Matrix4f)poseStack, -size, -100.0f, -size).setUv(u0, v0);
                BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            }
            if ((starBrightness = this.getStarBrightness() * skyVisibility) > 0.0f && (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isStarsEnabled())) {
                this.fogRenderer.setupNoFog();
                RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)starBrightness);
                this.starVBO.bind();
                this.starVBO.drawWithShader((Matrix4f)poseStack, RenderSystem.getProjectionMatrix(), RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION));
                VertexBuffer.unbind();
                this.fogRenderer.setupFog(FogRenderer.FogMode.FOG_SKY);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            poseStack.popMatrix();
            double horizonDistance = position.y - this.blockAccess.getHorizon();
            if (horizonDistance < 0.0) {
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                poseStack.pushMatrix();
                poseStack.translate(0.0f, 12.0f, 0.0f);
                this.sky2VBO.bind();
                this.sky2VBO.drawWithShader((Matrix4f)poseStack, RenderSystem.getProjectionMatrix(), skyShader);
                VertexBuffer.unbind();
                poseStack.popMatrix();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.depthMask((boolean)true);
        }
    }

    private void renderEndSky(Matrix4fStack poseStack) {
        if (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSkyEnabled()) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.depthMask((boolean)false);
            CompiledShaderProgram shader = RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_TEX_COLOR);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)END_SKY_LOCATION);
            this.endSkyVBO.bind();
            this.endSkyVBO.drawWithShader((Matrix4f)poseStack, RenderSystem.getProjectionMatrix(), shader);
            VertexBuffer.unbind();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
        }
    }

    public void renderClouds(Matrix4fStack poseStack, double x, double y, double z) {
        float cloudHeight = this.dimensionInfo.getCloudHeight();
        if (!Float.isNaN(cloudHeight) && this.mc.options.getCloudsType() != CloudStatus.OFF) {
            this.mc.levelRenderer.getCloudRenderer().render(this.getCloudColour(), this.mc.options.getCloudsType(), cloudHeight + 0.35f, (Matrix4f)poseStack, RenderSystem.getProjectionMatrix(), new Vec3(x, y, z), (float)this.ticks + this.mc.getDeltaTracker().getGameTimeDeltaPartialTick(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderSnowAndRain(Matrix4fStack poseStack, double inX, double inY, double inZ) {
        if (this.getRainLevel() <= 0.0f) {
            return;
        }
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().mul((Matrix4fc)poseStack);
        try {
            int xFloor = Mth.floor((double)inX);
            int yFloor = Mth.floor((double)inY);
            int zFloor = Mth.floor((double)inZ);
            BufferBuilder bufferBuilder = null;
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            int rainDistance = 5;
            if (Minecraft.useFancyGraphics()) {
                rainDistance = 10;
            }
            RenderSystem.depthMask((boolean)true);
            int count = -1;
            float rainAnimationTime = (float)this.ticks + ClientUtils.getCurrentPartialTick();
            RenderSystem.setShader((ShaderProgram)CoreShaders.PARTICLE);
            this.turnOnLightLayer();
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int rainZ = zFloor - rainDistance; rainZ <= zFloor + rainDistance; ++rainZ) {
                for (int rainX = xFloor - rainDistance; rainX <= xFloor + rainDistance; ++rainX) {
                    float blend;
                    int upper;
                    int blockingHeight;
                    int lower;
                    int q = (rainZ - zFloor + 16) * 32 + rainX - xFloor + 16;
                    double r = (double)this.rainSizeX[q] * 0.5;
                    double s = (double)this.rainSizeZ[q] * 0.5;
                    mutableBlockPos.set((double)rainX, inY, (double)rainZ);
                    Biome biome = (Biome)this.blockAccess.getBiome((BlockPos)mutableBlockPos).value();
                    if (!biome.hasPrecipitation() || (lower = Math.max(yFloor - rainDistance, blockingHeight = this.blockAccess.getHeightBlocking(rainX, rainZ))) == (upper = Math.max(yFloor + rainDistance, blockingHeight))) continue;
                    int rainY = Math.max(blockingHeight, yFloor);
                    RandomSource randomSource = RandomSource.create((long)((long)(rainX * rainX) * 3121L + (long)rainX * 45238971L ^ (long)(rainZ * rainZ) * 418711L + (long)rainZ * 13761L));
                    mutableBlockPos.setY(lower);
                    Biome.Precipitation precipitation = biome.getPrecipitationAt((BlockPos)mutableBlockPos, this.blockAccess.getSeaLevel());
                    if (precipitation == Biome.Precipitation.NONE) continue;
                    mutableBlockPos.setY(rainY);
                    double localX = (double)rainX + 0.5;
                    double localZ = (double)rainZ + 0.5;
                    float distance = (float)Math.sqrt(localX * localX + localZ * localZ) / (float)rainDistance;
                    float xOffset = 0.0f;
                    float yOffset = 0.0f;
                    int skyLight = this.blockAccess.getBrightness(LightLayer.SKY, (BlockPos)mutableBlockPos) << 4;
                    int blockLight = this.blockAccess.getBrightness(LightLayer.BLOCK, (BlockPos)mutableBlockPos) << 4;
                    if (precipitation == Biome.Precipitation.RAIN) {
                        if (count != 0) {
                            if (count >= 0) {
                                BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
                            }
                            count = 0;
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)RAIN_LOCATION);
                            bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                        }
                        blend = (1.0f - distance * distance) * 0.5f + 0.5f;
                        int x = this.ticks + rainX * rainX * 3121 + rainX * 45238971 + rainZ * rainZ * 418711 + rainZ * 13761 & 0x1F;
                        yOffset = -((float)x + ClientUtils.getCurrentPartialTick()) / 32.0f * (3.0f + randomSource.nextFloat());
                    } else {
                        if (precipitation != Biome.Precipitation.SNOW) continue;
                        if (count != 1) {
                            if (count >= 0) {
                                BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
                            }
                            count = 1;
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SNOW_LOCATION);
                            bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                        }
                        blend = (1.0f - distance * distance) * 0.3f + 0.5f;
                        xOffset = (float)(randomSource.nextDouble() + (double)rainAnimationTime * 0.01 * (double)((float)randomSource.nextGaussian()));
                        float ae = -((float)(this.ticks & 0x1FF) + ClientUtils.getCurrentPartialTick()) / 512.0f;
                        float af = (float)(randomSource.nextDouble() + (double)(rainAnimationTime * (float)randomSource.nextGaussian()) * 0.001);
                        yOffset = ae + af;
                        skyLight = (skyLight * 3 + 240) / 4;
                        blockLight = (blockLight * 3 + 240) / 4;
                    }
                    bufferBuilder.addVertex((float)(localX - r), (float)upper - (float)inY, (float)(localZ - s)).setUv(0.0f + xOffset, (float)lower * 0.25f + yOffset).setColor(1.0f, 1.0f, 1.0f, blend).setUv2(blockLight, skyLight);
                    bufferBuilder.addVertex((float)(localX + r), (float)upper - (float)inY, (float)(localZ + s)).setUv(1.0f + xOffset, (float)lower * 0.25f + yOffset).setColor(1.0f, 1.0f, 1.0f, blend).setUv2(blockLight, skyLight);
                    bufferBuilder.addVertex((float)(localX + r), (float)lower - (float)inY, (float)(localZ + s)).setUv(1.0f + xOffset, (float)upper * 0.25f + yOffset).setColor(1.0f, 1.0f, 1.0f, blend).setUv2(blockLight, skyLight);
                    bufferBuilder.addVertex((float)(localX - r), (float)lower - (float)inY, (float)(localZ - s)).setUv(0.0f + xOffset, (float)upper * 0.25f + yOffset).setColor(1.0f, 1.0f, 1.0f, blend).setUv2(blockLight, skyLight);
                }
            }
            if (count >= 0) {
                BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            }
        }
        finally {
            RenderSystem.getModelViewStack().popMatrix();
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            this.turnOffLightLayer();
        }
    }

    public static int getLightColor(BlockAndTintGetter blockAndTintGetter, BlockPos blockPos) {
        int i = blockAndTintGetter.getBrightness(LightLayer.SKY, blockPos);
        int j = blockAndTintGetter.getBrightness(LightLayer.BLOCK, blockPos);
        return i << 20 | j << 4;
    }

    public float getTimeOfDay() {
        return this.blockAccess.dimensionType().timeOfDay(this.time);
    }

    public float getSunAngle() {
        float dayTime = this.getTimeOfDay();
        return dayTime * ((float)Math.PI * 2);
    }

    public int getMoonPhase() {
        return this.blockAccess.dimensionType().moonPhase(this.time);
    }

    public float getSkyDarken() {
        float dayTime = this.getTimeOfDay();
        float h = 1.0f - (Mth.cos((float)(dayTime * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        h = Mth.clamp((float)h, (float)0.0f, (float)1.0f);
        h = 1.0f - h;
        h *= 1.0f - this.getRainLevel() * 5.0f / 16.0f;
        return (h *= 1.0f - this.getThunderLevel() * 5.0f / 16.0f) * 0.8f + 0.2f;
    }

    public float getRainLevel() {
        return this.rainLevel;
    }

    public float getThunderLevel() {
        return this.thunderLevel * this.getRainLevel();
    }

    public float getStarBrightness() {
        float f = this.getTimeOfDay();
        float f1 = 1.0f - (Mth.cos((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        f1 = Mth.clamp((float)f1, (float)0.0f, (float)1.0f);
        return f1 * f1 * 0.5f;
    }

    public Vec3 getSkyColor(Vec3 position) {
        float f;
        float darkening;
        float luminance;
        float dayTime = this.getTimeOfDay();
        Vec3 samplePosition = position.subtract(2.0, 2.0, 2.0).scale(0.25);
        Vec3 skyColor = CubicSampler.gaussianSampleVec3((Vec3)samplePosition, (i, j, k) -> Vec3.fromRGB24((int)((Biome)this.blockAccess.getBiomeManager().getNoiseBiomeAtQuart(i, j, k).value()).getSkyColor()));
        float h = Mth.cos((float)(dayTime * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        h = Mth.clamp((float)h, (float)0.0f, (float)1.0f);
        float skyColorR = (float)skyColor.x * h;
        float skyColorG = (float)skyColor.y * h;
        float skyColorB = (float)skyColor.z * h;
        float rain = this.getRainLevel();
        if (rain > 0.0f) {
            luminance = (skyColorR * 0.3f + skyColorG * 0.59f + skyColorB * 0.11f) * 0.6f;
            darkening = 1.0f - rain * 0.75f;
            skyColorR = skyColorR * darkening + luminance * (1.0f - darkening);
            skyColorG = skyColorG * darkening + luminance * (1.0f - darkening);
            skyColorB = skyColorB * darkening + luminance * (1.0f - darkening);
        }
        float thunder = this.getThunderLevel();
        if (f > 0.0f) {
            luminance = (skyColorR * 0.3f + skyColorG * 0.59f + skyColorB * 0.11f) * 0.2f;
            darkening = 1.0f - thunder * 0.75f;
            skyColorR = skyColorR * darkening + luminance * (1.0f - darkening);
            skyColorG = skyColorG * darkening + luminance * (1.0f - darkening);
            skyColorB = skyColorB * darkening + luminance * (1.0f - darkening);
        }
        if (!((Boolean)this.mc.options.hideLightningFlash().get()).booleanValue() && this.skyFlashTime > 0) {
            float flash = (float)this.skyFlashTime - ClientUtils.getCurrentPartialTick();
            if (flash > 1.0f) {
                flash = 1.0f;
            }
            skyColorR = skyColorR * (1.0f - (flash *= 0.45f)) + 0.8f * flash;
            skyColorG = skyColorG * (1.0f - flash) + 0.8f * flash;
            skyColorB = skyColorB * (1.0f - flash) + flash;
        }
        return new Vec3((double)skyColorR, (double)skyColorG, (double)skyColorB);
    }

    public Vec3 getFogColor(Vec3 pos) {
        float f = Mth.clamp((float)(Mth.cos((float)(this.getTimeOfDay() * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        Vec3 scaledPos = pos.subtract(2.0, 2.0, 2.0).scale(0.25);
        return CubicSampler.gaussianSampleVec3((Vec3)scaledPos, (x, y, z) -> this.dimensionInfo.getBrightnessDependentFogColor(Vec3.fromRGB24((int)((Biome)this.blockAccess.getBiomeManager().getNoiseBiomeAtQuart(x, y, z).value()).getFogColor()), f));
    }

    public int getCloudColour() {
        int color = -1;
        float rain = this.getRainLevel();
        if (rain > 0.0f) {
            int j = ARGB.scaleRGB((int)ARGB.greyscale((int)color), (float)0.6f);
            color = ARGB.lerp((float)(rain * 0.95f), (int)color, (int)j);
        }
        float dayTime = this.getTimeOfDay();
        float k = Mth.cos((float)(dayTime * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        k = Mth.clamp((float)k, (float)0.0f, (float)1.0f);
        color = ARGB.multiply((int)color, (int)ARGB.colorFromFloat((float)1.0f, (float)(k * 0.9f + 0.1f), (float)(k * 0.9f + 0.1f), (float)(k * 0.85f + 0.15f)));
        float thunder = this.getThunderLevel();
        if (thunder > 0.0f) {
            int greyColor = ARGB.scaleRGB((int)ARGB.greyscale((int)color), (float)0.2f);
            color = ARGB.lerp((float)(thunder * 0.95f), (int)color, (int)greyColor);
        }
        return color;
    }

    private void generateSky() {
        if (this.skyVBO != null) {
            this.skyVBO.close();
        }
        if (this.sky2VBO != null) {
            this.sky2VBO.close();
        }
        this.skyVBO = new VertexBuffer(BufferUsage.STATIC_WRITE);
        this.skyVBO.bind();
        this.skyVBO.upload(MenuWorldRenderer.buildSkyDisc(Tesselator.getInstance(), 16.0f));
        VertexBuffer.unbind();
        this.sky2VBO = new VertexBuffer(BufferUsage.STATIC_WRITE);
        this.sky2VBO.bind();
        this.sky2VBO.upload(MenuWorldRenderer.buildSkyDisc(Tesselator.getInstance(), -16.0f));
        VertexBuffer.unbind();
    }

    private void generateEndSky() {
        if (this.endSkyVBO != null) {
            this.endSkyVBO.close();
        }
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        for (int i = 0; i < 6; ++i) {
            Matrix4f matrix = new Matrix4f();
            switch (i) {
                case 1: {
                    matrix.rotationX(1.5707964f);
                    break;
                }
                case 2: {
                    matrix.rotationX(-1.5707964f);
                    break;
                }
                case 3: {
                    matrix.rotationX((float)Math.PI);
                    break;
                }
                case 4: {
                    matrix.rotationZ(1.5707964f);
                    break;
                }
                case 5: {
                    matrix.rotationZ(-1.5707964f);
                }
            }
            int r = 40;
            int g = 40;
            int b = 40;
            if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isCustomColors()) {
                Vec3 newSkyColor = new Vec3((double)r / 255.0, (double)g / 255.0, (double)b / 255.0);
                newSkyColor = OptifineHelper.getCustomSkyColorEnd(newSkyColor);
                r = (int)(newSkyColor.x * 255.0);
                g = (int)(newSkyColor.y * 255.0);
                b = (int)(newSkyColor.z * 255.0);
            }
            bufferBuilder.addVertex(matrix, -100.0f, -100.0f, -100.0f).setUv(0.0f, 0.0f).setColor(r, g, b, 255);
            bufferBuilder.addVertex(matrix, -100.0f, -100.0f, 100.0f).setUv(0.0f, 16.0f).setColor(r, g, b, 255);
            bufferBuilder.addVertex(matrix, 100.0f, -100.0f, 100.0f).setUv(16.0f, 16.0f).setColor(r, g, b, 255);
            bufferBuilder.addVertex(matrix, 100.0f, -100.0f, -100.0f).setUv(16.0f, 0.0f).setColor(r, g, b, 255);
        }
        this.endSkyVBO = new VertexBuffer(BufferUsage.STATIC_WRITE);
        this.endSkyVBO.bind();
        this.endSkyVBO.upload(bufferBuilder.buildOrThrow());
        VertexBuffer.unbind();
    }

    private static MeshData buildSkyDisc(Tesselator tesselator, float posY) {
        float g = Math.signum(posY) * 512.0f;
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
        bufferBuilder.addVertex(0.0f, posY, 0.0f);
        for (int i = -180; i <= 180; i += 45) {
            bufferBuilder.addVertex(g * Mth.cos((float)((float)i * ((float)Math.PI / 180))), posY, 512.0f * Mth.sin((float)((float)i * ((float)Math.PI / 180))));
        }
        return bufferBuilder.buildOrThrow();
    }

    private void generateStars() {
        if (this.starVBO != null) {
            this.starVBO.close();
        }
        this.starVBO = new VertexBuffer(BufferUsage.STATIC_WRITE);
        this.starVBO.bind();
        this.starVBO.upload(this.buildStars(Tesselator.getInstance()));
        VertexBuffer.unbind();
    }

    private MeshData buildStars(Tesselator tesselator) {
        RandomSource randomSource = RandomSource.create((long)10842L);
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        int starCount = 1500;
        float starDistance = 100.0f;
        for (int i = 0; i < starCount; ++i) {
            Vector3f starPoint = new Vector3f(randomSource.nextFloat(), randomSource.nextFloat(), randomSource.nextFloat()).mul(2.0f).sub(1.0f, 1.0f, 1.0f);
            float starSize = 0.15f + randomSource.nextFloat() * 0.1f;
            float distance = starPoint.lengthSquared();
            if (distance <= 0.010000001f || distance >= 1.0f) continue;
            starPoint.normalize(starDistance);
            float starRotation = (float)(randomSource.nextDouble() * Math.PI * 2.0);
            Matrix3f rotation = new Matrix3f().rotateTowards((Vector3fc)starPoint.negate(new Vector3f()), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)).rotateZ(-starRotation);
            bufferBuilder.addVertex(new Vector3f(starSize, -starSize, 0.0f).mul((Matrix3fc)rotation).add((Vector3fc)starPoint));
            bufferBuilder.addVertex(new Vector3f(starSize, starSize, 0.0f).mul((Matrix3fc)rotation).add((Vector3fc)starPoint));
            bufferBuilder.addVertex(new Vector3f(-starSize, starSize, 0.0f).mul((Matrix3fc)rotation).add((Vector3fc)starPoint));
            bufferBuilder.addVertex(new Vector3f(-starSize, -starSize, 0.0f).mul((Matrix3fc)rotation).add((Vector3fc)starPoint));
        }
        return bufferBuilder.buildOrThrow();
    }

    public void turnOffLightLayer() {
        RenderSystem.setShaderTexture((int)2, (int)0);
    }

    public void turnOnLightLayer() {
        RenderSystem.setShaderTexture((int)2, (int)this.lightMap.getColorTextureId());
    }

    public void updateTorchFlicker() {
        this.blockLightRedFlicker += (float)((Math.random() - Math.random()) * Math.random() * Math.random() * 0.1);
        this.blockLightRedFlicker *= 0.9f;
        this.lightmapUpdateNeeded = true;
    }

    public void updateLightmap() {
        if (this.lightmapUpdateNeeded) {
            float skyLight = this.getSkyDarken();
            float effectiveSkyLight = this.skyFlashTime > 0 ? 1.0f : skyLight * 0.95f + 0.05f;
            float waterVision = this.getWaterVision();
            float nightVision = 0.0f;
            Vector3f skylightColor = new Vector3f(skyLight, skyLight, 1.0f).lerp((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
            CompiledShaderProgram compiledShaderProgram = Objects.requireNonNull(RenderSystem.setShader((ShaderProgram)CoreShaders.LIGHTMAP), "Lightmap shader not loaded");
            compiledShaderProgram.safeGetUniform("AmbientLightFactor").set(this.blockAccess.dimensionType().ambientLight());
            compiledShaderProgram.safeGetUniform("SkyFactor").set(effectiveSkyLight);
            compiledShaderProgram.safeGetUniform("BlockFactor").set(this.blockLightRedFlicker + 1.5f);
            compiledShaderProgram.safeGetUniform("UseBrightLightmap").set(0);
            compiledShaderProgram.safeGetUniform("SkyLightColor").set(skylightColor);
            compiledShaderProgram.safeGetUniform("NightVisionFactor").set(nightVision);
            compiledShaderProgram.safeGetUniform("DarknessScale").set(0.0f);
            compiledShaderProgram.safeGetUniform("DarkenWorldFactor").set(0.0f);
            compiledShaderProgram.safeGetUniform("BrightnessFactor").set(Math.max(0.0f, ((Double)this.mc.options.gamma().get()).floatValue()));
            this.lightMap.bindWrite(true);
            BufferBuilder bufferBuilder = RenderSystem.renderThreadTesselator().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.BLIT_SCREEN);
            bufferBuilder.addVertex(0.0f, 0.0f, 0.0f);
            bufferBuilder.addVertex(1.0f, 0.0f, 0.0f);
            bufferBuilder.addVertex(1.0f, 1.0f, 0.0f);
            bufferBuilder.addVertex(0.0f, 1.0f, 0.0f);
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            this.lightMap.unbindWrite();
            this.mc.mainRenderTarget.bindWrite(true);
            this.lightmapUpdateNeeded = false;
        }
    }

    private float notGamma(float f) {
        float g = 1.0f - f;
        return 1.0f - g * g * g * g;
    }

    public float getWaterVision() {
        if (!this.areEyesInFluid((TagKey<Fluid>)FluidTags.WATER)) {
            return 0.0f;
        }
        if ((float)this.waterVisionTime >= 600.0f) {
            return 1.0f;
        }
        float f2 = Mth.clamp((float)((float)this.waterVisionTime / 100.0f), (float)0.0f, (float)1.0f);
        float f3 = (float)this.waterVisionTime < 100.0f ? 0.0f : Mth.clamp((float)(((float)this.waterVisionTime - 100.0f) / 500.0f), (float)0.0f, (float)1.0f);
        return f2 * 0.6f + f3 * 0.39999998f;
    }

    public boolean areEyesInFluid(TagKey<Fluid> tagIn) {
        if (this.blockAccess == null) {
            return false;
        }
        Vec3 pos = this.getEyePos();
        BlockPos blockpos = BlockPos.containing((Position)pos);
        FluidState fluidstate = this.blockAccess.getFluidState(blockpos);
        return this.isFluidTagged(fluidstate, tagIn) && pos.y < (double)((float)blockpos.getY() + (float)fluidstate.getAmount() + 0.11111111f);
    }

    public Vec3 getEyePos() {
        return ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_post.hmd.getPosition();
    }

    private boolean isFluidTagged(Fluid fluid, TagKey<Fluid> tag) {
        if (tag == FluidTags.WATER) {
            return fluid == Fluids.WATER || fluid == Fluids.FLOWING_WATER;
        }
        if (tag == FluidTags.LAVA) {
            return fluid == Fluids.LAVA || fluid == Fluids.FLOWING_LAVA;
        }
        return false;
    }

    private boolean isFluidTagged(FluidState fluidState, TagKey<Fluid> tag) {
        return this.isFluidTagged(fluidState.getType(), tag);
    }

    public static class MenuFogRenderer {
        public float fogRed;
        public float fogGreen;
        public float fogBlue;
        private int targetBiomeFog;
        private int previousBiomeFog;
        private long biomeChangedTime;
        private final MenuWorldRenderer menuWorldRenderer;

        public MenuFogRenderer(MenuWorldRenderer menuWorldRenderer) {
            this.menuWorldRenderer = menuWorldRenderer;
        }

        public void setupFogColor() {
            Vec3 eyePos = this.menuWorldRenderer.getEyePos();
            FogType fogType = this.getEyeFogType();
            if (fogType == FogType.WATER) {
                this.updateWaterFog(this.menuWorldRenderer.getLevel());
            } else if (fogType == FogType.LAVA) {
                this.fogRed = 0.6f;
                this.fogGreen = 0.1f;
                this.fogBlue = 0.0f;
                this.biomeChangedTime = -1L;
            } else if (fogType == FogType.POWDER_SNOW) {
                this.fogRed = 0.623f;
                this.fogGreen = 0.734f;
                this.fogBlue = 0.785f;
                this.biomeChangedTime = -1L;
            } else {
                this.updateSurfaceFog();
                this.biomeChangedTime = -1L;
            }
            float d0 = (float)((eyePos.y + (double)this.menuWorldRenderer.getLevel().getGround()) * this.menuWorldRenderer.getLevel().getVoidFogYFactor());
            if ((double)d0 < 1.0 && fogType != FogType.LAVA && fogType != FogType.POWDER_SNOW) {
                if (d0 < 0.0f) {
                    d0 = 0.0f;
                }
                d0 *= d0;
                this.fogRed *= d0;
                this.fogGreen *= d0;
                this.fogBlue *= d0;
            }
            if (fogType == FogType.WATER && this.fogRed != 0.0f && this.fogGreen != 0.0f && this.fogBlue != 0.0f) {
                float f1 = this.menuWorldRenderer.getWaterVision();
                float f3 = Math.min(1.0f / this.fogRed, Math.min(1.0f / this.fogGreen, 1.0f / this.fogBlue));
                this.fogRed = this.fogRed * (1.0f - f1) + this.fogRed * f3 * f1;
                this.fogGreen = this.fogGreen * (1.0f - f1) + this.fogGreen * f3 * f1;
                this.fogBlue = this.fogBlue * (1.0f - f1) + this.fogBlue * f3 * f1;
            }
            if (OptifineHelper.isOptifineLoaded()) {
                Vec3 colUnderlava;
                if (fogType == FogType.WATER) {
                    Vec3 colUnderwater = OptifineHelper.getCustomUnderwaterColor((BlockAndTintGetter)this.menuWorldRenderer.blockAccess, eyePos.x, eyePos.y, eyePos.z);
                    if (colUnderwater != null) {
                        this.fogRed = (float)colUnderwater.x;
                        this.fogGreen = (float)colUnderwater.y;
                        this.fogBlue = (float)colUnderwater.z;
                    }
                } else if (fogType == FogType.LAVA && (colUnderlava = OptifineHelper.getCustomUnderlavaColor((BlockAndTintGetter)this.menuWorldRenderer.blockAccess, eyePos.x, eyePos.y, eyePos.z)) != null) {
                    this.fogRed = (float)colUnderlava.x;
                    this.fogGreen = (float)colUnderlava.y;
                    this.fogBlue = (float)colUnderlava.z;
                }
            }
            RenderSystem.clearColor((float)this.fogRed, (float)this.fogGreen, (float)this.fogBlue, (float)0.0f);
        }

        private void updateSurfaceFog() {
            float f7;
            float f = 0.25f + 0.75f * (float)this.menuWorldRenderer.renderDistanceChunks / 32.0f;
            f = 1.0f - (float)Math.pow(f, 0.25);
            Vec3 eyePos = this.menuWorldRenderer.getEyePos();
            Vec3 skyColor = this.menuWorldRenderer.getSkyColor(eyePos);
            if (OptifineHelper.isOptifineLoaded()) {
                if (this.menuWorldRenderer.blockAccess.dimensionType().effectsLocation().equals((Object)BuiltinDimensionTypes.OVERWORLD_EFFECTS)) {
                    skyColor = OptifineHelper.getCustomSkyColor(skyColor, (BlockAndTintGetter)this.menuWorldRenderer.blockAccess, eyePos.x, eyePos.y, eyePos.z);
                } else if (this.menuWorldRenderer.blockAccess.dimensionType().effectsLocation().equals((Object)BuiltinDimensionTypes.END_EFFECTS)) {
                    skyColor = OptifineHelper.getCustomSkyColorEnd(skyColor);
                }
            }
            float skyRed = (float)skyColor.x;
            float skyGreen = (float)skyColor.y;
            float skyBlue = (float)skyColor.z;
            Vec3 fogColor = this.menuWorldRenderer.getFogColor(eyePos);
            if (OptifineHelper.isOptifineLoaded()) {
                if (this.menuWorldRenderer.blockAccess.dimensionType().effectsLocation().equals((Object)BuiltinDimensionTypes.OVERWORLD_EFFECTS)) {
                    fogColor = OptifineHelper.getCustomFogColor(fogColor, (BlockAndTintGetter)this.menuWorldRenderer.blockAccess, eyePos.x, eyePos.y, eyePos.z);
                } else if (this.menuWorldRenderer.blockAccess.dimensionType().effectsLocation().equals((Object)BuiltinDimensionTypes.END_EFFECTS)) {
                    fogColor = OptifineHelper.getCustomFogColorEnd(fogColor);
                } else if (this.menuWorldRenderer.blockAccess.dimensionType().effectsLocation().equals((Object)BuiltinDimensionTypes.NETHER_EFFECTS)) {
                    fogColor = OptifineHelper.getCustomFogColorNether(fogColor);
                }
            }
            this.fogRed = (float)fogColor.x;
            this.fogGreen = (float)fogColor.y;
            this.fogBlue = (float)fogColor.z;
            if (this.menuWorldRenderer.renderDistanceChunks >= 4) {
                float d0 = Mth.sin((float)this.menuWorldRenderer.getSunAngle()) > 0.0f ? -1.0f : 1.0f;
                float f5 = ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_post.hmd.getDirection().rotateY(-this.menuWorldRenderer.worldRotation * ((float)Math.PI / 180)).dot(d0, 0.0f, 0.0f);
                if (f5 < 0.0f) {
                    f5 = 0.0f;
                }
                if (f5 > 0.0f && this.menuWorldRenderer.dimensionInfo.isSunriseOrSunset(this.menuWorldRenderer.getTimeOfDay())) {
                    int sunriseColor = 0;
                    try {
                        sunriseColor = this.menuWorldRenderer.dimensionInfo.getSunriseOrSunsetColor(this.menuWorldRenderer.getTimeOfDay());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (sunriseColor != 0) {
                        this.fogRed = this.fogRed * (1.0f - (f5 *= ARGB.alphaFloat((int)sunriseColor))) + ARGB.redFloat((int)sunriseColor) * f5;
                        this.fogGreen = this.fogGreen * (1.0f - f5) + ARGB.greenFloat((int)sunriseColor) * f5;
                        this.fogBlue = this.fogBlue * (1.0f - f5) + ARGB.blueFloat((int)sunriseColor) * f5;
                    }
                }
            }
            this.fogRed += (skyRed - this.fogRed) * f;
            this.fogGreen += (skyGreen - this.fogGreen) * f;
            this.fogBlue += (skyBlue - this.fogBlue) * f;
            float f6 = this.menuWorldRenderer.getRainLevel();
            if (f6 > 0.0f) {
                float f4 = 1.0f - f6 * 0.5f;
                float f8 = 1.0f - f6 * 0.4f;
                this.fogRed *= f4;
                this.fogGreen *= f4;
                this.fogBlue *= f8;
            }
            if ((f7 = this.menuWorldRenderer.getThunderLevel()) > 0.0f) {
                float f9 = 1.0f - f7 * 0.5f;
                this.fogRed *= f9;
                this.fogGreen *= f9;
                this.fogBlue *= f9;
            }
            this.biomeChangedTime = -1L;
        }

        private void updateWaterFog(LevelReader levelIn) {
            long currentTime = Util.getMillis();
            int waterFogColor = ((Biome)levelIn.getBiome(BlockPos.containing((Position)this.menuWorldRenderer.getEyePos())).value()).getWaterFogColor();
            if (this.biomeChangedTime < 0L) {
                this.targetBiomeFog = waterFogColor;
                this.previousBiomeFog = waterFogColor;
                this.biomeChangedTime = currentTime;
            }
            int k = this.targetBiomeFog >> 16 & 0xFF;
            int l = this.targetBiomeFog >> 8 & 0xFF;
            int i1 = this.targetBiomeFog & 0xFF;
            int j1 = this.previousBiomeFog >> 16 & 0xFF;
            int k1 = this.previousBiomeFog >> 8 & 0xFF;
            int l1 = this.previousBiomeFog & 0xFF;
            float f = Mth.clamp((float)((float)(currentTime - this.biomeChangedTime) / 5000.0f), (float)0.0f, (float)1.0f);
            float f1 = Mth.lerp((float)f, (float)j1, (float)k);
            float f2 = Mth.lerp((float)f, (float)k1, (float)l);
            float f3 = Mth.lerp((float)f, (float)l1, (float)i1);
            this.fogRed = f1 / 255.0f;
            this.fogGreen = f2 / 255.0f;
            this.fogBlue = f3 / 255.0f;
            if (this.targetBiomeFog != waterFogColor) {
                this.targetBiomeFog = waterFogColor;
                this.previousBiomeFog = Mth.floor((float)f1) << 16 | Mth.floor((float)f2) << 8 | Mth.floor((float)f3);
                this.biomeChangedTime = currentTime;
            }
        }

        public void setupFog(FogRenderer.FogMode fogMode) {
            float fogEnd;
            float fogStart;
            FogType fogType = this.getEyeFogType();
            FogShape fogShape = FogShape.SPHERE;
            if (fogType == FogType.LAVA) {
                fogStart = 0.25f;
                fogEnd = 1.0f;
            } else if (fogType == FogType.POWDER_SNOW) {
                fogStart = 0.0f;
                fogEnd = 2.0f;
            } else if (fogType == FogType.WATER) {
                fogStart = -8.0f;
                fogEnd = 96.0f;
                Holder holder = this.menuWorldRenderer.blockAccess.getBiome(BlockPos.containing((Position)this.menuWorldRenderer.getEyePos()));
                if (holder.is(BiomeTags.HAS_CLOSER_WATER_FOG)) {
                    fogEnd *= 0.85f;
                }
                if (fogEnd > (float)this.menuWorldRenderer.renderDistance) {
                    fogEnd = this.menuWorldRenderer.renderDistance;
                    fogShape = FogShape.CYLINDER;
                }
            } else if (this.menuWorldRenderer.blockAccess.getDimensionReaderInfo().isFoggyAt(0, 0)) {
                fogStart = (float)this.menuWorldRenderer.renderDistance * 0.05f;
                fogEnd = Math.min((float)this.menuWorldRenderer.renderDistance, 192.0f) * 0.5f;
            } else if (fogMode == FogRenderer.FogMode.FOG_SKY) {
                fogStart = 0.0f;
                fogEnd = this.menuWorldRenderer.renderDistance;
                fogShape = FogShape.CYLINDER;
            } else {
                float h = Mth.clamp((float)((float)this.menuWorldRenderer.renderDistance / 10.0f), (float)4.0f, (float)64.0f);
                fogStart = (float)this.menuWorldRenderer.renderDistance - h;
                fogEnd = this.menuWorldRenderer.renderDistance;
                fogShape = FogShape.CYLINDER;
            }
            RenderSystem.setShaderFog((FogParameters)new FogParameters(fogStart, fogEnd, fogShape, this.fogRed, this.fogGreen, this.fogBlue, 1.0f));
        }

        private FogType getEyeFogType() {
            FogType fogType = FogType.NONE;
            if (this.menuWorldRenderer.areEyesInFluid((TagKey<Fluid>)FluidTags.WATER)) {
                fogType = FogType.WATER;
            } else if (this.menuWorldRenderer.areEyesInFluid((TagKey<Fluid>)FluidTags.LAVA)) {
                fogType = FogType.LAVA;
            } else if (this.menuWorldRenderer.blockAccess.getBlockState(BlockPos.containing((Position)this.menuWorldRenderer.getEyePos())).is(Blocks.POWDER_SNOW)) {
                fogType = FogType.POWDER_SNOW;
            }
            return fogType;
        }

        public void setupNoFog() {
            RenderSystem.setShaderFog((FogParameters)FogParameters.NO_FOG);
        }
    }

    private static class FluidStateWrapper
    extends FluidState {
        private final FluidState fluidState;

        public FluidStateWrapper(FluidState fluidState) {
            super(fluidState.getType(), null, fluidState.propertiesCodec);
            ((StateHolderExtension)((Object)this)).vivecraft$setValues(fluidState.getValues());
            this.fluidState = fluidState;
        }

        public boolean is(TagKey<Fluid> tagIn) {
            if (tagIn == FluidTags.WATER) {
                return this.getType() == Fluids.WATER || this.getType() == Fluids.FLOWING_WATER;
            }
            if (tagIn == FluidTags.LAVA) {
                return this.getType() == Fluids.LAVA || this.getType() == Fluids.FLOWING_LAVA;
            }
            return this.fluidState.is(tagIn);
        }
    }
}

