/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.FoodOnAStickItem;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.data.ViveItemTags;

public class VehicleTracker
implements Tracker {
    private float PreMount_World_Rotation;
    public Vec3 Premount_Pos_Room = Vec3.ZERO;
    public float vehicleInitialRotation = 0.0f;
    public int rotationCooldown = 0;
    public int dismountCooldown = 0;
    private double rotationTarget = 0.0;
    private int minecartStupidityCounter;
    private boolean isRiding = false;
    private final Minecraft mc;
    private final ClientDataHolderVR dh;

    public VehicleTracker(Minecraft mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        if (player == null) {
            return false;
        }
        if (this.mc.gameMode == null) {
            return false;
        }
        return player.isAlive();
    }

    @Override
    public void inactiveProcess(LocalPlayer player) {
        this.minecartStupidityCounter = 2;
        this.isRiding = false;
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    public double getVehicleFloor(Entity vehicle, double original) {
        return original;
    }

    public static Vector3f getSteeringDirection(LocalPlayer player) {
        Entity entity = player.getVehicle();
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        if (entity instanceof AbstractHorse || entity instanceof AbstractBoat) {
            if (player.zza > 0.0f) {
                return VehicleTracker.getFreeMoveDirection();
            }
        } else if (entity != null && entity.isLocalInstanceAuthoritative()) {
            int c = VehicleTracker.getControllerWithFoodStick(player);
            if (entity instanceof Mob && c != -1) {
                VRData.VRDevicePose con = dataHolder.vrPlayer.vrdata_world_pre.getController(c);
                return MathUtils.subtractToVector3f(con.getPosition(), entity.position()).add((Vector3fc)con.getDirection().mul(0.3f)).normalize();
            }
            return VehicleTracker.getFreeMoveDirection();
        }
        return null;
    }

    private static Vector3f getFreeMoveDirection() {
        if (ClientDataHolderVR.getInstance().vrSettings.vrFreeMoveMode == VRSettings.FreeMove.HMD) {
            return ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_pre.hmd.getDirection();
        }
        return ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_pre.getController(0).getDirection();
    }

    private static int getControllerWithFoodStick(LocalPlayer player) {
        if (player.getMainHandItem().getItem() instanceof FoodOnAStickItem || player.getMainHandItem().is(ViveItemTags.VIVECRAFT_FOOD_STICKS)) {
            return 0;
        }
        if (player.getOffhandItem().getItem() instanceof FoodOnAStickItem || player.getOffhandItem().is(ViveItemTags.VIVECRAFT_FOOD_STICKS)) {
            return 1;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void activeProcess(LocalPlayer player) {
        block21: {
            block23: {
                block22: {
                    if (this.mc.isPaused()) break block21;
                    if (this.dismountCooldown > 0) {
                        --this.dismountCooldown;
                    }
                    if (this.rotationCooldown > 0) {
                        --this.rotationCooldown;
                    }
                    if (!this.dh.vrSettings.vehicleRotation || this.rotationCooldown != 0 || !this.mc.player.isPassenger() && (this.mc.getCameraEntity() == null || this.mc.getCameraEntity() == this.mc.player)) break block22;
                    entity = this.mc.player.getVehicle();
                    if (this.mc.getCameraEntity() != null && this.mc.getCameraEntity() != this.mc.player) {
                        entity = this.mc.getCameraEntity();
                    }
                    this.rotationTarget = entity.getYRot();
                    if (!(entity instanceof AbstractHorse)) ** GOTO lbl-1000
                    abstracthorse = (AbstractHorse)entity;
                    if (!this.dh.horseTracker.isActive(this.mc.player)) {
                        if (abstracthorse.isLocalInstanceAuthoritative() && abstracthorse.isSaddled()) {
                            return;
                        }
                        this.rotationTarget = abstracthorse.yBodyRot;
                    } else if (entity instanceof Mob) {
                        mob = (Mob)entity;
                        if (mob.isLocalInstanceAuthoritative()) {
                            return;
                        }
                        this.rotationTarget = mob.yBodyRot;
                    }
                    smooth = true;
                    smoothIncrement = 10.0f;
                    if (entity instanceof Minecart) {
                        minecart = (Minecart)entity;
                        if (this.shouldMinecartTurnView(minecart)) {
                            if (this.minecartStupidityCounter > 0) {
                                --this.minecartStupidityCounter;
                            }
                        } else {
                            this.minecartStupidityCounter = 3;
                        }
                        this.rotationTarget = this.getMinecartRenderYaw(minecart);
                        if (this.minecartStupidityCounter > 0) {
                            this.vehicleInitialRotation = (float)this.rotationTarget;
                        }
                        if ((smoothIncrement = 200.0f * (float)((speed = this.mineCartSpeed(minecart)) * speed)) < 10.0f) {
                            smoothIncrement = 10.0f;
                        }
                    }
                    difference = this.dh.vrPlayer.rotDiff_Degrees((float)this.rotationTarget, this.vehicleInitialRotation);
                    if (smooth) {
                        if (difference > smoothIncrement) {
                            difference = smoothIncrement;
                        }
                        if (difference < -smoothIncrement) {
                            difference = -smoothIncrement;
                        }
                    }
                    this.dh.vrSettings.worldRotation += difference;
                    this.dh.vrSettings.worldRotation %= 360.0f;
                    this.dh.vr.seatedRot = this.dh.vrSettings.worldRotation;
                    this.vehicleInitialRotation -= difference;
                    this.vehicleInitialRotation %= 360.0f;
                    break block23;
                }
                this.minecartStupidityCounter = 3;
                if (this.mc.getCameraEntity() != null && this.mc.getCameraEntity() != this.mc.player) {
                    this.vehicleInitialRotation = this.mc.getCameraEntity().getYRot();
                } else if (this.mc.player.isPassenger()) {
                    this.vehicleInitialRotation = this.mc.player.getVehicle().getYRot();
                }
            }
            if (this.isRiding && this.mc.getCameraEntity() != null && this.mc.getCameraEntity() != this.mc.player) {
                ridingPos = this.mc.getCameraEntity().getEyePosition().subtract(0.0, (double)this.mc.player.eyeHeight, 0.0);
                this.updateRiderPos(ridingPos.x, ridingPos.y, ridingPos.z, this.mc.getCameraEntity());
            }
        }
    }

    public void onStartRiding(Entity vehicle) {
        this.isRiding = true;
        this.PreMount_World_Rotation = this.dh.vrPlayer.vrdata_world_pre.rotation_radians;
        Vec3 camPos = this.dh.vrPlayer.vrdata_room_pre.getHeadPivot();
        this.Premount_Pos_Room = new Vec3(camPos.x, 0.0, camPos.z);
        this.dismountCooldown = 5;
        if (this.dh.vrSettings.vehicleRotation) {
            float end = this.dh.vrPlayer.vrdata_world_pre.hmd.getYaw();
            float start = vehicle.getYRot() % 360.0f;
            this.vehicleInitialRotation = this.dh.vrSettings.worldRotation;
            this.rotationCooldown = 2;
            if (vehicle instanceof Minecart) {
                return;
            }
            float difference = this.dh.vrPlayer.rotDiff_Degrees(start, end);
            this.dh.vrSettings.worldRotation = (float)(Math.toDegrees(this.dh.vrPlayer.vrdata_world_pre.rotation_radians) + (double)difference);
            this.dh.vrSettings.worldRotation %= 360.0f;
            this.dh.vr.seatedRot = this.dh.vrSettings.worldRotation;
        }
    }

    public void onStopRiding() {
        this.isRiding = false;
        this.dh.swingTracker.disableSwing = 10;
        this.dh.sneakTracker.sneakCounter = 0;
    }

    public boolean isRiding() {
        return this.isRiding;
    }

    public void updateRiderPos(double x, double y, double z, Entity entity) {
        Vec3 offset = this.Premount_Pos_Room.yRot(this.dh.vrPlayer.vrdata_world_pre.rotation_radians);
        y = this.getVehicleFloor(entity, y);
        this.dh.vrPlayer.setRoomOrigin(x, y, z, (x -= offset.x) + y + (z -= offset.z) == 0.0);
    }

    private float getMinecartRenderYaw(Minecart entity) {
        Vec3 speed = new Vec3(entity.getX() - entity.xOld, entity.getY() - entity.yOld, entity.getZ() - entity.zOld);
        float speedYaw = (float)Math.toDegrees(Math.atan2(-speed.x, speed.z));
        return this.shouldMinecartTurnView(entity) ? -180.0f + speedYaw : this.vehicleInitialRotation;
    }

    private double mineCartSpeed(Minecart entity) {
        Vec3 speed = new Vec3(entity.getDeltaMovement().x, 0.0, entity.getDeltaMovement().z);
        return speed.length();
    }

    private boolean shouldMinecartTurnView(Minecart entity) {
        Vec3 speed = new Vec3(entity.getX() - entity.xOld, entity.getY() - entity.yOld, entity.getZ() - entity.zOld);
        return speed.length() > 0.001;
    }

    public boolean canRoomscaleDismount(LocalPlayer player) {
        return player.zza == 0.0f && player.xxa == 0.0f && player.isPassenger() && player.getVehicle().onGround() && this.dismountCooldown == 0;
    }
}

