/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.provider.openvr_lwjgl.control;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.provider.openvr_lwjgl.MCOpenVR;

public class HapticMusicPlayer {
    private static final Map<String, Music> MAP = new HashMap<String, Music>();

    private HapticMusicPlayer() {
    }

    public static Music newMusic(String name) {
        Music music = new Music(name);
        MAP.put(name, music);
        return music;
    }

    public static boolean hasMusic(String name) {
        return MAP.containsKey(name);
    }

    public static Music getMusic(String name) {
        return MAP.get(name);
    }

    public static void removeMusic(String name) {
        MAP.remove(name);
    }

    public static class Music {
        final String name;
        private final List<Object> data = new LinkedList<Object>();

        private Music(String name) {
            this.name = name;
        }

        public Music addNote(@Nullable ControllerType controller, float durationSeconds, float frequency, float amplitude) {
            this.data.add(new Note(controller, durationSeconds, frequency, amplitude));
            return this;
        }

        public Music addDelay(float durationSeconds) {
            this.data.add(new Delay(durationSeconds));
            return this;
        }

        public void clearData() {
            this.data.clear();
        }

        public void play() {
            float delayAccum = 0.0f;
            for (Object object : this.data) {
                if (object instanceof Note) {
                    Note note = (Note)object;
                    if (note.controller != null) {
                        MCOpenVR.get().triggerHapticPulse(note.controller, note.durationSeconds, note.frequency, note.amplitude, delayAccum);
                        continue;
                    }
                    MCOpenVR.get().triggerHapticPulse(ControllerType.RIGHT, note.durationSeconds, note.frequency, note.amplitude, delayAccum);
                    MCOpenVR.get().triggerHapticPulse(ControllerType.LEFT, note.durationSeconds, note.frequency, note.amplitude, delayAccum);
                    continue;
                }
                if (!(object instanceof Delay)) continue;
                Delay delay = (Delay)object;
                delayAccum += delay.durationSeconds;
            }
        }

        private record Note(ControllerType controller, float durationSeconds, float frequency, float amplitude) {
        }

        private record Delay(float durationSeconds) {
        }
    }

    public class MusicBuilder {
        private Music music;
        private float tempo;

        public MusicBuilder(HapticMusicPlayer this$0) {
        }
    }
}

