/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import org.vivecraft.Xloader;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.settings.VRSettings;

public class TooltipUtil {
    public static String getClientConfigTooltip(VRSettings.VrOptions option) {
        Language lang = Language.getInstance();
        Object tooltip = "";
        String tooltipString = "vivecraft.options." + option.name() + ".tooltip";
        String tooltipDisabledString = "vivecraft.options." + option.name() + ".disabled.tooltip";
        if (lang.has(tooltipString)) {
            tooltip = lang.getOrDefault(tooltipString);
        }
        if (!option.isChangeable()) {
            tooltip = lang.getOrDefault(tooltipDisabledString) + "\n" + (String)tooltip;
        }
        if (ClientDataHolderVR.getInstance().vrSettings.overrides.hasSetting(option)) {
            VRSettings.ServerOverrides.Setting setting = ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(option);
            if (setting.isValueOverridden()) {
                tooltip = lang.getOrDefault("vivecraft.message.overriddenbyserver") + (String)tooltip;
            } else if (setting.isFloat() && (setting.isValueMinOverridden() || setting.isValueMaxOverridden())) {
                tooltip = lang.getOrDefault("vivecraft.message.limitedbyserver").formatted(Float.valueOf(setting.getValueMin()), Float.valueOf(setting.getValueMax())) + (String)tooltip;
            }
        }
        return tooltip;
    }

    public static String getServerConfigTooltip(String serverConfigPath, boolean addAllTooltip) {
        Language lang = Language.getInstance();
        Object tooltip = "";
        String configString = "vivecraft.serverSettings." + serverConfigPath;
        String tooltipString = configString + ".tooltip";
        if (lang.has(tooltipString)) {
            tooltip = lang.getOrDefault(tooltipString);
        } else if (lang.has(configString)) {
            tooltip = lang.getOrDefault(configString);
        }
        if (addAllTooltip) {
            String selfAllTooltip = "vivecraft.serverSettings." + serverConfigPath + ".tooltipall";
            if (lang.has(selfAllTooltip)) {
                tooltip = (String)tooltip + "\n" + lang.getOrDefault(selfAllTooltip);
            } else {
                String parent = serverConfigPath.substring(0, Math.max(serverConfigPath.lastIndexOf(46), 0));
                String parentAllTooltip = "vivecraft.serverSettings." + parent + ".tooltipall";
                if (lang.has(parentAllTooltip)) {
                    tooltip = (String)tooltip + "\n" + lang.getOrDefault(parentAllTooltip);
                }
            }
        }
        if (!Xloader.isDedicatedServer()) {
            tooltip = (String)tooltip + TooltipUtil.getClientOnlyTooltip();
        }
        return tooltip;
    }

    private static String getClientOnlyTooltip() {
        if (Minecraft.getInstance().level != null && !Minecraft.getInstance().isLocalServer()) {
            return "\n" + Language.getInstance().getOrDefault("vivecraft.messages.serversettingsnotavailablesingle");
        }
        return "";
    }
}

