/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.screens;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.vivecraft.client.gui.framework.screens.GuiListEditorScreen;

public abstract class GuiOrderedListEditorScreen<T>
extends GuiListEditorScreen<T> {
    public GuiOrderedListEditorScreen(Component title, Screen lastScreen, boolean fixedEntryCount, Supplier<List<T>> valuesSupplier, Runnable loadDefaults, Consumer<List<T>> save) {
        super(title, lastScreen, fixedEntryCount, valuesSupplier, loadDefaults, save);
        this.searchable = false;
    }

    private void moveEntry(int from, int offset, boolean remove) {
        Object value = this.elements.get(from);
        this.elements.remove(from);
        if (!remove) {
            this.elements.add(Math.clamp((long)(from + offset), 0, this.elements.size()), value);
        }
        this.reinit = true;
    }

    protected class OrderedEntry<T>
    extends GuiListEditorScreen.ValueEntry<T> {
        protected final T value;
        private final int index;
        private final Button upButton;
        private final Button downButton;
        private final Button removeButton;

        public OrderedEntry(Component name, T value, int index) {
            super(name, null);
            this.value = value;
            this.index = index;
            this.upButton = Button.builder((Component)Component.literal((String)"\u2191"), button -> GuiOrderedListEditorScreen.this.moveEntry(index, -1, false)).bounds(0, 0, 20, 20).build();
            this.downButton = Button.builder((Component)Component.literal((String)"\u2193"), button -> GuiOrderedListEditorScreen.this.moveEntry(index, 1, false)).bounds(0, 0, 20, 20).build();
            this.removeButton = Button.builder((Component)Component.literal((String)"-"), button -> GuiOrderedListEditorScreen.this.moveEntry(index, 0, true)).bounds(0, 0, 20, 20).build();
        }

        @Override
        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            super.renderContent(guiGraphics, mouseX, mouseY, hovering, partialTick);
            int n = this.getY() + this.getHeight() / 2;
            Objects.requireNonNull(Minecraft.getInstance().font);
            int textY = n - 9 / 2 + 2;
            guiGraphics.drawString(Minecraft.getInstance().font, this.name, this.getContentX(), textY, this.textColor());
            this.upButton.active = this.isActive() && this.index != 0;
            this.downButton.active = this.isActive() && this.index != GuiOrderedListEditorScreen.this.elements.size() - 1;
            this.removeButton.active = this.isActive();
            int i = 0;
            for (GuiEventListener child : this.children()) {
                Button b = (Button)child;
                b.setX(this.getContentRight() - (2 - i) * 22 - 20);
                b.setY(this.getContentY());
                b.render(guiGraphics, mouseX, mouseY, partialTick);
                ++i;
            }
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.upButton, (Object)this.downButton, (Object)this.removeButton);
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.upButton, (Object)this.downButton, (Object)this.removeButton);
        }

        @Override
        public void setActive(boolean active) {
            super.setActive(active);
            this.upButton.active = active;
            this.downButton.active = active;
            this.removeButton.active = active;
        }

        @Override
        public T getValue() {
            return this.value;
        }
    }
}

