/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.widgets;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.input.InputWithModifiers;
import org.vivecraft.client.gui.framework.widgets.ColoredButton;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gui.keyboard.KeyboardKeys;
import org.vivecraft.client_vr.gui.keyboard.KeyboardTheme;

public class ColoredKeyButton
extends ColoredButton {
    private final KeyboardKeys.Key key;
    private final ClientDataHolderVR dh;
    private final KeyboardTheme keyboardTheme;

    public ColoredKeyButton(KeyboardKeys.Key key, int x, int y, int width, int height) {
        this(key, x, y, width, height, null, null);
    }

    public ColoredKeyButton(KeyboardKeys.Key key, int x, int y, int width, int height, Button.OnPress onPress, KeyboardTheme keyboardTheme) {
        super(key.label(), x, y, width, height, onPress);
        this.key = key;
        this.dh = ClientDataHolderVR.getInstance();
        this.keyboardTheme = keyboardTheme;
    }

    public void onPress(InputWithModifiers input) {
        if (this.onPress != null) {
            super.onPress(input);
        } else {
            this.key.onPress().run();
            this.key.onRelease().run();
        }
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        KeyboardTheme theme = this.keyboardTheme != null ? this.keyboardTheme : this.dh.vrSettings.physicalKeyboardTheme;
        theme.theme.updateColor(this.getColor(), this.key.id(), this.key.x(), this.key.y());
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
    }
}

