/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.settings;

import java.lang.invoke.LambdaMetafactory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.network.chat.Component;
import org.vivecraft.client.gui.settings.GuiActiveKeyboardLayoutSelector;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gui.keyboard.KeyboardKeys;
import org.vivecraft.client_vr.settings.VRSettings;

public class GuiKeyboardLayoutEditor
extends Screen {
    private final Screen parent;
    private boolean isShift = false;
    private boolean reinit = false;

    protected GuiKeyboardLayoutEditor(Screen parent) {
        super((Component)Component.translatable((String)"vivecraft.options.screen.customkeyboardeditor"));
        this.parent = parent;
    }

    public void init() {
        int y;
        ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
        this.clearWidgets();
        KeyboardKeys.Layout layout = KeyboardKeys.getRegularKeys(dh.vrSettings.keyboardLayouts.get("custom"), this.isShift, () -> {});
        int spacing = 2;
        int buttonWidth = (int)(25.0f * Math.min((float)this.width / ((25.0f + (float)spacing) * ((float)layout.columns() + 5.0f)), 1.0f));
        int yMargin = 32 + this.height / 2 - (int)(((float)layout.rows() + 3.0f) / 2.0f * (float)(20 + spacing));
        int xMargin = this.width / 2 - (buttonWidth + spacing) * (layout.columns() + 5) / 2;
        for (KeyboardKeys.Key key : layout.keys()) {
            y = key.y() < 0 ? layout.rows() - key.y() : key.y();
            EditBox box = new EditBox(this, this.font, xMargin + key.x() * (buttonWidth + spacing), yMargin + (y - 1) * (20 + spacing), buttonWidth, 20, (Component)Component.empty()){

                public boolean charTyped(CharacterEvent event) {
                    this.setValue("");
                    return super.charTyped(event);
                }
            };
            box.setValue(key.label().getString());
            box.setMaxLength(1);
            box.setCentered(true);
            box.setResponder(s -> {
                char newChar;
                char c = newChar = s.isEmpty() ? (char)'\u0000' : s.charAt(0);
                if (this.isShift) {
                    char[] array = dh.vrSettings.keyboardKeysShift.toCharArray();
                    array[key.id() - 500] = newChar;
                    dh.vrSettings.keyboardKeysShift = new String(array);
                } else {
                    char[] array = dh.vrSettings.keyboardKeys.toCharArray();
                    array[key.id()] = newChar;
                    dh.vrSettings.keyboardKeys = new String(array);
                }
                dh.vrSettings.saveOptions();
                KeyboardHandler.reinitKeyboard();
            });
            this.addRenderableWidget((GuiEventListener)box);
        }
        for (KeyboardKeys.Key key : KeyboardKeys.getSpecialKeys()) {
            if (key.id() == KeyboardKeys.SHIFT_2.id()) continue;
            y = key.y() < 0 ? layout.rows() - key.y() : key.y();
            ((Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)key.label(), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$2(org.vivecraft.client_vr.gui.keyboard.KeyboardKeys$Key net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((GuiKeyboardLayoutEditor)this, (KeyboardKeys.Key)key)).size((int)(key.width() * buttonWidth + (key.width() - 1) * spacing), (int)20).pos((int)(xMargin + key.x() * (buttonWidth + spacing)), (int)(yMargin + (y - 1) * (20 + spacing))).build())).active = key.id() == KeyboardKeys.SHIFT_1.id();
        }
        ((Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"+"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$3(org.vivecraft.client_vr.ClientDataHolderVR org.vivecraft.client_vr.gui.keyboard.KeyboardKeys$Layout net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((GuiKeyboardLayoutEditor)this, (ClientDataHolderVR)dh, (KeyboardKeys.Layout)layout)).size((int)buttonWidth, (int)20).pos((int)((layout.columns() + 2) * (buttonWidth + spacing) + xMargin), (int)(yMargin + 3 * (20 + spacing))).tooltip((Tooltip)Tooltip.create((Component)Component.translatable((String)"vivecraft.options.screen.addkeyboardrow.tooltip"))).build())).active = layout.rows() < 7;
        ((Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"-"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$4(org.vivecraft.client_vr.ClientDataHolderVR org.vivecraft.client_vr.gui.keyboard.KeyboardKeys$Layout net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((GuiKeyboardLayoutEditor)this, (ClientDataHolderVR)dh, (KeyboardKeys.Layout)layout)).size((int)buttonWidth, (int)20).pos((int)((layout.columns() + 3) * (buttonWidth + spacing) + xMargin), (int)(yMargin + 3 * (20 + spacing))).tooltip((Tooltip)Tooltip.create((Component)Component.translatable((String)"vivecraft.options.screen.removekeyboardrow.tooltip"))).build())).active = layout.rows() > 4;
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"vivecraft.options.screen.loadkeyboardlayout.button"), button -> this.minecraft.setScreen(GuiActiveKeyboardLayoutSelector.getSelectionScreen(this, keyboard -> !keyboard.id().equals("custom"), keyboard -> {
            VRSettings.KeyboardLayout newLayout = keyboard == null ? dh.vrSettings.keyboardLayouts.get("en_us") : keyboard;
            dh.vrSettings.keyboardKeys = newLayout.regular().get();
            dh.vrSettings.keyboardKeysShift = newLayout.shift().get();
            dh.vrSettings.saveOptions();
            this.reinit = true;
            this.isShift = false;
            KeyboardHandler.reinitKeyboard();
        }, true))).bounds(this.width / 2 - 155, this.height - 30, 150, 20).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"gui.back"), p -> this.onClose()).bounds(this.width / 2 + 5, this.height - 30, 150, 20).build());
    }

    private void setShift(boolean shift) {
        if (shift != this.isShift) {
            this.isShift = shift;
            this.reinit = true;
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.reinit) {
            this.init();
            this.reinit = false;
        }
        guiGraphics.drawCenteredString(this.font, this.getTitle(), this.width / 2, 15, -1);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    private /* synthetic */ void lambda$init$4(ClientDataHolderVR dh, KeyboardKeys.Layout layout, Button p) {
        if (this.isShift) {
            dh.vrSettings.keyboardKeysShift = dh.vrSettings.keyboardKeysShift.substring(0, dh.vrSettings.keyboardKeysShift.length() - layout.columns());
        } else {
            dh.vrSettings.keyboardKeys = dh.vrSettings.keyboardKeys.substring(0, dh.vrSettings.keyboardKeys.length() - layout.columns());
        }
        dh.vrSettings.saveOptions();
        this.reinit = true;
        KeyboardHandler.reinitKeyboard();
    }

    private /* synthetic */ void lambda$init$3(ClientDataHolderVR dh, KeyboardKeys.Layout layout, Button p) {
        if (this.isShift) {
            dh.vrSettings.keyboardKeysShift = dh.vrSettings.keyboardKeysShift + "\u0000".repeat(layout.columns());
        } else {
            dh.vrSettings.keyboardKeys = dh.vrSettings.keyboardKeys + "\u0000".repeat(layout.columns());
        }
        dh.vrSettings.saveOptions();
        this.reinit = true;
        KeyboardHandler.reinitKeyboard();
    }

    private /* synthetic */ void lambda$init$2(KeyboardKeys.Key key, Button p) {
        if (key.isShift()) {
            this.setShift(!this.isShift);
        }
    }
}

