/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.utils;

import com.mojang.blaze3d.pipeline.RenderTarget;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.extensions.MinecraftExtension;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.settings.VRSettings;

public class ClientUtils {
    private static final Minecraft MC = Minecraft.getInstance();
    private static final ClientDataHolderVR DH = ClientDataHolderVR.getInstance();
    private static final Random AV_RANDOMIZER = new Random();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readWinRegistry(String key) {
        try {
            Process process = Runtime.getRuntime().exec("reg query \"" + key.substring(0, key.lastIndexOf(92)) + "\" /v \"" + key.substring(key.lastIndexOf(92) + 1) + "\"");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = reader.readLine();
                while (line != null) {
                    String[] split = line.split("REG_SZ|REG_DWORD");
                    if (split.length > 1) {
                        String string = split[1].trim();
                        return string;
                    }
                    line = reader.readLine();
                }
                return null;
            }
        }
        catch (Exception e) {
            VRSettings.LOGGER.error("Vivecraft: error reading registry key: ", (Throwable)e);
        }
        return null;
    }

    public static void spawnParticles(ParticleOptions type, int count, Vec3 position, Vec3 size, double speed) {
        Minecraft minecraft = Minecraft.getInstance();
        for (int k = 0; k < count; ++k) {
            double offX = AV_RANDOMIZER.nextGaussian() * size.x;
            double offY = AV_RANDOMIZER.nextGaussian() * size.y;
            double offZ = AV_RANDOMIZER.nextGaussian() * size.z;
            double dirX = AV_RANDOMIZER.nextGaussian() * speed;
            double dirY = AV_RANDOMIZER.nextGaussian() * speed;
            double dirZ = AV_RANDOMIZER.nextGaussian() * speed;
            try {
                minecraft.level.addParticle(type, position.x + offX, position.y + offY, position.z + offZ, dirX, dirY, dirZ);
                continue;
            }
            catch (Throwable throwable) {
                VRSettings.LOGGER.warn("Vivecraft: Could not spawn particle effect {}", (Object)type);
                return;
            }
        }
    }

    public static int getCombinedLightWithMin(BlockAndTintGetter lightReader, BlockPos pos, int minLight) {
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)lightReader, (BlockPos)pos);
        int blockLight = light >> 4 & 0xF;
        if (blockLight < minLight) {
            light &= 0xFFFFFF00;
            light |= minLight << 4;
        }
        return light;
    }

    public static void takeScreenshot(RenderTarget fb) {
        Minecraft minecraft = Minecraft.getInstance();
        Screenshot.grab((File)minecraft.gameDirectory, (RenderTarget)fb, text -> minecraft.execute(() -> ClientUtils.addChatMessage(text)));
    }

    public static float getCurrentPartialTick() {
        return ((MinecraftExtension)MC).vivecraft$getPartialTick();
    }

    public static <T extends Enum<T>> T getNextEnum(T current, int offset) {
        Enum[] values = (Enum[])current.getClass().getEnumConstants();
        int index = (current.ordinal() + offset + values.length) % values.length;
        return (T)values[index];
    }

    public static long microTime() {
        return System.nanoTime() / 1000L;
    }

    public static long milliTime() {
        return System.nanoTime() / 1000000L;
    }

    public static Component getNameFromSoundEvent(ResourceLocation soundLocation) {
        String jukebox;
        String key = soundLocation.getPath();
        if (I18n.exists((String)key)) {
            return Component.translatable((String)key);
        }
        if (I18n.exists((String)("subtitles." + key))) {
            return Component.translatable((String)("subtitles." + key));
        }
        if (key.startsWith("music_disc.") && I18n.exists((String)(jukebox = key.replace("music_disc.", "jukebox_song.minecraft.")))) {
            return Component.translatable((String)jukebox);
        }
        return Component.literal((String)key);
    }

    public static void addChatMessage(Component message) {
        if (ClientUtils.MC.gui != null) {
            ClientUtils.MC.gui.getChat().addMessage(message);
        }
        if (VRState.VR_RUNNING) {
            ClientUtils.triggerChatHapticSound();
        }
    }

    public static void triggerChatHapticSound() {
        if (ClientUtils.DH.vrSettings.chatNotifications != VRSettings.ChatNotifications.NONE) {
            if (!(ClientUtils.DH.vrSettings.seated || ClientUtils.DH.vrSettings.chatNotifications != VRSettings.ChatNotifications.HAPTIC && ClientUtils.DH.vrSettings.chatNotifications != VRSettings.ChatNotifications.BOTH)) {
                ClientUtils.DH.vr.triggerHapticPulse(ControllerType.LEFT, 0.2f, 1000.0f, 1.0f);
            }
            if (ClientUtils.DH.vrSettings.chatNotifications == VRSettings.ChatNotifications.SOUND || ClientUtils.DH.vrSettings.chatNotifications == VRSettings.ChatNotifications.BOTH) {
                Vec3 controllerPos = ClientUtils.DH.vrPlayer.vrdata_world_pre.getController(1).getPosition();
                BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)ClientUtils.DH.vrSettings.chatNotificationSound)).ifPresent(soundEvent -> {
                    if (ClientUtils.MC.level != null) {
                        ClientUtils.MC.level.playLocalSound(controllerPos.x(), controllerPos.y(), controllerPos.z(), (SoundEvent)soundEvent.value(), SoundSource.NEUTRAL, 0.3f, 0.1f, false);
                    } else {
                        MC.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)soundEvent.value()), (float)0.1f, (float)0.3f));
                    }
                });
            }
        }
    }
}

