/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.WindChargeItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.api_impl.VRClientAPIImpl;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client.utils.ScaleHelper;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.MethodHolder;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.gameplay.trackers.VehicleTracker;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.VRServerPerms;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.data.ViveItemTags;

public class VRPlayer {
    private final Minecraft mc = Minecraft.getInstance();
    private final ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
    public VRData vrdata_room_pre;
    public VRData vrdata_world_pre;
    public VRData vrdata_room_post;
    public VRData vrdata_world_post;
    public VRData vrdata_world_render;
    public float worldScale;
    private float rawWorldScale;
    private boolean teleportOverride;
    public Vec3 roomOrigin;
    private boolean isFreeMoveCurrent;
    public double wfMode;
    public int wfCount;
    public int roomScaleMovementDelay;
    private boolean initDone;
    public boolean onTick;

    public VRPlayer() {
        this.worldScale = this.dh.vrSettings.overrides.getSetting(VRSettings.VrOptions.WORLD_SCALE).getFloat();
        this.rawWorldScale = this.dh.vrSettings.overrides.getSetting(VRSettings.VrOptions.WORLD_SCALE).getFloat();
        this.teleportOverride = false;
        this.roomOrigin = Vec3.ZERO;
        this.isFreeMoveCurrent = true;
        this.wfMode = 0.0;
        this.wfCount = 0;
        this.roomScaleMovementDelay = 0;
        this.initDone = false;
        this.vrdata_room_pre = new VRData(Vec3.ZERO, this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
        this.vrdata_room_post = new VRData(Vec3.ZERO, this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
        this.vrdata_world_post = new VRData(Vec3.ZERO, this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
        this.vrdata_world_pre = new VRData(Vec3.ZERO, this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
    }

    public VRData getVRDataWorld() {
        return this.vrdata_world_render != null ? this.vrdata_world_render : this.vrdata_world_pre;
    }

    public static VRPlayer get() {
        return ClientDataHolderVR.getInstance().vrPlayer;
    }

    public static Vec3 roomToWorldPos(Vector3fc pos, VRData data) {
        Vector3f out = pos.mul(data.worldScale, new Vector3f());
        out = out.rotateY(data.rotation_radians);
        return data.origin.add((double)out.x, (double)out.y, (double)out.z);
    }

    public static Vector3f worldToRoomPos(Vec3 pos, VRData data) {
        Vector3f out = MathUtils.subtractToVector3f(pos, data.origin);
        out = out.div(data.worldScale);
        return out.rotateY(-data.rotation_radians);
    }

    public void postPoll() {
        this.vrdata_room_pre = new VRData(Vec3.ZERO, this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
        GuiHandler.processGui();
        KeyboardHandler.processGui();
        RadialHandler.processGui();
    }

    public void preTick() {
        this.onTick = true;
        this.vrdata_world_pre = new VRData(this.roomOrigin, this.dh.vrSettings.walkMultiplier, this.worldScale, (float)Math.PI / 180 * this.dh.vrSettings.worldRotation);
        VRSettings.ServerOverrides.Setting worldScaleOverride = this.dh.vrSettings.overrides.getSetting(VRSettings.VrOptions.WORLD_SCALE);
        float scaleSetting = worldScaleOverride.getFloat();
        if (MethodHolder.isInMenuRoom()) {
            this.worldScale = 1.0f;
        } else {
            if (this.wfCount > 0 && !this.mc.isPaused()) {
                if (this.wfCount < 40) {
                    this.rawWorldScale = (float)((double)this.rawWorldScale - this.wfMode);
                    if (this.wfMode > 0.0) {
                        if (this.rawWorldScale < scaleSetting) {
                            this.rawWorldScale = scaleSetting;
                        }
                    } else if (this.wfMode < 0.0 && this.rawWorldScale > scaleSetting) {
                        this.rawWorldScale = scaleSetting;
                    }
                } else {
                    this.rawWorldScale = (float)((double)this.rawWorldScale + this.wfMode);
                    if (this.wfMode > 0.0) {
                        if (this.rawWorldScale > Mth.clamp((float)20.0f, (float)worldScaleOverride.getValueMin(), (float)worldScaleOverride.getValueMax())) {
                            this.rawWorldScale = Mth.clamp((float)20.0f, (float)worldScaleOverride.getValueMin(), (float)worldScaleOverride.getValueMax());
                        }
                    } else if (this.wfMode < 0.0 && this.rawWorldScale < Mth.clamp((float)0.1f, (float)worldScaleOverride.getValueMin(), (float)worldScaleOverride.getValueMax())) {
                        this.rawWorldScale = Mth.clamp((float)0.1f, (float)worldScaleOverride.getValueMin(), (float)worldScaleOverride.getValueMax());
                    }
                }
                --this.wfCount;
            } else {
                this.rawWorldScale = scaleSetting;
            }
            this.worldScale = this.rawWorldScale;
            this.worldScale *= ScaleHelper.getEntityEyeHeightScale((LivingEntity)this.mc.player, ClientUtils.getCurrentPartialTick());
            this.worldScale = Mth.clamp((float)this.worldScale, (float)0.025f, (float)100.0f);
            if (this.mc.level != null && this.mc.isLocalServer() && (worldScaleOverride.isValueMinOverridden() || worldScaleOverride.isValueMaxOverridden())) {
                float measuredIPD = this.dh.vr.getEyePosition(RenderPass.LEFT).sub((Vector3fc)this.dh.vr.getEyePosition(RenderPass.RIGHT)).length();
                float queriedIPD = this.dh.vr.getIPD();
                float runtimeWorldScale = queriedIPD / measuredIPD;
                float actualWorldScale = this.rawWorldScale * runtimeWorldScale;
                if (actualWorldScale < worldScaleOverride.getValueMin() * 0.99f || actualWorldScale > worldScaleOverride.getValueMax() * 1.01f) {
                    VRSettings.LOGGER.info("Vivecraft: disconnected user from server. runtime IPD: {}, measured IPD: {}, runtime worldscale: {}", new Object[]{Float.valueOf(queriedIPD), Float.valueOf(measuredIPD), Float.valueOf(runtimeWorldScale)});
                    this.mc.level.disconnect();
                    this.mc.disconnect((Screen)new DisconnectedScreen((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()), (Component)Component.translatable((String)"vivecraft.message.worldscaleOutOfRange.title"), (Component)Component.translatable((String)"vivecraft.message.worldscaleOutOfRange", (Object[])new Object[]{Component.literal((String)"%.2fx".formatted(Float.valueOf(worldScaleOverride.getValueMin()))).withStyle(style -> style.withColor(ChatFormatting.GREEN)), Component.literal((String)"%.2fx".formatted(Float.valueOf(worldScaleOverride.getValueMax()))).withStyle(style -> style.withColor(ChatFormatting.GREEN)), Component.literal((String)this.dh.vr.getRuntimeName()).withStyle(style -> style.withColor(ChatFormatting.GOLD))})));
                }
            }
        }
        if (this.dh.vrSettings.seated && !MethodHolder.isInMenuRoom()) {
            this.dh.vrSettings.worldRotation = this.dh.vr.seatedRot;
        }
        if (!(this.mc.level == null || this.mc.getSingleplayerServer() != null && this.mc.getSingleplayerServer().isPaused())) {
            VRClientAPIImpl.INSTANCE.addPoseToHistory(this.vrdata_world_pre.asVRPose());
        }
    }

    public void postTick() {
        Vector3f scaleOffset = this.vrdata_world_pre.hmd.getScalePositionOffset(this.worldScale);
        this.roomOrigin = this.roomOrigin.subtract((double)scaleOffset.x, (double)scaleOffset.y, (double)scaleOffset.z);
        float end = this.dh.vrSettings.worldRotation;
        float start = 57.295776f * this.vrdata_world_pre.rotation_radians;
        this.rotateOriginAround(-end + start, this.vrdata_world_pre.getNewHeadPivot(this.roomOrigin, this.worldScale));
        this.vrdata_room_post = new VRData(Vec3.ZERO, this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
        this.vrdata_world_post = new VRData(this.roomOrigin, this.dh.vrSettings.walkMultiplier, this.worldScale, (float)Math.PI / 180 * this.dh.vrSettings.worldRotation);
        this.doPermanentLookOverride(this.mc.player, this.vrdata_world_post);
        ClientNetworking.sendVRPlayerPositions(this);
        this.onTick = false;
    }

    public void preRender(float partialTick) {
        float interpolatedWorldScale = Mth.lerp((float)partialTick, (float)this.vrdata_world_pre.worldScale, (float)this.vrdata_world_post.worldScale);
        float end = this.vrdata_world_post.rotation_radians;
        float start = this.vrdata_world_pre.rotation_radians;
        float difference = Math.abs(end - start);
        if (difference > (float)Math.PI) {
            if (end > start) {
                start += (float)Math.PI * 2;
            } else {
                end += (float)Math.PI * 2;
            }
        }
        float interpolatedWorldRotation_Radians = Mth.lerp((float)partialTick, (float)start, (float)end);
        Vec3 interpolatedRoomOrigin = MathUtils.vecDLerp(this.vrdata_world_pre.origin, this.vrdata_world_post.origin, partialTick);
        this.vrdata_world_render = new VRData(interpolatedRoomOrigin, this.dh.vrSettings.walkMultiplier, interpolatedWorldScale, interpolatedWorldRotation_Radians);
        for (Tracker tracker : ClientDataHolderVR.getInstance().getTrackers()) {
            if (tracker.processType() != Tracker.ProcessType.PER_FRAME) continue;
            tracker.idleProcess(this.mc.player);
            if (tracker.isActive(this.mc.player)) {
                tracker.activeProcess(this.mc.player);
                continue;
            }
            tracker.inactiveProcess(this.mc.player);
        }
        this.dh.menuHandOff = MethodHolder.isInMenuRoom() || this.mc.screen != null || KeyboardHandler.SHOWING;
        this.dh.menuHandMain = this.dh.menuHandOff || this.dh.hotbarModule.hotbar >= 0 && this.dh.vrSettings.vrTouchHotbar;
    }

    public void postRender(float partialTick) {
    }

    public void setRoomOrigin(double x, double y, double z, boolean reset) {
        if (reset && this.vrdata_world_pre != null) {
            this.vrdata_world_pre.origin = new Vec3(x, y, z);
        }
        this.roomOrigin = new Vec3(x, y, z);
    }

    public void snapRoomOriginToPlayerEntity(Entity entity, boolean reset, boolean instant) {
        if (Thread.currentThread().getName().equals("Server thread") || entity == null || entity.position() == Vec3.ZERO || this.dh.sneakTracker.sneakCounter > 0) {
            return;
        }
        Vec3 camPos = instant ? this.vrdata_world_pre.getNewHeadPivot(this.roomOrigin, this.worldScale).subtract(this.roomOrigin) : this.vrdata_world_pre.getHeadPivot().subtract(this.vrdata_world_pre.origin);
        double x = entity.getX() - camPos.x;
        double y = entity.getY();
        double z = entity.getZ() - camPos.z;
        if (entity instanceof PlayerExtension) {
            PlayerExtension extension = (PlayerExtension)entity;
            y += extension.vivecraft$getRoomYOffsetFromPose();
        }
        this.setRoomOrigin(x, y, z, reset);
    }

    public float rotDiff_Degrees(float start, float end) {
        double x = Math.toRadians(end);
        double y = Math.toRadians(start);
        return (float)Math.toDegrees(Math.atan2(Math.sin(x - y), Math.cos(x - y)));
    }

    public void rotateOriginAround(float degrees, Vec3 origin) {
        Vec3 point = this.roomOrigin;
        float rads = (float)Math.PI / 180 * degrees;
        if (rads != 0.0f) {
            this.setRoomOrigin((double)Mth.cos((float)rads) * (point.x - origin.x) - (double)Mth.sin((float)rads) * (point.z - origin.z) + origin.x, point.y, (double)Mth.sin((float)rads) * (point.x - origin.x) + (double)Mth.cos((float)rads) * (point.z - origin.z) + origin.z, false);
        }
    }

    public void tick(LocalPlayer player) {
        if (!((PlayerExtension)player).vivecraft$getInitFromServer()) {
            return;
        }
        if (!this.initDone) {
            VRSettings.LOGGER.info("Vivecraft: <Debug info start>\nRoom object: {}\nRoom origin: {}\nHmd position room: {}\nHmd position world: {}\nHmd Projection Left: {}\nHmd Projection Right: {}\n<Debug info end>\n", new Object[]{this, this.vrdata_world_pre.origin, this.vrdata_room_pre.hmd.getPosition(), this.vrdata_world_pre.hmd.getPosition(), this.dh.vrRenderer.eyeProj[0], this.dh.vrRenderer.eyeProj[1]});
            this.initDone = true;
        }
        this.doPlayerMoveInRoom(player);
        for (Tracker tracker : this.dh.getTrackers()) {
            if (tracker.processType() != Tracker.ProcessType.PER_TICK) continue;
            tracker.idleProcess(player);
            if (tracker.isActive(player)) {
                tracker.activeProcess(player);
                continue;
            }
            tracker.inactiveProcess(player);
        }
        if (player.isPassenger()) {
            Mob mob;
            Entity entity = player.getVehicle();
            if (entity instanceof AbstractHorse) {
                AbstractHorse abstracthorse = (AbstractHorse)entity;
                if (abstracthorse.isControlledByLocalInstance() && abstracthorse.isSaddled() && !this.dh.horseTracker.isActive(player)) {
                    abstracthorse.yBodyRot = this.vrdata_world_pre.getBodyYaw();
                    this.dh.vehicleTracker.rotationCooldown = 10;
                }
            } else if (entity instanceof Mob && (mob = (Mob)entity).isControlledByLocalInstance()) {
                mob.yBodyRot = this.vrdata_world_pre.getBodyYaw();
                this.dh.vehicleTracker.rotationCooldown = 10;
            }
        }
    }

    public void doPlayerMoveInRoom(LocalPlayer player) {
        float climbShrink;
        double shrunkClimbHalfWidth;
        AABB bbClimb;
        if (this.roomScaleMovementDelay > 0) {
            --this.roomScaleMovementDelay;
            return;
        }
        if (player == null || player.isShiftKeyDown() || player.isSleeping() || this.dh.jumpTracker.isjumping() || this.dh.climbTracker.isGrabbingLadder() || !player.isAlive() || this.dh.vehicleTracker.isRiding()) {
            return;
        }
        Vec3 newHeadPivot = this.vrdata_world_pre.getNewHeadPivot(this.roomOrigin, this.worldScale);
        if (this.dh.vrSettings.realisticDismountEnabled && this.dh.vehicleTracker.canRoomscaleDismount(player)) {
            Vec3 mountPos = player.getVehicle().position();
            double distance = Math.sqrt((newHeadPivot.x - mountPos.x) * (newHeadPivot.x - mountPos.x) + (newHeadPivot.z - mountPos.z) * (newHeadPivot.z - mountPos.z));
            if (distance > 1.0) {
                this.dh.sneakTracker.sneakCounter = 5;
            }
            return;
        }
        float playerHalfWidth = player.getBbWidth() / 2.0f;
        float playerHeight = player.getBbHeight();
        double x = newHeadPivot.x;
        double y = player.getY();
        double z = newHeadPivot.z;
        AABB bb = new AABB(x - (double)playerHalfWidth, y, z - (double)playerHalfWidth, x + (double)playerHalfWidth, y + (double)playerHeight, z + (double)playerHalfWidth);
        Vec3 torso = new Vec3(x, y, z);
        if (this.mc.level.noCollision((Entity)player, bb)) {
            player.setPosRaw(x, !this.dh.vrSettings.simulateFalling ? y : player.getY(), z);
            player.setBoundingBox(bb);
            player.fallDistance = 0.0f;
        } else if ((this.dh.vrSettings.walkUpBlocks && ((PlayerExtension)player).vivecraft$getMuhJumpFactor() == 1.0f || this.dh.climbTracker.isGrabbingLadder() && this.dh.vrSettings.realisticClimbEnabled) && player.fallDistance == 0.0f && !this.mc.level.noCollision((Entity)player, bbClimb = new AABB(torso.x - (shrunkClimbHalfWidth = (double)(playerHalfWidth - (climbShrink = player.getDimensions(player.getPose()).width() * 0.45f))), bb.minY, torso.z - shrunkClimbHalfWidth, torso.x + shrunkClimbHalfWidth, bb.maxY, torso.z + shrunkClimbHalfWidth))) {
            int extra = 0;
            if (player.onClimbable() && this.dh.vrSettings.realisticClimbEnabled) {
                extra = 6;
            }
            for (int i = 0; i <= 10 + extra; ++i) {
                if (!this.mc.level.noCollision((Entity)player, bb = bb.move(0.0, 0.1, 0.0))) continue;
                player.setPosRaw(x, bb.minY, z);
                player.setBoundingBox(bb);
                Vec3 dest = this.roomOrigin.add(0.0, (double)(0.1f * (float)(i + 1)), 0.0);
                this.setRoomOrigin(dest.x, dest.y, dest.z, false);
                player.fallDistance = 0.0f;
                ((PlayerExtension)player).vivecraft$stepSound(BlockPos.containing((Position)player.position()), player.position());
                break;
            }
        }
    }

    public Vec3 getEstimatedTorsoPosition(double x, double y, double z) {
        LocalPlayer player = this.mc.player;
        Vec3 look = player.getLookAngle();
        Vec3 forward = new Vec3(look.x, 0.0, look.z).normalize();
        float factor = (float)look.y * 0.25f;
        return new Vec3(x + forward.x * (double)factor, y + forward.y * (double)factor, z + forward.z * (double)factor);
    }

    public void blockDust(double x, double y, double z, int count, BlockPos bp, BlockState bs, float scale, float velScale) {
        for (int i = 0; i < count; ++i) {
            TerrainParticle terrainparticle = new TerrainParticle(this.mc.level, x, y, z, 0.0, 0.0, 0.0, bs);
            terrainparticle.setPower(velScale);
            this.mc.particleEngine.add(terrainparticle.scale(scale));
        }
    }

    public void updateFreeMove() {
        if (this.dh.teleportTracker.isAiming()) {
            this.isFreeMoveCurrent = false;
        }
        if (this.mc.player.input != null && (this.mc.player.input.forwardImpulse != 0.0f || this.mc.player.input.leftImpulse != 0.0f)) {
            this.isFreeMoveCurrent = true;
        }
        this.updateTeleportKeys();
    }

    public boolean getFreeMove() {
        if (this.dh.vrSettings.seated) {
            return this.dh.vrSettings.seatedFreeMove || !this.isTeleportEnabled();
        }
        return this.isFreeMoveCurrent || this.dh.vrSettings.forceStandingFreeMove;
    }

    public String toString() {
        return "VRPlayer:\n    origin: %s\n    rotation: %.3f\n    scale: %.3f\n    room_pre: %s\n    world_pre: %s\n    world_post: %s\n    world_render: %s".formatted(this.roomOrigin, Float.valueOf(this.dh.vrSettings.worldRotation), Float.valueOf(this.worldScale), this.vrdata_room_pre, this.vrdata_world_pre, this.vrdata_world_post, this.vrdata_world_render);
    }

    public Vec3 getRightClickLookOverride(Player entity, int c) {
        ItemStack itemStack;
        Vec3 out = entity.getLookAngle();
        if (((GameRendererExtension)this.mc.gameRenderer).vivecraft$getCrossVec() != null) {
            out = entity.getEyePosition(1.0f).subtract(((GameRendererExtension)this.mc.gameRenderer).vivecraft$getCrossVec()).normalize().reverse();
        }
        ItemStack itemStack2 = itemStack = c == 0 ? entity.getMainHandItem() : entity.getOffhandItem();
        if (itemStack.getItem() instanceof SnowballItem || itemStack.getItem() instanceof EggItem || itemStack.getItem() instanceof SpawnEggItem || itemStack.getItem() instanceof PotionItem || itemStack.getItem() instanceof BowItem || itemStack.getItem() instanceof FishingRodItem || itemStack.getItem() instanceof WindChargeItem || itemStack.getItem() instanceof CrossbowItem && CrossbowItem.isCharged((ItemStack)itemStack) || itemStack.is(ViveItemTags.VIVECRAFT_THROW_ITEMS)) {
            VRData data = this.dh.vrPlayer.vrdata_world_pre;
            Vector3fc aim = this.dh.bowTracker.getAimVector();
            if (this.dh.bowTracker.isNotched() && aim != null && aim.lengthSquared() > 0.0f) {
                out = new Vec3((double)aim.x(), (double)aim.y(), (double)aim.z());
            } else if (this.dh.vrSettings.aimDevice != VRSettings.AimDevice.HMD) {
                out = new Vec3(data.getController(c).getDirection());
            }
        } else if (itemStack.getItem() == Items.BUCKET && this.dh.blockModule.bukkit[c] && ClientNetworking.getActiveBodyPart().ordinal() == c && ClientNetworking.IS_LAST_BODY_PART_AIM) {
            out = entity.getEyePosition(1.0f).subtract(this.dh.vrPlayer.vrdata_world_pre.getController(c).getPosition()).normalize().reverse();
        }
        return out;
    }

    public void doPermanentLookOverride(LocalPlayer player, VRData data) {
        if (player == null) {
            return;
        }
        if (player.isPassenger()) {
            Vector3f dir = VehicleTracker.getSteeringDirection(player);
            if (dir != null) {
                player.setXRot((float)Math.toDegrees(Math.asin(-dir.y / dir.length())));
                player.setYRot((float)Math.toDegrees(Math.atan2(-dir.x, dir.z)));
                player.setYHeadRot(player.getYRot());
            }
        } else if (player.isBlocking()) {
            if (player.getUsedItemHand() == InteractionHand.MAIN_HAND) {
                player.setYRot(data.getController(0).getYaw());
                player.setYHeadRot(player.getYRot());
                player.setXRot(-data.getController(0).getPitch());
            } else {
                player.setYRot(data.getController(1).getYaw());
                player.setYHeadRot(player.getYRot());
                player.setXRot(-data.getController(1).getPitch());
            }
        } else if (player.isSprinting() && (player.input.keyPresses.jump() || this.mc.options.keyJump.isDown()) || player.isFallFlying() || player.isSwimming() && player.zza > 0.0f) {
            VRSettings.FreeMove freeMoveType;
            VRSettings.FreeMove freeMove = freeMoveType = player.isFallFlying() && this.dh.vrSettings.vrFreeMoveFlyMode != VRSettings.FreeMove.AUTO ? this.dh.vrSettings.vrFreeMoveFlyMode : this.dh.vrSettings.vrFreeMoveMode;
            if (freeMoveType == VRSettings.FreeMove.CONTROLLER) {
                player.setYRot(data.getController(1).getYaw());
                player.setYHeadRot(player.getYRot());
                player.setXRot(-data.getController(1).getPitch());
            } else {
                player.setYRot(data.hmd.getYaw());
                player.setYHeadRot(player.getYRot());
                player.setXRot(-data.hmd.getPitch());
            }
        } else if (((GameRendererExtension)this.mc.gameRenderer).vivecraft$getCrossVec() != null) {
            Vec3 playerToCrosshair = player.getEyePosition(1.0f).subtract(((GameRendererExtension)this.mc.gameRenderer).vivecraft$getCrossVec());
            double what = playerToCrosshair.y / playerToCrosshair.length();
            if (what > 1.0) {
                what = 1.0;
            }
            if (what < -1.0) {
                what = -1.0;
            }
            float pitch = (float)Math.toDegrees(Math.asin(what));
            float yaw = (float)Math.toDegrees(Math.atan2(playerToCrosshair.x, -playerToCrosshair.z));
            player.setXRot(pitch);
            player.setYRot(yaw);
            player.setYHeadRot(yaw);
        } else {
            player.setYRot(data.hmd.getYaw());
            player.setYHeadRot(player.getYRot());
            player.setXRot(-data.hmd.getPitch());
        }
    }

    public Vec3 AimedPointAtDistance(VRData.VRDevicePose source, double distance) {
        Vec3 controllerPos = source.getPosition();
        Vector3f controllerDir = source.getDirection();
        return controllerPos.add((double)controllerDir.x * distance, (double)controllerDir.y * distance, (double)controllerDir.z * distance);
    }

    public HitResult rayTraceBlocksVR(VRData source, int controller, double hitDistance, boolean hitFluids) {
        Vec3 start = source.getController(controller).getPosition();
        Vec3 end = this.AimedPointAtDistance(source.getController(controller), hitDistance);
        return this.mc.level.clip(new ClipContext(start, end, ClipContext.Block.OUTLINE, hitFluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, (Entity)this.mc.player));
    }

    public boolean isTeleportSupported() {
        return !VRServerPerms.INSTANCE.noTeleportClient;
    }

    public boolean isTeleportOverridden() {
        return this.teleportOverride;
    }

    public boolean isTeleportEnabled() {
        boolean enabled;
        boolean bl = enabled = (!VRServerPerms.INSTANCE.noTeleportClient || this.teleportOverride) && ClientNetworking.SERVER_ALLOWS_DIRECT_TELEPORT;
        if (this.dh.vrSettings.seated) {
            return enabled;
        }
        return enabled && !this.dh.vrSettings.forceStandingFreeMove;
    }

    public void setTeleportOverride(boolean override) {
        this.teleportOverride = override;
        this.updateTeleportKeys();
    }

    public void updateTeleportKeys() {
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyTeleport).setEnabled(this.isTeleportEnabled());
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyTeleportFallback).setEnabled(!this.isTeleportEnabled());
    }
}

