/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.trackers.ClimbTracker;
import org.vivecraft.client_vr.settings.AutoCalibration;
import org.vivecraft.client_vr.settings.VRSettings;

public class JumpTracker
implements Tracker {
    public Vector3f[] latchStart = new Vector3f[]{new Vector3f(), new Vector3f()};
    public Vec3[] latchStartOrigin = new Vec3[]{Vec3.ZERO, Vec3.ZERO};
    public Vec3[] latchStartPlayer = new Vec3[]{Vec3.ZERO, Vec3.ZERO};
    private boolean c0Latched = false;
    private boolean c1Latched = false;
    private final Minecraft mc;
    private final ClientDataHolderVR dh;

    public JumpTracker(Minecraft mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    public boolean isClimbeyJump(LocalPlayer player) {
        return this.isActive(player) && JumpTracker.hasClimbeyJumpEquipped((Player)player);
    }

    public static boolean hasClimbeyJumpEquipped(Player player) {
        return ClientNetworking.SERVER_ALLOWS_CLIMBEY && JumpTracker.isBoots(player.getItemBySlot(EquipmentSlot.FEET));
    }

    public static boolean isBoots(ItemStack itemStack) {
        TranslatableContents translatableContent;
        ComponentContents componentContents;
        if (itemStack.isEmpty()) {
            return false;
        }
        if (!itemStack.has(DataComponents.CUSTOM_NAME)) {
            return false;
        }
        if (itemStack.getItem() != Items.LEATHER_BOOTS) {
            return false;
        }
        if (!itemStack.has(DataComponents.UNBREAKABLE)) {
            return false;
        }
        return itemStack.getHoverName().getString().equals("Jump Boots") || (componentContents = itemStack.getHoverName().getContents()) instanceof TranslatableContents && (translatableContent = (TranslatableContents)componentContents).getKey().equals("vivecraft.item.jumpboots");
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        if (this.dh.vrSettings.seated) {
            return false;
        }
        if (!this.dh.vrPlayer.getFreeMove() && !this.dh.vrSettings.simulateFalling) {
            return false;
        }
        if (this.dh.vrSettings.realisticJumpEnabled == VRSettings.RealisticJump.OFF) {
            return false;
        }
        if (player == null || !player.isAlive()) {
            return false;
        }
        if (this.mc.gameMode == null) {
            return false;
        }
        if (player.isInWater() || player.isInLava() || !player.onGround()) {
            return false;
        }
        return !player.isShiftKeyDown() && !player.isPassenger();
    }

    public boolean isjumping() {
        return this.c1Latched || this.c0Latched;
    }

    @Override
    public void idleProcess(LocalPlayer player) {
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyClimbeyJump).setEnabled(JumpTracker.hasClimbeyJumpEquipped((Player)player) && (this.isActive(player) || ClimbTracker.hasClimbeyClimbEquipped((Player)player) && this.dh.climbTracker.isGrabbingLadder()));
    }

    @Override
    public void inactiveProcess(LocalPlayer player) {
        this.c1Latched = false;
        this.c0Latched = false;
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(LocalPlayer player) {
        boolean climbeyEquipped = JumpTracker.hasClimbeyJumpEquipped((Player)player);
        if (climbeyEquipped) {
            boolean[] ok = new boolean[2];
            for (int c = 0; c < 2; ++c) {
                ok[c] = VivecraftVRMod.INSTANCE.keyClimbeyJump.isDown();
            }
            boolean jump = false;
            if (!ok[0] && this.c0Latched) {
                this.dh.vr.triggerHapticPulse(0, 200);
                jump = true;
            }
            Vector3f now = this.dh.vrPlayer.vrdata_room_pre.getController(0).getPositionF().lerp((Vector3fc)this.dh.vrPlayer.vrdata_room_pre.getController(1).getPositionF(), 0.5f);
            if (ok[0] && !this.c0Latched) {
                this.latchStart[0].set((Vector3fc)now);
                this.latchStartOrigin[0] = this.dh.vrPlayer.vrdata_world_pre.origin;
                this.latchStartPlayer[0] = this.mc.player.position();
                this.dh.vr.triggerHapticPulse(0, 1000);
            }
            if (!ok[1] && this.c1Latched) {
                this.dh.vr.triggerHapticPulse(1, 200);
                jump = true;
            }
            if (ok[1] && !this.c1Latched) {
                this.latchStart[1].set((Vector3fc)now);
                this.latchStartOrigin[1] = this.dh.vrPlayer.vrdata_world_pre.origin;
                this.latchStartPlayer[1] = this.mc.player.position();
                this.dh.vr.triggerHapticPulse(1, 1000);
            }
            this.c0Latched = ok[0];
            this.c1Latched = ok[1];
            int c = 0;
            Vector3f delta = now.sub((Vector3fc)this.latchStart[c], new Vector3f());
            delta = delta.rotateY(this.dh.vrPlayer.vrdata_world_pre.rotation_radians);
            if (!jump && this.isjumping()) {
                this.dh.vr.triggerHapticPulse(0, 200);
                this.dh.vr.triggerHapticPulse(1, 200);
            }
            if (jump) {
                this.dh.climbTracker.forceActivate = true;
                Vector3f movement = this.dh.vr.controllerHistory[0].netMovement(0.3).add((Vector3fc)this.dh.vr.controllerHistory[1].netMovement(0.3));
                float speed = this.dh.vr.controllerHistory[0].averageSpeed(0.3) + this.dh.vr.controllerHistory[1].averageSpeed(0.3) * 0.5f;
                movement.mul(0.33f * speed);
                float limit = 0.66f;
                if (movement.length() > 0.66f) {
                    movement.mul(0.66f / movement.length());
                }
                if (player.hasEffect(MobEffects.JUMP)) {
                    movement.mul((float)player.getEffect(MobEffects.JUMP).getAmplifier() + 1.5f);
                }
                movement.rotateY(this.dh.vrPlayer.vrdata_world_pre.rotation_radians);
                Vec3 lastPosition = this.mc.player.position().subtract((double)delta.x, (double)delta.y, (double)delta.z);
                if (delta.y < 0.0f && movement.y < 0.0f) {
                    player.setDeltaMovement(player.getDeltaMovement().x - (double)movement.x * 1.25, (double)(-movement.y), player.getDeltaMovement().z - (double)movement.z * 1.25);
                    player.xOld = lastPosition.x;
                    player.yOld = lastPosition.y;
                    player.zOld = lastPosition.z;
                    lastPosition = lastPosition.add(player.getDeltaMovement());
                    player.setPos(lastPosition.x, lastPosition.y, lastPosition.z);
                    this.dh.vrPlayer.snapRoomOriginToPlayerEntity((Entity)player, false, true);
                    this.mc.player.causeFoodExhaustion(0.3f);
                    this.mc.player.setOnGround(false);
                } else {
                    this.dh.vrPlayer.snapRoomOriginToPlayerEntity((Entity)player, false, true);
                }
            } else if (this.isjumping()) {
                Vec3 thing = this.latchStartOrigin[0].subtract(this.latchStartPlayer[0]).add(this.mc.player.position()).subtract((double)delta.x, (double)delta.y, (double)delta.z);
                this.dh.vrPlayer.setRoomOrigin(thing.x, thing.y, thing.z, false);
            }
        }
        if ((!climbeyEquipped || this.dh.vrSettings.realisticJumpEnabled == VRSettings.RealisticJump.ON) && (double)this.dh.vr.hmdPivotHistory.netMovement((double)0.25).y > 0.1 && this.dh.vr.hmdPivotHistory.latest().y() - AutoCalibration.getPlayerHeight() > this.dh.vrSettings.jumpThreshold) {
            player.jumpFromGround();
        }
    }
}

