/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.network.packet.c2s;

import net.minecraft.network.FriendlyByteBuf;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.common.network.packet.PayloadIdentifier;
import org.vivecraft.common.network.packet.c2s.VivecraftPayloadC2S;

public record ActiveBodyPartPayloadC2S(VRBodyPart bodyPart, boolean useForAim) implements VivecraftPayloadC2S
{
    @Override
    public PayloadIdentifier payloadId() {
        return PayloadIdentifier.ACTIVEHAND;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeByte(this.payloadId().ordinal());
        buffer.writeByte(this.bodyPart.ordinal());
        if (ClientNetworking.USED_NETWORK_VERSION >= 3) {
            buffer.writeBoolean(this.useForAim);
        }
    }

    public static ActiveBodyPartPayloadC2S read(FriendlyByteBuf buffer) {
        VRBodyPart bodyPart = VRBodyPart.values()[buffer.readByte()];
        boolean useForAim = false;
        if (buffer.readableBytes() > 0) {
            useForAim = buffer.readBoolean();
        }
        return new ActiveBodyPartPayloadC2S(bodyPart, useForAim);
    }
}

